/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassAbstractDelegate;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OGlobalProperty;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyEmbedded;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchemaEmbedded;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.schema.clusterselection.OClusterSelectionStrategy;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;

public class OClassEmbedded
extends OClassImpl {
    protected OClassEmbedded(OSchemaShared iOwner, String iName) {
        super(iOwner, iName);
    }

    protected OClassEmbedded(OSchemaShared iOwner, String iName, int[] iClusterIds) {
        super(iOwner, iName, iClusterIds);
    }

    protected OClassEmbedded(OSchemaShared iOwner, ODocument iDocument, String iName) {
        super(iOwner, iDocument, iName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OProperty addProperty(final String propertyName, final OType type, final OType linkedType, final OClass linkedClass, final boolean unsafe) {
        if (type == null) {
            throw new OSchemaException("Property type not defined.");
        }
        if (propertyName == null || propertyName.length() == 0) {
            throw new OSchemaException("Property name is null or empty");
        }
        ODatabaseDocumentInternal database = this.getDatabase();
        this.validatePropertyName(propertyName);
        if (database.getTransaction().isActive()) {
            throw new OSchemaException("Cannot create property '" + propertyName + "' inside a transaction");
        }
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        if (linkedType != null) {
            OPropertyImpl.checkLinkTypeSupport(type);
        }
        if (linkedClass != null) {
            OPropertyImpl.checkSupportLinkedClass(type);
        }
        this.acquireSchemaWriteLock();
        try {
            OProperty oProperty = (OProperty)OScenarioThreadLocal.executeAsDistributed((Callable<? extends Object>)new Callable<OProperty>(){

                @Override
                public OProperty call() throws Exception {
                    return OClassEmbedded.this.addPropertyInternal(propertyName, type, linkedType, linkedClass, unsafe);
                }
            });
            return oProperty;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public OClassImpl setEncryption(String iValue) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.setEncryptionInternal(database, iValue);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass setClusterSelection(String value) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.setClusterSelectionInternal(value);
            OClassEmbedded oClassEmbedded = this;
            return oClassEmbedded;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    public void setClusterSelectionInternal(String clusterSelection) {
        if (this.clusterSelection.getName().equals(clusterSelection)) {
            return;
        }
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.clusterSelection = (OClusterSelectionStrategy)this.owner.getClusterSelectionFactory().newInstance(clusterSelection);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClassImpl setCustom(String name, String value) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.setCustomInternal(name, value);
            OClassEmbedded oClassEmbedded = this;
            return oClassEmbedded;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public void clearCustom() {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.clearCustomInternal();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    protected void clearCustomInternal() {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.customFields = null;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass setSuperClasses(List<? extends OClass> classes) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        if (classes != null) {
            ArrayList<OClass> toCheck = new ArrayList<OClass>(classes);
            toCheck.add(this);
            OClassEmbedded.checkParametersConflict(toCheck);
        }
        this.acquireSchemaWriteLock();
        try {
            this.setSuperClassesInternal(classes);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    protected OClass removeBaseClassInternal(OClass baseClass) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            if (this.subclasses == null) {
                OClassEmbedded oClassEmbedded = this;
                return oClassEmbedded;
            }
            if (this.subclasses.remove(baseClass)) {
                this.removePolymorphicClusterIds((OClassImpl)baseClass);
            }
            OClassEmbedded oClassEmbedded = this;
            return oClassEmbedded;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public OClass addSuperClass(OClass superClass) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.checkParametersConflict(superClass);
        this.acquireSchemaWriteLock();
        try {
            this.addSuperClassInternal(database, superClass);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSuperClassInternal(ODatabaseDocumentInternal database, OClass superClass) {
        this.acquireSchemaWriteLock();
        try {
            OClassImpl cls = superClass instanceof OClassAbstractDelegate ? (OClassImpl)((OClassAbstractDelegate)superClass).delegate : (OClassImpl)superClass;
            if (cls != null) {
                OSecurityUser user = database.getUser();
                if (user != null) {
                    user.allow(ORule.ResourceGeneric.CLASS, cls.getName(), ORole.PERMISSION_UPDATE);
                }
                if (this.superClasses.contains(superClass)) {
                    throw new OSchemaException("Class: '" + this.getName() + "' already has the class '" + superClass.getName() + "' as superclass");
                }
                cls.addBaseClass(this);
                this.superClasses.add(cls);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public OClass removeSuperClass(OClass superClass) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.removeSuperClassInternal(superClass);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    protected void removeSuperClassInternal(OClass superClass) {
        this.acquireSchemaWriteLock();
        try {
            OClassImpl cls = superClass instanceof OClassAbstractDelegate ? (OClassImpl)((OClassAbstractDelegate)superClass).delegate : (OClassImpl)superClass;
            if (this.superClasses.contains(cls)) {
                if (cls != null) {
                    cls.removeBaseClassInternal(this);
                }
                this.superClasses.remove(superClass);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    protected void setSuperClassesInternal(List<? extends OClass> classes) {
        ArrayList<OClassImpl> newSuperClasses = new ArrayList<OClassImpl>();
        for (OClass oClass : classes) {
            OClassImpl cls = oClass instanceof OClassAbstractDelegate ? (OClassImpl)((OClassAbstractDelegate)oClass).delegate : (OClassImpl)oClass;
            if (newSuperClasses.contains(cls)) {
                throw new OSchemaException("Duplicated superclass '" + cls.getName() + "'");
            }
            newSuperClasses.add(cls);
        }
        ArrayList toAddList = new ArrayList(newSuperClasses);
        toAddList.removeAll(this.superClasses);
        ArrayList arrayList = new ArrayList(this.superClasses);
        arrayList.removeAll(newSuperClasses);
        for (OClassImpl toRemove : arrayList) {
            toRemove.removeBaseClassInternal(this);
        }
        for (OClassImpl addTo : toAddList) {
            addTo.addBaseClass(this);
        }
        this.superClasses.clear();
        this.superClasses.addAll(newSuperClasses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass setName(String name) {
        if (this.getName().equals(name)) {
            return this;
        }
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        Character wrongCharacter = OSchemaShared.checkClassNameIfValid(name);
        OClass oClass = database.getMetadata().getSchema().getClass(name);
        if (oClass != null) {
            String error = String.format("Cannot rename class %s to %s. A Class with name %s exists", this.name, name, name);
            throw new OSchemaException(error);
        }
        if (wrongCharacter != null) {
            throw new OSchemaException("Invalid class name found. Character '" + wrongCharacter + "' cannot be used in class name '" + name + "'");
        }
        this.acquireSchemaWriteLock();
        try {
            this.setNameInternal(database, name);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setNameInternal(ODatabaseDocumentInternal database, String name) {
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            String oldName = this.name;
            this.owner.changeClassName(database, this.name, name, this);
            this.name = name;
            this.renameCluster(oldName, this.name);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public void setDefaultClusterId(int defaultClusterId) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.defaultClusterId = defaultClusterId;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OClass addClusterIdInternal(ODatabaseDocumentInternal database, int clusterId) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.owner.checkClusterCanBeAdded(clusterId, this);
            for (int currId : this.clusterIds) {
                if (currId != clusterId) continue;
                OClassEmbedded oClassEmbedded = this;
                return oClassEmbedded;
            }
            this.clusterIds = OArrays.copyOf(this.clusterIds, this.clusterIds.length + 1);
            this.clusterIds[this.clusterIds.length - 1] = clusterId;
            Arrays.sort(this.clusterIds);
            this.addPolymorphicClusterId(clusterId);
            if (this.defaultClusterId == -1) {
                this.defaultClusterId = clusterId;
            }
            ((OSchemaEmbedded)this.owner).addClusterForClass(database, clusterId, this);
            OClassEmbedded oClassEmbedded = this;
            return oClassEmbedded;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public OClass setShortName(String shortName) {
        if (shortName != null && (shortName = shortName.trim()).isEmpty()) {
            shortName = null;
        }
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.setShortNameInternal(database, shortName);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setShortNameInternal(ODatabaseDocumentInternal database, String iShortName) {
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            String oldName = null;
            if (this.shortName != null) {
                oldName = this.shortName;
            }
            this.owner.changeClassName(database, oldName, iShortName, this);
            this.shortName = iShortName;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    protected OPropertyImpl createPropertyInstance(ODocument p) {
        return new OPropertyEmbedded((OClassImpl)this, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPropertyImpl addPropertyInternal(String name, OType type, OType linkedType, OClass linkedClass, boolean unsafe) {
        OPropertyEmbedded prop;
        if (name == null || name.length() == 0) {
            throw new OSchemaException("Found property name null");
        }
        if (!unsafe) {
            this.checkPersistentPropertyType(this.getDatabase(), name, type, linkedClass);
        }
        if (linkedType != null) {
            OPropertyImpl.checkLinkTypeSupport(type);
        }
        if (linkedClass != null) {
            OPropertyImpl.checkSupportLinkedClass(type);
        }
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            if (this.properties.containsKey(name)) {
                throw new OSchemaException("Class '" + this.name + "' already has property '" + name + "'");
            }
            OGlobalProperty global = this.owner.findOrCreateGlobalProperty(name, type);
            prop = this.createPropertyInstance(global);
            this.properties.put(name, prop);
            if (linkedType != null) {
                prop.setLinkedTypeInternal(linkedType);
            } else if (linkedClass != null) {
                prop.setLinkedClassInternal(linkedClass);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        if (prop != null && !unsafe) {
            this.fireDatabaseMigration(this.getDatabase(), name, type);
        }
        return prop;
    }

    protected OPropertyEmbedded createPropertyInstance(OGlobalProperty global) {
        return new OPropertyEmbedded((OClassImpl)this, global);
    }

    @Override
    public OClass truncateCluster(String clusterName) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_DELETE, (Object)this.name);
        this.acquireSchemaReadLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            this.truncateClusterInternal(clusterName, database);
        }
        finally {
            this.releaseSchemaReadLock();
        }
        return this;
    }

    @Override
    public OClass setStrictMode(boolean isStrict) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.setStrictModeInternal(isStrict);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    protected void setStrictModeInternal(boolean iStrict) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.strictMode = iStrict;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public OClass setDescription(String iDescription) {
        if (iDescription != null && (iDescription = iDescription.trim()).isEmpty()) {
            iDescription = null;
        }
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.setDescriptionInternal(iDescription);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    protected void setDescriptionInternal(String iDescription) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.description = iDescription;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public OClass addClusterId(int clusterId) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        if (this.isAbstract()) {
            throw new OSchemaException("Impossible to associate a cluster to an abstract class class");
        }
        this.acquireSchemaWriteLock();
        try {
            this.addClusterIdInternal(database, clusterId);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public OClass removeClusterId(int clusterId) {
        return this.removeClusterId(clusterId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClass removeClusterId(int clusterId, boolean force) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        if (!force && this.clusterIds.length == 1 && clusterId == this.clusterIds[0]) {
            throw new ODatabaseException(" Impossible to remove the last cluster of class '" + this.getName() + "' drop the class instead");
        }
        this.acquireSchemaWriteLock();
        try {
            this.removeClusterIdInternal(database, clusterId);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OClass removeClusterIdInternal(ODatabaseDocumentInternal database, int clusterToRemove) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            boolean found = false;
            for (int clusterId : this.clusterIds) {
                if (clusterId != clusterToRemove) continue;
                found = true;
                break;
            }
            if (found) {
                int[] newClusterIds = new int[this.clusterIds.length - 1];
                int k = 0;
                for (int i = 0; i < this.clusterIds.length; ++i) {
                    if (this.clusterIds[i] == clusterToRemove) continue;
                    newClusterIds[k] = this.clusterIds[i];
                    ++k;
                }
                this.clusterIds = newClusterIds;
                this.removePolymorphicClusterId(clusterToRemove);
            }
            if (this.defaultClusterId == clusterToRemove) {
                this.defaultClusterId = this.clusterIds.length >= 1 ? this.clusterIds[0] : -1;
            }
            ((OSchemaEmbedded)this.owner).removeClusterForClass(database, clusterToRemove, this);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public void dropProperty(String propertyName) {
        ODatabaseDocumentInternal database = this.getDatabase();
        if (database.getTransaction().isActive()) {
            throw new IllegalStateException("Cannot drop a property inside a transaction");
        }
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_DELETE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            if (!this.properties.containsKey(propertyName)) {
                throw new OSchemaException("Property '" + propertyName + "' not found in class " + this.name + "'");
            }
            OScenarioThreadLocal.executeAsDistributed(() -> {
                this.dropPropertyInternal(database, propertyName);
                return null;
            });
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropPropertyInternal(ODatabaseDocumentInternal database, String iPropertyName) {
        if (database.getTransaction().isActive()) {
            throw new IllegalStateException("Cannot drop a property inside a transaction");
        }
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_DELETE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            OProperty prop = (OProperty)this.properties.remove(iPropertyName);
            if (prop == null) {
                throw new OSchemaException("Property '" + iPropertyName + "' not found in class " + this.name + "'");
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass addCluster(String clusterNameOrId) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        if (this.isAbstract()) {
            throw new OSchemaException("Impossible to associate a cluster to an abstract class class");
        }
        this.acquireSchemaWriteLock();
        try {
            int clusterId = this.owner.createClusterIfNeeded(database, clusterNameOrId);
            this.addClusterIdInternal(database, clusterId);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public OClass setOverSize(float overSize) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.setOverSizeInternal(database, overSize);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    protected void setOverSizeInternal(ODatabaseDocumentInternal database, float overSize) {
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.overSize = overSize;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public OClass setAbstract(boolean isAbstract) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.setAbstractInternal(database, isAbstract);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    protected void setCustomInternal(String name, String value) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            if (this.customFields == null) {
                this.customFields = new HashMap();
            }
            if (value == null || "null".equalsIgnoreCase(value)) {
                this.customFields.remove(name);
            } else {
                this.customFields.put(name, value);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAbstractInternal(ODatabaseDocumentInternal database, boolean isAbstract) {
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            if (isAbstract) {
                if (this.defaultClusterId != -1) {
                    if (this.count() > 0L) {
                        throw new IllegalStateException("Cannot set the class as abstract because contains records.");
                    }
                    this.tryDropCluster(this.defaultClusterId);
                    for (int clusterId : this.getClusterIds()) {
                        this.tryDropCluster(clusterId);
                        this.removePolymorphicClusterId(clusterId);
                        ((OSchemaEmbedded)this.owner).removeClusterForClass(database, clusterId, this);
                    }
                    this.setClusterIds(new int[]{-1});
                    this.defaultClusterId = -1;
                }
            } else {
                if (!this.abstractClass) {
                    return;
                }
                int clusterId = database.getClusterIdByName(this.name);
                if (clusterId == -1) {
                    clusterId = database.addCluster(this.name, new Object[0]);
                }
                this.clusterIds[0] = this.defaultClusterId = clusterId;
                this.polymorphicClusterIds = Arrays.copyOf(this.clusterIds, this.clusterIds.length);
                for (OClass clazz : this.getAllSubclasses()) {
                    if (clazz instanceof OClassImpl) {
                        this.addPolymorphicClusterIds((OClassImpl)clazz);
                        continue;
                    }
                    OLogManager.instance().warn((Object)this, "Warning: cannot set polymorphic cluster IDs for class " + this.name, new Object[0]);
                }
            }
            this.abstractClass = isAbstract;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void tryDropCluster(int clusterId) {
        if (this.name.toLowerCase(Locale.ENGLISH).equals(this.getDatabase().getClusterNameById(clusterId)) && this.getDatabase().countClusterElements(clusterId) == 0L) {
            this.getDatabase().getStorage().dropCluster(clusterId);
        }
    }
}

