/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.parser.OOrBlock;
import java.util.LinkedHashMap;
import java.util.Map;

public class OPredicateCache {
    private Map<String, OOrBlock> map;
    private int mapSize;

    public OPredicateCache(int size) {
        this.mapSize = size;
        this.map = new LinkedHashMap<String, OOrBlock>(size){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, OOrBlock> eldest) {
                return super.size() > OPredicateCache.this.mapSize;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String statement) {
        if (OGlobalConfiguration.STATEMENT_CACHE_SIZE.getValueAsInteger() == 0) {
            return false;
        }
        Map<String, OOrBlock> map = this.map;
        synchronized (map) {
            return this.map.containsKey(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OOrBlock get(String statement) {
        OOrBlock result;
        if (OGlobalConfiguration.STATEMENT_CACHE_SIZE.getValueAsInteger() == 0) {
            return OPredicateCache.parse(statement);
        }
        Map<String, OOrBlock> map = this.map;
        synchronized (map) {
            result = this.map.remove(statement);
            if (result != null) {
                this.map.put(statement, result);
            }
        }
        if (result == null) {
            result = OPredicateCache.parse(statement);
            map = this.map;
            synchronized (map) {
                this.map.put(statement, result);
            }
        }
        return result.copy();
    }

    protected static OOrBlock parse(String statement) throws OCommandSQLParsingException {
        return OSQLEngine.parsePredicate(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (OGlobalConfiguration.STATEMENT_CACHE_SIZE.getValueAsInteger() == 0) {
            return;
        }
        Map<String, OOrBlock> map = this.map;
        synchronized (map) {
            this.map.clear();
        }
    }
}

