/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.OPredicateCache;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OSecurityPolicy;
import com.orientechnologies.orient.core.metadata.security.OSecurityResource;
import com.orientechnologies.orient.core.metadata.security.OSecurityResourceClass;
import com.orientechnologies.orient.core.metadata.security.OSecurityResourceFunction;
import com.orientechnologies.orient.core.metadata.security.OSecurityResourceProperty;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.metadata.security.OSecurityShared;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.parser.OAndBlock;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OOrBlock;
import java.util.Map;
import java.util.Set;

public class OSecurityEngine {
    private static OPredicateCache cache = new OPredicateCache(OGlobalConfiguration.STATEMENT_CACHE_SIZE.getValueAsInteger());

    static OBooleanExpression getPredicateForSecurityResource(ODatabaseSession session, OSecurityShared security, String resourceString, OSecurityPolicy.Scope scope) {
        OSecurityUser user = session.getUser();
        if (user == null) {
            return OBooleanExpression.FALSE;
        }
        Set<? extends OSecurityRole> roles = user.getRoles();
        if (roles == null || roles.size() == 0) {
            return OBooleanExpression.FALSE;
        }
        OSecurityResource resource = OSecurityEngine.getResourceFromString(resourceString);
        if (resource instanceof OSecurityResourceClass) {
            return OSecurityEngine.getPredicateForClass(session, security, (OSecurityResourceClass)resource, scope);
        }
        if (resource instanceof OSecurityResourceProperty) {
            return OSecurityEngine.getPredicateForProperty(session, security, (OSecurityResourceProperty)resource, scope);
        }
        if (resource instanceof OSecurityResourceFunction) {
            return OSecurityEngine.getPredicateForFunction(session, security, (OSecurityResourceFunction)resource, scope);
        }
        return OBooleanExpression.FALSE;
    }

    private static OBooleanExpression getPredicateForFunction(ODatabaseSession session, OSecurityShared security, OSecurityResourceFunction resource, OSecurityPolicy.Scope scope) {
        OFunction function = session.getMetadata().getFunctionLibrary().getFunction(resource.getFunctionName());
        Set<? extends OSecurityRole> roles = session.getUser().getRoles();
        if (roles == null || roles.size() == 0) {
            return null;
        }
        if (roles.size() == 1) {
            return OSecurityEngine.getPredicateForRoleHierarchy(session, security, roles.iterator().next(), function, scope);
        }
        OOrBlock result = new OOrBlock(-1);
        for (OSecurityRole oSecurityRole : roles) {
            OBooleanExpression roleBlock = OSecurityEngine.getPredicateForRoleHierarchy(session, security, oSecurityRole, function, scope);
            if (OBooleanExpression.TRUE.equals(roleBlock)) {
                return OBooleanExpression.TRUE;
            }
            result.getSubBlocks().add(roleBlock);
        }
        return result;
    }

    private static OBooleanExpression getPredicateForProperty(ODatabaseSession session, OSecurityShared security, OSecurityResourceProperty resource, OSecurityPolicy.Scope scope) {
        OClass clazz = session.getClass(resource.getClassName());
        if (clazz == null) {
            clazz = session.getMetadata().getSchema().getView(resource.getClassName());
        }
        String propertyName = resource.getPropertyName();
        Set<? extends OSecurityRole> roles = session.getUser().getRoles();
        if (roles == null || roles.size() == 0) {
            return null;
        }
        if (roles.size() == 1) {
            return OSecurityEngine.getPredicateForRoleHierarchy(session, security, roles.iterator().next(), clazz, propertyName, scope);
        }
        OOrBlock result = new OOrBlock(-1);
        for (OSecurityRole oSecurityRole : roles) {
            OBooleanExpression roleBlock = OSecurityEngine.getPredicateForRoleHierarchy(session, security, oSecurityRole, clazz, propertyName, scope);
            if (OBooleanExpression.TRUE.equals(roleBlock)) {
                return OBooleanExpression.TRUE;
            }
            result.getSubBlocks().add(roleBlock);
        }
        return result;
    }

    private static OBooleanExpression getPredicateForClass(ODatabaseSession session, OSecurityShared security, OSecurityResourceClass resource, OSecurityPolicy.Scope scope) {
        OClass clazz = session.getClass(resource.getClassName());
        if (clazz == null) {
            return OBooleanExpression.TRUE;
        }
        Set<? extends OSecurityRole> roles = session.getUser().getRoles();
        if (roles == null || roles.size() == 0) {
            return null;
        }
        if (roles.size() == 1) {
            return OSecurityEngine.getPredicateForRoleHierarchy(session, security, roles.iterator().next(), clazz, scope);
        }
        OOrBlock result = new OOrBlock(-1);
        for (OSecurityRole oSecurityRole : roles) {
            OBooleanExpression roleBlock = OSecurityEngine.getPredicateForRoleHierarchy(session, security, oSecurityRole, clazz, scope);
            if (OBooleanExpression.TRUE.equals(roleBlock)) {
                return OBooleanExpression.TRUE;
            }
            result.getSubBlocks().add(roleBlock);
        }
        return result;
    }

    private static OBooleanExpression getPredicateForRoleHierarchy(ODatabaseSession session, OSecurityShared security, OSecurityRole role, OFunction function, OSecurityPolicy.Scope scope) {
        OBooleanExpression result = OSecurityEngine.getPredicateForFunction(session, security, role, function, scope);
        if (result != null) {
            return result;
        }
        if (role.getParentRole() != null) {
            return OSecurityEngine.getPredicateForRoleHierarchy(session, security, role.getParentRole(), function, scope);
        }
        return OBooleanExpression.FALSE;
    }

    private static OBooleanExpression getPredicateForFunction(ODatabaseSession session, OSecurityShared security, OSecurityRole role, OFunction clazz, OSecurityPolicy.Scope scope) {
        String predicateString;
        String resource = "database.function." + clazz.getName();
        Map<String, OSecurityPolicy> definedPolicies = security.getSecurityPolicies(session, (ORole)role);
        OSecurityPolicy policy = definedPolicies.get(resource);
        String string = predicateString = policy != null ? policy.get(scope) : null;
        if (predicateString == null) {
            OSecurityPolicy wildcardPolicy = definedPolicies.get("database.function.*");
            String string2 = predicateString = wildcardPolicy == null ? null : wildcardPolicy.get(scope);
        }
        if (predicateString != null) {
            return OSecurityEngine.parsePredicate(session, predicateString);
        }
        return OBooleanExpression.FALSE;
    }

    private static OBooleanExpression getPredicateForRoleHierarchy(ODatabaseSession session, OSecurityShared security, OSecurityRole role, OClass clazz, OSecurityPolicy.Scope scope) {
        OBooleanExpression result;
        if (role != null && (result = security.getPredicateFromCache(role.getName(), clazz.getName())) != null) {
            return result;
        }
        result = OSecurityEngine.getPredicateForClassHierarchy(session, security, role, clazz, scope);
        if (result != null) {
            return result;
        }
        if (role.getParentRole() != null) {
            result = OSecurityEngine.getPredicateForRoleHierarchy(session, security, role.getParentRole(), clazz, scope);
        }
        if (result == null) {
            result = OBooleanExpression.FALSE;
        }
        if (role != null) {
            security.putPredicateInCache(role.getName(), clazz.getName(), result);
        }
        return result;
    }

    private static OBooleanExpression getPredicateForRoleHierarchy(ODatabaseSession session, OSecurityShared security, OSecurityRole role, OClass clazz, String propertyName, OSecurityPolicy.Scope scope) {
        OBooleanExpression result;
        String cacheKey = "$CLASS$" + clazz.getName() + "$PROP$" + propertyName + "$" + (Object)((Object)scope);
        if (role != null && (result = security.getPredicateFromCache(role.getName(), cacheKey)) != null) {
            return result;
        }
        result = OSecurityEngine.getPredicateForClassHierarchy(session, security, role, clazz, propertyName, scope);
        if (result == null && role.getParentRole() != null) {
            result = OSecurityEngine.getPredicateForRoleHierarchy(session, security, role.getParentRole(), clazz, propertyName, scope);
        }
        if (result == null) {
            result = OBooleanExpression.FALSE;
        }
        if (role != null) {
            security.putPredicateInCache(role.getName(), cacheKey, result);
        }
        return result;
    }

    private static OBooleanExpression getPredicateForClassHierarchy(ODatabaseSession session, OSecurityShared security, OSecurityRole role, OClass clazz, OSecurityPolicy.Scope scope) {
        OSecurityPolicy wildcardPolicy;
        String predicateString;
        String resource = "database.class." + clazz.getName();
        Map<String, OSecurityPolicy> definedPolicies = security.getSecurityPolicies(session, role);
        OSecurityPolicy classPolicy = definedPolicies.get(resource);
        String string = predicateString = classPolicy != null ? classPolicy.get(scope) : null;
        if (predicateString == null && clazz.getSuperClasses().size() > 0) {
            if (clazz.getSuperClasses().size() == 1) {
                return OSecurityEngine.getPredicateForClassHierarchy(session, security, role, clazz.getSuperClasses().iterator().next(), scope);
            }
            OAndBlock result = new OAndBlock(-1);
            for (OClass superClass : clazz.getSuperClasses()) {
                OBooleanExpression superClassPredicate = OSecurityEngine.getPredicateForClassHierarchy(session, security, role, superClass, scope);
                if (superClassPredicate == null) {
                    return OBooleanExpression.FALSE;
                }
                result.getSubBlocks().add(superClassPredicate);
            }
            return result;
        }
        if (predicateString == null) {
            wildcardPolicy = definedPolicies.get("database.class.*");
            String string2 = predicateString = wildcardPolicy == null ? null : wildcardPolicy.get(scope);
        }
        if (predicateString == null) {
            wildcardPolicy = definedPolicies.get("*");
            String string3 = predicateString = wildcardPolicy == null ? null : wildcardPolicy.get(scope);
        }
        if (predicateString != null) {
            return OSecurityEngine.parsePredicate(session, predicateString);
        }
        return OBooleanExpression.FALSE;
    }

    private static OBooleanExpression getPredicateForClassHierarchy(ODatabaseSession session, OSecurityShared security, OSecurityRole role, OClass clazz, String propertyName, OSecurityPolicy.Scope scope) {
        OSecurityPolicy wildcardPolicy;
        String predicateString;
        String resource = "database.class." + clazz.getName() + "." + propertyName;
        Map<String, OSecurityPolicy> definedPolicies = security.getSecurityPolicies(session, role);
        OSecurityPolicy classPolicy = definedPolicies.get(resource);
        String string = predicateString = classPolicy != null ? classPolicy.get(scope) : null;
        if (predicateString == null && clazz.getSuperClasses().size() > 0) {
            if (clazz.getSuperClasses().size() == 1) {
                return OSecurityEngine.getPredicateForClassHierarchy(session, security, role, clazz.getSuperClasses().iterator().next(), propertyName, scope);
            }
            OAndBlock result = new OAndBlock(-1);
            for (OClass superClass : clazz.getSuperClasses()) {
                OBooleanExpression superClassPredicate = OSecurityEngine.getPredicateForClassHierarchy(session, security, role, superClass, propertyName, scope);
                if (superClassPredicate == null) {
                    return OBooleanExpression.TRUE;
                }
                result.getSubBlocks().add(superClassPredicate);
            }
            return result;
        }
        if (predicateString == null) {
            wildcardPolicy = definedPolicies.get("database.class." + clazz.getName() + ".*");
            String string2 = predicateString = wildcardPolicy == null ? null : wildcardPolicy.get(scope);
        }
        if (predicateString == null) {
            wildcardPolicy = definedPolicies.get("database.class.*." + propertyName);
            String string3 = predicateString = wildcardPolicy == null ? null : wildcardPolicy.get(scope);
        }
        if (predicateString == null) {
            wildcardPolicy = definedPolicies.get("database.class.*.*");
            String string4 = predicateString = wildcardPolicy == null ? null : wildcardPolicy.get(scope);
        }
        if (predicateString == null) {
            wildcardPolicy = definedPolicies.get("*");
            String string5 = predicateString = wildcardPolicy == null ? null : wildcardPolicy.get(scope);
        }
        if (predicateString != null) {
            return OSecurityEngine.parsePredicate(session, predicateString);
        }
        return OBooleanExpression.TRUE;
    }

    public static OBooleanExpression parsePredicate(ODatabaseSession session, String predicateString) {
        if ("true".equalsIgnoreCase(predicateString)) {
            return OBooleanExpression.TRUE;
        }
        if ("false".equalsIgnoreCase(predicateString)) {
            return OBooleanExpression.FALSE;
        }
        try {
            return cache.get(predicateString);
        }
        catch (Exception e) {
            System.out.println("Error parsing predicate: " + predicateString);
            throw e;
        }
    }

    static boolean evaluateSecuirtyPolicyPredicate(ODatabaseSession session, OBooleanExpression predicate, ORecord record) {
        if (OBooleanExpression.TRUE.equals(predicate)) {
            return true;
        }
        if (OBooleanExpression.FALSE.equals(predicate)) {
            return false;
        }
        if (predicate == null) {
            return true;
        }
        try {
            ODocument user = session.getUser().getDocument();
            return ((ODatabaseInternal)((Object)session)).getSharedContext().getOrientDB().executeNoAuthorization(session.getName(), db -> {
                OBasicCommandContext ctx = new OBasicCommandContext();
                ctx.setDatabase(db);
                ctx.setVariable("$currentUser", user);
                return predicate.evaluate(record, (OCommandContext)ctx);
            }).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OSecurityException("Cannot execute security predicate");
        }
    }

    static boolean evaluateSecuirtyPolicyPredicate(ODatabaseSession session, OBooleanExpression predicate, OResult record) {
        if (OBooleanExpression.TRUE.equals(predicate)) {
            return true;
        }
        if (OBooleanExpression.FALSE.equals(predicate)) {
            return false;
        }
        try {
            ODocument user = session.getUser().getDocument();
            return ((ODatabaseInternal)((Object)session)).getSharedContext().getOrientDB().executeNoAuthorization(session.getName(), db -> {
                OBasicCommandContext ctx = new OBasicCommandContext();
                ctx.setDatabase(db);
                ctx.setVariable("$currentUser", user);
                return predicate.evaluate(record, (OCommandContext)ctx);
            }).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OSecurityException("Cannot execute security predicate");
        }
    }

    private static OSecurityResource getResourceFromString(String resource) {
        return OSecurityResource.getInstance(resource);
    }
}

