/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;

public class OSecurityPolicy {
    private OElement element;

    public OSecurityPolicy(OElement element) {
        this.element = element;
    }

    public OElement getElement() {
        return this.element;
    }

    public void setElement(OElement element) {
        this.element = element;
    }

    public String getName() {
        return (String)this.element.getProperty("name");
    }

    public void setName(String name) {
        this.element.setProperty("name", name);
    }

    public boolean isActive() {
        return Boolean.TRUE.equals(this.element.getProperty("active"));
    }

    public void setActive(Boolean active) {
        this.element.setProperty("active", active);
    }

    public String getCreateRule() {
        return this.element == null ? null : (String)this.element.getProperty("create");
    }

    public void setCreateRule(String rule) throws IllegalArgumentException {
        this.validatePredicate(rule);
        this.element.setProperty("create", rule);
    }

    public String getReadRule() {
        return this.element == null ? null : (String)this.element.getProperty("read");
    }

    public void setReadRule(String rule) throws IllegalArgumentException {
        this.validatePredicate(rule);
        this.element.setProperty("read", rule);
    }

    public String getBeforeUpdateRule() {
        return this.element == null ? null : (String)this.element.getProperty("beforeUpdate");
    }

    public void setBeforeUpdateRule(String rule) throws IllegalArgumentException {
        this.validatePredicate(rule);
        this.element.setProperty("beforeUpdate", rule);
    }

    public String getAfterUpdateRule() {
        return this.element == null ? null : (String)this.element.getProperty("afterUpdate");
    }

    public void setAfterUpdateRule(String rule) throws IllegalArgumentException {
        this.validatePredicate(rule);
        this.element.setProperty("afterUpdate", rule);
    }

    public String getDeleteRule() {
        return this.element == null ? null : (String)this.element.getProperty("delete");
    }

    public void setDeleteRule(String rule) throws IllegalArgumentException {
        this.validatePredicate(rule);
        this.element.setProperty("delete", rule);
    }

    public String getExecuteRule() {
        return this.element == null ? null : (String)this.element.getProperty("execute");
    }

    public void setExecuteRule(String rule) throws IllegalArgumentException {
        this.validatePredicate(rule);
        this.element.setProperty("execute", rule);
    }

    public String get(Scope scope) {
        switch (scope) {
            case CREATE: {
                return this.getCreateRule();
            }
            case READ: {
                return this.getReadRule();
            }
            case BEFORE_UPDATE: {
                return this.getBeforeUpdateRule();
            }
            case AFTER_UPDATE: {
                return this.getAfterUpdateRule();
            }
            case DELETE: {
                return this.getDeleteRule();
            }
            case EXECUTE: {
                return this.getExecuteRule();
            }
        }
        throw new IllegalArgumentException();
    }

    protected void validatePredicate(String predicate) throws IllegalArgumentException {
        if (predicate == null || predicate.trim().length() == 0) {
            return;
        }
        try {
            OSQLEngine.parsePredicate(predicate);
        }
        catch (OCommandSQLParsingException ex) {
            throw new IllegalArgumentException("Invalid predicate: " + predicate);
        }
    }

    public static enum Scope {
        CREATE,
        READ,
        BEFORE_UPDATE,
        AFTER_UPDATE,
        DELETE,
        EXECUTE;

    }
}

