/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.metadata.security.OSecurityResourceAll;
import com.orientechnologies.orient.core.metadata.security.OSecurityResourceClass;
import com.orientechnologies.orient.core.metadata.security.OSecurityResourceCluster;
import com.orientechnologies.orient.core.metadata.security.OSecurityResourceDatabaseOp;
import com.orientechnologies.orient.core.metadata.security.OSecurityResourceFunction;
import com.orientechnologies.orient.core.metadata.security.OSecurityResourceProperty;
import com.orientechnologies.orient.core.metadata.security.OSecurityResourceSchema;
import com.orientechnologies.orient.core.metadata.security.OSecurityResourceServerOp;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.parser.OSecurityResourceSegment;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public abstract class OSecurityResource {
    private static Map<String, OSecurityResource> cache = new ConcurrentHashMap<String, OSecurityResource>();
    protected final String resourceString;

    public static OSecurityResource getInstance(String resource) {
        OSecurityResource result = cache.get(resource);
        if (result == null && (result = OSecurityResource.parseResource(resource)) != null) {
            cache.put(resource, result);
        }
        return result;
    }

    protected static OSecurityResource parseResource(String resource) {
        if (resource.equals("*")) {
            return OSecurityResourceAll.INSTANCE;
        }
        if (resource.equals("database.schema")) {
            return OSecurityResourceSchema.INSTANCE;
        }
        if (resource.equals("database.class.*")) {
            return OSecurityResourceClass.ALL_CLASSES;
        }
        if (resource.equals("database.class.*.*")) {
            return OSecurityResourceProperty.ALL_PROPERTIES;
        }
        if (resource.equals("database.cluster.*")) {
            return OSecurityResourceCluster.ALL_CLUSTERS;
        }
        if (resource.equals("database.systemclusters")) {
            return OSecurityResourceCluster.SYSTEM_CLUSTERS;
        }
        if (resource.equals("database.function.*")) {
            return OSecurityResourceFunction.ALL_FUNCTIONS;
        }
        if (resource.equals("database")) {
            return OSecurityResourceDatabaseOp.DB;
        }
        if (resource.equals("database.create")) {
            return OSecurityResourceDatabaseOp.CREATE;
        }
        if (resource.equals("database.copy")) {
            return OSecurityResourceDatabaseOp.COPY;
        }
        if (resource.equals("database.drop")) {
            return OSecurityResourceDatabaseOp.DROP;
        }
        if (resource.equals("database.exists")) {
            return OSecurityResourceDatabaseOp.EXISTS;
        }
        if (resource.equals("database.command")) {
            return OSecurityResourceDatabaseOp.COMMAND;
        }
        if (resource.equals("database.command.gremlin")) {
            return OSecurityResourceDatabaseOp.COMMAND_GREMLIN;
        }
        if (resource.equals("database.freeze")) {
            return OSecurityResourceDatabaseOp.FREEZE;
        }
        if (resource.equals("database.release")) {
            return OSecurityResourceDatabaseOp.RELEASE;
        }
        if (resource.equals("database.passthrough")) {
            return OSecurityResourceDatabaseOp.PASS_THROUGH;
        }
        if (resource.equals("database.bypassRestricted")) {
            return OSecurityResourceDatabaseOp.BYPASS_RESTRICTED;
        }
        if (resource.equals("database.hook.record")) {
            return OSecurityResourceDatabaseOp.HOOK_RECORD;
        }
        if (resource.equals("server")) {
            return OSecurityResourceServerOp.SERVER;
        }
        if (resource.equals("server.status")) {
            return OSecurityResourceServerOp.STATUS;
        }
        if (resource.equals("server.remove")) {
            return OSecurityResourceServerOp.REMOVE;
        }
        if (resource.equals("server.admin")) {
            return OSecurityResourceServerOp.ADMIN;
        }
        try {
            OSecurityResourceSegment parsed = OSQLEngine.parseSecurityResource(resource);
            if (resource.startsWith("database.class.")) {
                String className;
                OSecurityResourceSegment classElement = parsed.getNext().getNext();
                boolean allClasses = false;
                if (classElement.getIdentifier() != null) {
                    className = classElement.getIdentifier().getStringValue();
                } else {
                    className = null;
                    allClasses = true;
                }
                OSecurityResourceSegment propertyModifier = classElement.getNext();
                if (propertyModifier != null) {
                    if (propertyModifier.getNext() != null) {
                        throw new OSecurityException("Invalid resource: " + resource);
                    }
                    String propertyName = propertyModifier.getIdentifier().getStringValue();
                    if (allClasses) {
                        return new OSecurityResourceProperty(resource, propertyName);
                    }
                    return new OSecurityResourceProperty(resource, className, propertyName);
                }
                return new OSecurityResourceClass(resource, className);
            }
            if (resource.startsWith("database.cluster.")) {
                OSecurityResourceSegment clusterElement = parsed.getNext().getNext();
                String clusterName = clusterElement.getIdentifier().getStringValue();
                if (clusterElement.getNext() != null) {
                    throw new OSecurityException("Invalid resource: " + resource);
                }
                return new OSecurityResourceCluster(resource, clusterName);
            }
            if (resource.startsWith("database.function.")) {
                OSecurityResourceSegment functionElement = parsed.getNext().getNext();
                String functionName = functionElement.getIdentifier().getStringValue();
                if (functionElement.getNext() != null) {
                    throw new OSecurityException("Invalid resource: " + resource);
                }
                return new OSecurityResourceFunction(resource, functionName);
            }
            if (resource.startsWith("database.systemclusters.")) {
                OSecurityResourceSegment clusterElement = parsed.getNext().getNext();
                String clusterName = clusterElement.getIdentifier().getStringValue();
                if (clusterElement.getNext() != null) {
                    throw new OSecurityException("Invalid resource: " + resource);
                }
                return new OSecurityResourceCluster(resource, clusterName);
            }
            throw new OSecurityException("Invalid resource: " + resource);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new OSecurityException("Invalid resource: " + resource);
        }
    }

    public OSecurityResource(String resourceString) {
        this.resourceString = resourceString;
    }

    public String getResourceString() {
        return this.resourceString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OSecurityResource that = (OSecurityResource)o;
        return Objects.equals(this.resourceString, that.resourceString);
    }

    public int hashCode() {
        return Objects.hash(this.resourceString);
    }
}

