/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.ONullOutputListener;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORestrictedOperation;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurityEngine;
import com.orientechnologies.orient.core.metadata.security.OSecurityInternal;
import com.orientechnologies.orient.core.metadata.security.OSecurityPolicy;
import com.orientechnologies.orient.core.metadata.security.OSecurityResource;
import com.orientechnologies.orient.core.metadata.security.OSecurityResourceAll;
import com.orientechnologies.orient.core.metadata.security.OSecurityResourceClass;
import com.orientechnologies.orient.core.metadata.security.OSecurityResourceProperty;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class OSecurityShared
implements OSecurityInternal {
    private final AtomicLong version = new AtomicLong();
    public static final String RESTRICTED_CLASSNAME = "ORestricted";
    public static final String IDENTITY_CLASSNAME = "OIdentity";
    protected Map<String, Map<String, Boolean>> roleHasPredicateSecurityForClass;
    protected boolean skipRoleHasPredicateSecurityForClassUpdate = false;
    protected Map<String, Map<String, OBooleanExpression>> securityPredicateCache = new ConcurrentHashMap<String, Map<String, OBooleanExpression>>();
    protected Set<OSecurityResourceProperty> filteredProperties;
    @Deprecated
    public static final String ALLOW_ALL_FIELD = ORestrictedOperation.ALLOW_ALL.getFieldName();
    @Deprecated
    public static final String ALLOW_READ_FIELD = ORestrictedOperation.ALLOW_READ.getFieldName();
    @Deprecated
    public static final String ALLOW_UPDATE_FIELD = ORestrictedOperation.ALLOW_UPDATE.getFieldName();
    @Deprecated
    public static final String ALLOW_DELETE_FIELD = ORestrictedOperation.ALLOW_DELETE.getFieldName();
    public static final String ONCREATE_IDENTITY_TYPE = "onCreate.identityType";
    public static final String ONCREATE_FIELD = "onCreate.fields";
    public static final Set<String> ALLOW_FIELDS = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add(ORestrictedOperation.ALLOW_ALL.getFieldName());
            this.add(ORestrictedOperation.ALLOW_READ.getFieldName());
            this.add(ORestrictedOperation.ALLOW_UPDATE.getFieldName());
            this.add(ORestrictedOperation.ALLOW_DELETE.getFieldName());
        }
    });

    @Override
    public OIdentifiable allowRole(ODatabaseSession session, ODocument iDocument, ORestrictedOperation iOperation, String iRoleName) {
        ORID role = this.getRoleRID(session, iRoleName);
        if (role == null) {
            throw new IllegalArgumentException("Role '" + iRoleName + "' not found");
        }
        return this.allowIdentity(session, iDocument, iOperation.getFieldName(), role);
    }

    @Override
    public OIdentifiable allowUser(ODatabaseSession session, ODocument iDocument, ORestrictedOperation iOperation, String iUserName) {
        ORID user = this.getUserRID(session, iUserName);
        if (user == null) {
            throw new IllegalArgumentException("User '" + iUserName + "' not found");
        }
        return this.allowIdentity(session, iDocument, iOperation.getFieldName(), user);
    }

    @Override
    public OIdentifiable allowIdentity(ODatabaseSession session, ODocument iDocument, String iAllowFieldName, OIdentifiable iId) {
        Set field = (Set)iDocument.field(iAllowFieldName);
        if (field == null) {
            field = new ORecordLazySet(iDocument);
            iDocument.field(iAllowFieldName, field);
        }
        field.add(iId);
        return iId;
    }

    @Override
    public OIdentifiable denyUser(ODatabaseSession session, ODocument iDocument, ORestrictedOperation iOperation, String iUserName) {
        ORID user = this.getUserRID(session, iUserName);
        if (user == null) {
            throw new IllegalArgumentException("User '" + iUserName + "' not found");
        }
        return this.disallowIdentity(session, iDocument, iOperation.getFieldName(), user);
    }

    @Override
    public OIdentifiable denyRole(ODatabaseSession session, ODocument iDocument, ORestrictedOperation iOperation, String iRoleName) {
        ORID role = this.getRoleRID(session, iRoleName);
        if (role == null) {
            throw new IllegalArgumentException("Role '" + iRoleName + "' not found");
        }
        return this.disallowIdentity(session, iDocument, iOperation.getFieldName(), role);
    }

    @Override
    public OIdentifiable disallowIdentity(ODatabaseSession session, ODocument iDocument, String iAllowFieldName, OIdentifiable iId) {
        Set field = (Set)iDocument.field(iAllowFieldName);
        if (field != null) {
            field.remove(iId);
        }
        return iId;
    }

    @Override
    public boolean isAllowed(ODatabaseSession session, Set<OIdentifiable> iAllowAll, Set<OIdentifiable> iAllowOperation) {
        if ((iAllowAll == null || iAllowAll.isEmpty()) && (iAllowOperation == null || iAllowOperation.isEmpty())) {
            return false;
        }
        OSecurityUser currentUser = ODatabaseRecordThreadLocal.instance().get().getUser();
        if (currentUser != null && (iAllowAll == null || iAllowAll != null && !iAllowAll.contains(currentUser.getIdentity()))) {
            if (iAllowOperation != null && iAllowOperation.contains(currentUser.getIdentity())) {
                return true;
            }
            for (OSecurityRole oSecurityRole : currentUser.getRoles()) {
                if (iAllowAll != null && iAllowAll.contains(oSecurityRole.getIdentity())) {
                    return true;
                }
                if (iAllowOperation != null && iAllowOperation.contains(oSecurityRole.getIdentity())) {
                    return true;
                }
                for (OSecurityRole parentRole = oSecurityRole.getParentRole(); parentRole != null; parentRole = parentRole.getParentRole()) {
                    if (iAllowAll != null && iAllowAll.contains(parentRole.getIdentity())) {
                        return true;
                    }
                    if (iAllowOperation == null || !iAllowOperation.contains(parentRole.getIdentity())) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public OUser authenticate(ODatabaseSession session, String iUserName, String iUserPassword) {
        String dbName = session.getName();
        OUser user = this.getUser(session, iUserName);
        if (user == null) {
            throw new OSecurityAccessException(dbName, "User or password not valid for database: '" + dbName + "'");
        }
        if (user.getAccountStatus() != OSecurityUser.STATUSES.ACTIVE) {
            throw new OSecurityAccessException(dbName, "User '" + iUserName + "' is not active");
        }
        if (!(((ODatabaseDocumentInternal)session).getStorage() instanceof OStorageProxy) && !user.checkPassword(iUserPassword)) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
            throw new OSecurityAccessException(dbName, "User or password not valid for database: '" + dbName + "'");
        }
        return user;
    }

    @Override
    public OUser authenticate(ODatabaseSession session, OToken authToken) {
        String dbName = session.getName();
        if (!authToken.getIsValid()) {
            throw new OSecurityAccessException(dbName, "Token not valid");
        }
        OUser user = authToken.getUser((ODatabaseDocumentInternal)session);
        if (user == null && authToken.getUserName() != null) {
            user = this.getUser(session, authToken.getUserName());
        }
        if (user == null) {
            throw new OSecurityAccessException(dbName, "Authentication failed, could not load user from token");
        }
        if (user.getAccountStatus() != OSecurityUser.STATUSES.ACTIVE) {
            throw new OSecurityAccessException(dbName, "User '" + user.getName() + "' is not active");
        }
        return user;
    }

    @Override
    public OUser getUser(ODatabaseSession session, ORID iRecordId) {
        if (iRecordId == null) {
            return null;
        }
        ODocument result = (ODocument)session.load(iRecordId, "roles:1");
        if (!result.getClassName().equals("OUser")) {
            result = null;
        }
        return new OUser(result);
    }

    @Override
    public OUser createUser(ODatabaseSession session, String iUserName, String iUserPassword, String ... iRoles) {
        OUser user = new OUser(iUserName, iUserPassword);
        if (iRoles != null) {
            for (String r : iRoles) {
                user.addRole(r);
            }
        }
        return user.save();
    }

    @Override
    public OUser createUser(ODatabaseSession session, String userName, String userPassword, ORole ... roles) {
        OUser user = new OUser(userName, userPassword);
        if (roles != null) {
            for (ORole r : roles) {
                user.addRole(r);
            }
        }
        return user.save();
    }

    @Override
    public boolean dropUser(ODatabaseSession session, String iUserName) {
        Number removed = (Number)session.command("delete from OUser where name = ?", iUserName).next().getProperty("count");
        return removed != null && removed.intValue() > 0;
    }

    @Override
    public ORole getRole(ODatabaseSession session, OIdentifiable iRole) {
        OClass clazz;
        ODocument doc = (ODocument)iRole.getRecord();
        if (doc != null && (clazz = doc.getSchemaClass()) != null && clazz.isSubClassOf("ORole")) {
            return new ORole(doc);
        }
        return null;
    }

    @Override
    public ORole getRole(ODatabaseSession session, String iRoleName) {
        if (iRoleName == null) {
            return null;
        }
        try (OResultSet result = session.query("select from ORole where name = ? limit 1", iRoleName);){
            if (result.hasNext()) {
                ORole oRole = new ORole((ODocument)result.next().getElement().get());
                return oRole;
            }
        }
        return null;
    }

    public ORID getRoleRID(ODatabaseSession session, String iRoleName) {
        if (iRoleName == null) {
            return null;
        }
        try (OResultSet result = session.query("select @rid as rid from ORole where name = ? limit 1", iRoleName);){
            if (result.hasNext()) {
                ORID oRID = (ORID)result.next().getProperty("rid");
                return oRID;
            }
        }
        return null;
    }

    @Override
    public ORole createRole(ODatabaseSession session, String iRoleName, OSecurityRole.ALLOW_MODES iAllowMode) {
        return this.createRole(session, iRoleName, null, iAllowMode);
    }

    @Override
    public ORole createRole(ODatabaseSession session, String iRoleName, ORole iParent, OSecurityRole.ALLOW_MODES iAllowMode) {
        ORole role = new ORole(iRoleName, iParent, iAllowMode);
        return role.save();
    }

    @Override
    public boolean dropRole(ODatabaseSession session, String iRoleName) {
        Number removed = (Number)session.command("delete from ORole where name = '" + iRoleName + "'", new Object[0]).next().getProperty("count");
        return removed != null && removed.intValue() > 0;
    }

    @Override
    public List<ODocument> getAllUsers(ODatabaseSession session) {
        try (OResultSet rs = session.query("select from OUser", new Object[0]);){
            List<ODocument> list = rs.stream().map(e -> (ODocument)e.getElement().get()).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<ODocument> getAllRoles(ODatabaseSession session) {
        try (OResultSet rs = session.query("select from ORole", new Object[0]);){
            List<ODocument> list = rs.stream().map(e -> (ODocument)e.getElement().get()).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public Map<String, OSecurityPolicy> getSecurityPolicies(ODatabaseSession session, OSecurityRole role) {
        HashMap<String, OSecurityPolicy> result = new HashMap<String, OSecurityPolicy>();
        ODocument roleDoc = role.getDocument();
        if (roleDoc == null) {
            return result;
        }
        Map policies = (Map)roleDoc.getProperty("policies");
        if (policies == null) {
            return result;
        }
        policies.entrySet().forEach(x -> result.put((String)x.getKey(), new OSecurityPolicy((OElement)((OIdentifiable)x.getValue()).getRecord())));
        return result;
    }

    @Override
    public OSecurityPolicy getSecurityPolicy(ODatabaseSession session, OSecurityRole role, String resource) {
        resource = this.normalizeSecurityResource(session, resource);
        OElement roleDoc = (OElement)session.reload(role.getDocument(), null, false);
        if (roleDoc == null) {
            return null;
        }
        Map policies = (Map)roleDoc.getProperty("policies");
        if (policies == null) {
            return null;
        }
        OIdentifiable entry = (OIdentifiable)policies.get(resource);
        if (entry == null) {
            return null;
        }
        return new OSecurityPolicy((OElement)entry.getRecord());
    }

    public void setSecurityPolicyWithBitmask(ODatabaseSession session, OSecurityRole role, String resource, int legacyPolicy) {
        String policyName = "default_" + legacyPolicy;
        OSecurityPolicy policy = this.getSecurityPolicy(session, policyName);
        if (policy == null) {
            policy = this.createSecurityPolicy(session, policyName);
            policy.setCreateRule((legacyPolicy & ORole.PERMISSION_CREATE) > 0 ? "true" : "false");
            policy.setReadRule((legacyPolicy & ORole.PERMISSION_READ) > 0 ? "true" : "false");
            policy.setBeforeUpdateRule((legacyPolicy & ORole.PERMISSION_UPDATE) > 0 ? "true" : "false");
            policy.setAfterUpdateRule((legacyPolicy & ORole.PERMISSION_UPDATE) > 0 ? "true" : "false");
            policy.setDeleteRule((legacyPolicy & ORole.PERMISSION_DELETE) > 0 ? "true" : "false");
            policy.setExecuteRule((legacyPolicy & ORole.PERMISSION_EXECUTE) > 0 ? "true" : "false");
            this.saveSecurityPolicy(session, policy);
        }
        this.setSecurityPolicy(session, role, resource, policy);
    }

    @Override
    public void setSecurityPolicy(ODatabaseSession session, OSecurityRole role, String resource, OSecurityPolicy policy) {
        resource = this.normalizeSecurityResource(session, resource);
        OElement roleDoc = (OElement)session.load(role.getDocument().getIdentity());
        if (roleDoc == null) {
            return;
        }
        this.validatePolicyWithIndexes(session, resource);
        HashMap<String, OElement> policies = (HashMap<String, OElement>)roleDoc.getProperty("policies");
        if (policies == null) {
            policies = new HashMap<String, OElement>();
            roleDoc.setProperty("policies", policies);
        }
        policies.put(resource, policy.getElement());
        roleDoc = (OElement)session.save(roleDoc);
        if (role instanceof ORole) {
            ((ORole)role).reload();
        }
        this.updateAllFilteredProperties((ODatabaseDocumentInternal)session);
        this.initPredicateSecurityOptimizations(session);
    }

    private void validatePolicyWithIndexes(ODatabaseSession session, String resource) throws IllegalArgumentException {
        OSecurityResource res = OSecurityResource.getInstance(resource);
        if (res instanceof OSecurityResourceProperty) {
            String clazzName = ((OSecurityResourceProperty)res).getClassName();
            OClass clazz = session.getClass(clazzName);
            if (clazz == null) {
                return;
            }
            HashSet<OClass> allClasses = new HashSet<OClass>();
            allClasses.add(clazz);
            allClasses.addAll(clazz.getAllSubclasses());
            allClasses.addAll(clazz.getAllSuperClasses());
            for (OClass c : allClasses) {
                for (OIndex index : c.getIndexes()) {
                    List<String> indexFields = index.getDefinition().getFields();
                    if (indexFields.size() <= 1 || !indexFields.contains(((OSecurityResourceProperty)res).getPropertyName())) continue;
                    throw new IllegalArgumentException("Cannot bind security policy on " + resource + " because of existing composite indexes: " + index.getName());
                }
            }
        }
    }

    @Override
    public OSecurityPolicy createSecurityPolicy(ODatabaseSession session, String name) {
        OElement elem = session.newElement(OSecurityPolicy.class.getSimpleName());
        elem.setProperty("name", name);
        OSecurityPolicy policy = new OSecurityPolicy(elem);
        this.saveSecurityPolicy(session, policy);
        return policy;
    }

    @Override
    public OSecurityPolicy getSecurityPolicy(ODatabaseSession session, String name) {
        try (OResultSet rs = session.query("SELECT FROM " + OSecurityPolicy.class.getSimpleName() + " WHERE name = ?", name);){
            if (rs.hasNext()) {
                OResult result = rs.next();
                OSecurityPolicy oSecurityPolicy = new OSecurityPolicy(result.getElement().get());
                return oSecurityPolicy;
            }
        }
        return null;
    }

    @Override
    public void saveSecurityPolicy(ODatabaseSession session, OSecurityPolicy policy) {
        session.save(policy.getElement(), OSecurityPolicy.class.getSimpleName().toLowerCase(Locale.ENGLISH));
    }

    @Override
    public void deleteSecurityPolicy(ODatabaseSession session, String name) {
        session.command("DELETE FROM " + OSecurityPolicy.class.getSimpleName() + " WHERE name = ?", name);
    }

    @Override
    public void removeSecurityPolicy(ODatabaseSession session, ORole role, String resource) {
        resource = this.normalizeSecurityResource(session, resource);
        OElement roleDoc = (OElement)session.reload(role.getDocument(), null, false);
        if (roleDoc == null) {
            return;
        }
        Map policies = (Map)roleDoc.getProperty("policies");
        if (policies == null) {
            return;
        }
        policies.remove(resource);
        roleDoc.save();
        role.reload();
        this.updateAllFilteredProperties((ODatabaseDocumentInternal)session);
        this.initPredicateSecurityOptimizations(session);
    }

    private String normalizeSecurityResource(ODatabaseSession session, String resource) {
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OUser create(ODatabaseSession session) {
        OUser adminUser;
        if (!session.getMetadata().getSchema().getClasses().isEmpty()) {
            return null;
        }
        this.skipRoleHasPredicateSecurityForClassUpdate = true;
        try {
            adminUser = this.createMetadata(session);
            ORole readerRole = this.createRole(session, "reader", OSecurityRole.ALLOW_MODES.DENY_ALL_BUT);
            this.setSecurityPolicyWithBitmask(session, readerRole, "database.class.*.*", ORole.PERMISSION_ALL);
            readerRole.addRule(ORule.ResourceGeneric.DATABASE, null, ORole.PERMISSION_READ);
            readerRole.addRule(ORule.ResourceGeneric.SCHEMA, null, ORole.PERMISSION_READ);
            readerRole.addRule(ORule.ResourceGeneric.CLUSTER, "internal", ORole.PERMISSION_READ);
            readerRole.addRule(ORule.ResourceGeneric.CLUSTER, "orole", 0);
            readerRole.addRule(ORule.ResourceGeneric.CLUSTER, "ouser", 0);
            readerRole.addRule(ORule.ResourceGeneric.CLASS, null, ORole.PERMISSION_READ);
            readerRole.addRule(ORule.ResourceGeneric.CLASS, "OUser", 0);
            readerRole.addRule(ORule.ResourceGeneric.CLUSTER, null, ORole.PERMISSION_READ);
            readerRole.addRule(ORule.ResourceGeneric.COMMAND, null, ORole.PERMISSION_READ);
            readerRole.addRule(ORule.ResourceGeneric.RECORD_HOOK, null, ORole.PERMISSION_READ);
            readerRole.addRule(ORule.ResourceGeneric.FUNCTION, null, ORole.PERMISSION_READ);
            readerRole.addRule(ORule.ResourceGeneric.SYSTEM_CLUSTERS, null, 0);
            readerRole.save();
            this.setSecurityPolicyWithBitmask(session, readerRole, ORule.ResourceGeneric.DATABASE.getLegacyName(), ORole.PERMISSION_READ);
            this.setSecurityPolicyWithBitmask(session, readerRole, ORule.ResourceGeneric.SCHEMA.getLegacyName(), ORole.PERMISSION_READ);
            this.setSecurityPolicyWithBitmask(session, readerRole, ORule.ResourceGeneric.CLUSTER.getLegacyName() + "." + "internal", ORole.PERMISSION_READ);
            this.setSecurityPolicyWithBitmask(session, readerRole, ORule.ResourceGeneric.CLUSTER.getLegacyName() + ".orole", ORole.PERMISSION_READ);
            this.setSecurityPolicyWithBitmask(session, readerRole, ORule.ResourceGeneric.CLUSTER.getLegacyName() + ".ouser", ORole.PERMISSION_READ);
            this.setSecurityPolicyWithBitmask(session, readerRole, ORule.ResourceGeneric.CLASS.getLegacyName() + ".*", ORole.PERMISSION_READ);
            this.setSecurityPolicyWithBitmask(session, readerRole, ORule.ResourceGeneric.CLASS.getLegacyName() + ".OUser", ORole.PERMISSION_READ);
            this.setSecurityPolicyWithBitmask(session, readerRole, ORule.ResourceGeneric.CLUSTER.getLegacyName() + ".*", ORole.PERMISSION_READ);
            this.setSecurityPolicyWithBitmask(session, readerRole, ORule.ResourceGeneric.COMMAND.getLegacyName(), ORole.PERMISSION_READ);
            this.setSecurityPolicyWithBitmask(session, readerRole, ORule.ResourceGeneric.RECORD_HOOK.getLegacyName(), ORole.PERMISSION_READ);
            this.setSecurityPolicyWithBitmask(session, readerRole, ORule.ResourceGeneric.FUNCTION.getLegacyName() + ".*", ORole.PERMISSION_READ);
            this.setSecurityPolicyWithBitmask(session, readerRole, ORule.ResourceGeneric.SYSTEM_CLUSTERS.getLegacyName(), 0);
            boolean createDefUsers = ((ODatabaseDocumentInternal)session).getStorage().getConfiguration().getContextConfiguration().getValueAsBoolean(OGlobalConfiguration.CREATE_DEFAULT_USERS);
            if (createDefUsers) {
                this.createUser(session, "reader", "reader", readerRole.getName());
            }
            ORole writerRole = this.createRole(session, "writer", OSecurityRole.ALLOW_MODES.DENY_ALL_BUT);
            this.setSecurityPolicyWithBitmask(session, writerRole, "database.class.*.*", ORole.PERMISSION_ALL);
            writerRole.addRule(ORule.ResourceGeneric.DATABASE, null, ORole.PERMISSION_READ);
            writerRole.addRule(ORule.ResourceGeneric.SCHEMA, null, ORole.PERMISSION_READ + ORole.PERMISSION_CREATE + ORole.PERMISSION_UPDATE);
            writerRole.addRule(ORule.ResourceGeneric.CLUSTER, "internal", ORole.PERMISSION_READ);
            readerRole.addRule(ORule.ResourceGeneric.CLUSTER, "orole", 0);
            readerRole.addRule(ORule.ResourceGeneric.CLUSTER, "ouser", 0);
            writerRole.addRule(ORule.ResourceGeneric.CLASS, null, ORole.PERMISSION_ALL);
            writerRole.addRule(ORule.ResourceGeneric.CLASS, "OUser", ORole.PERMISSION_READ);
            writerRole.addRule(ORule.ResourceGeneric.CLUSTER, null, ORole.PERMISSION_ALL);
            writerRole.addRule(ORule.ResourceGeneric.COMMAND, null, ORole.PERMISSION_ALL);
            writerRole.addRule(ORule.ResourceGeneric.RECORD_HOOK, null, ORole.PERMISSION_ALL);
            writerRole.addRule(ORule.ResourceGeneric.FUNCTION, null, ORole.PERMISSION_READ);
            writerRole.addRule(ORule.ResourceGeneric.CLASS, "OSequence", ORole.PERMISSION_READ);
            writerRole.addRule(ORule.ResourceGeneric.CLASS, "OTriggered", ORole.PERMISSION_READ);
            writerRole.addRule(ORule.ResourceGeneric.CLASS, "OSchedule", ORole.PERMISSION_READ);
            writerRole.addRule(ORule.ResourceGeneric.CLASS, OSecurityResource.class.getSimpleName(), ORole.PERMISSION_READ);
            writerRole.addRule(ORule.ResourceGeneric.SYSTEM_CLUSTERS, null, 0);
            writerRole.save();
            this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.DATABASE.getLegacyName(), ORole.PERMISSION_READ);
            this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.SCHEMA.getLegacyName(), ORole.PERMISSION_READ + ORole.PERMISSION_CREATE + ORole.PERMISSION_UPDATE);
            this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.CLUSTER.getLegacyName() + "." + "internal", ORole.PERMISSION_READ);
            this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.CLUSTER.getLegacyName() + ".orole", ORole.PERMISSION_READ);
            this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.CLUSTER.getLegacyName() + ".ouser", ORole.PERMISSION_READ);
            this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.CLASS.getLegacyName() + ".*", ORole.PERMISSION_ALL);
            this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.CLASS.getLegacyName() + ".OUser", ORole.PERMISSION_READ);
            this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.CLUSTER.getLegacyName() + ".*", ORole.PERMISSION_ALL);
            this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.COMMAND.getLegacyName(), ORole.PERMISSION_ALL);
            this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.RECORD_HOOK.getLegacyName(), ORole.PERMISSION_ALL);
            this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.FUNCTION.getLegacyName() + ".*", ORole.PERMISSION_READ);
            this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.CLASS.getLegacyName() + "." + "OSequence", ORole.PERMISSION_READ);
            this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.SYSTEM_CLUSTERS.getLegacyName() + ".OTriggered", ORole.PERMISSION_READ);
            this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.SYSTEM_CLUSTERS.getLegacyName() + ".OSchedule", ORole.PERMISSION_READ);
            this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.SYSTEM_CLUSTERS.getLegacyName(), 0);
            if (createDefUsers) {
                this.createUser(session, "writer", "writer", writerRole.getName());
            }
        }
        finally {
            this.skipRoleHasPredicateSecurityForClassUpdate = false;
        }
        this.initPredicateSecurityOptimizations(session);
        return adminUser;
    }

    public OUser createMetadata(ODatabaseSession session) {
        boolean createDefUsers;
        OUser adminUser;
        OClass identityClass = session.getMetadata().getSchema().getClass(IDENTITY_CLASSNAME);
        if (identityClass == null) {
            identityClass = session.getMetadata().getSchema().createAbstractClass(IDENTITY_CLASSNAME);
        }
        this.createOrUpdateOSecurityPolicyClass(session);
        OClass roleClass = this.createOrUpdateORoleClass(session, identityClass);
        this.createOrUpdateOUserClass(session, identityClass, roleClass);
        ORole adminRole = this.getRole(session, "admin");
        if (adminRole == null) {
            adminRole = this.createRole(session, "admin", OSecurityRole.ALLOW_MODES.DENY_ALL_BUT);
            this.setSecurityPolicyWithBitmask(session, adminRole, "*", ORole.PERMISSION_ALL);
            adminRole.addRule(ORule.ResourceGeneric.BYPASS_RESTRICTED, null, ORole.PERMISSION_ALL).save();
            adminRole.addRule(ORule.ResourceGeneric.ALL, null, ORole.PERMISSION_ALL).save();
            adminRole.addRule(ORule.ResourceGeneric.CLASS, null, ORole.PERMISSION_ALL).save();
            adminRole.addRule(ORule.ResourceGeneric.CLUSTER, null, ORole.PERMISSION_ALL).save();
            adminRole.addRule(ORule.ResourceGeneric.SYSTEM_CLUSTERS, null, ORole.PERMISSION_ALL).save();
            adminRole.addRule(ORule.ResourceGeneric.DATABASE, null, ORole.PERMISSION_ALL).save();
            adminRole.addRule(ORule.ResourceGeneric.SCHEMA, null, ORole.PERMISSION_ALL).save();
            adminRole.addRule(ORule.ResourceGeneric.COMMAND, null, ORole.PERMISSION_ALL).save();
            adminRole.addRule(ORule.ResourceGeneric.COMMAND_GREMLIN, null, ORole.PERMISSION_ALL).save();
            adminRole.addRule(ORule.ResourceGeneric.FUNCTION, null, ORole.PERMISSION_ALL).save();
        }
        if ((adminUser = this.getUserInternal(session, "admin")) == null && (createDefUsers = ((ODatabaseDocumentInternal)session).getStorage().getConfiguration().getContextConfiguration().getValueAsBoolean(OGlobalConfiguration.CREATE_DEFAULT_USERS))) {
            adminUser = this.createUser(session, "admin", "admin", adminRole);
        }
        this.createOrUpdateORestrictedClass(session);
        return adminUser;
    }

    private void createOrUpdateORestrictedClass(ODatabaseDocument database) {
        OClass restrictedClass = database.getMetadata().getSchema().getClass(RESTRICTED_CLASSNAME);
        boolean unsafe = false;
        if (restrictedClass == null) {
            restrictedClass = database.getMetadata().getSchema().createAbstractClass(RESTRICTED_CLASSNAME);
            unsafe = true;
        }
        if (!restrictedClass.existsProperty(ALLOW_ALL_FIELD)) {
            restrictedClass.createProperty(ALLOW_ALL_FIELD, OType.LINKSET, database.getMetadata().getSchema().getClass(IDENTITY_CLASSNAME), unsafe);
        }
        if (!restrictedClass.existsProperty(ALLOW_READ_FIELD)) {
            restrictedClass.createProperty(ALLOW_READ_FIELD, OType.LINKSET, database.getMetadata().getSchema().getClass(IDENTITY_CLASSNAME), unsafe);
        }
        if (!restrictedClass.existsProperty(ALLOW_UPDATE_FIELD)) {
            restrictedClass.createProperty(ALLOW_UPDATE_FIELD, OType.LINKSET, database.getMetadata().getSchema().getClass(IDENTITY_CLASSNAME), unsafe);
        }
        if (!restrictedClass.existsProperty(ALLOW_DELETE_FIELD)) {
            restrictedClass.createProperty(ALLOW_DELETE_FIELD, OType.LINKSET, database.getMetadata().getSchema().getClass(IDENTITY_CLASSNAME), unsafe);
        }
    }

    private void createOrUpdateOUserClass(ODatabaseDocument database, OClass identityClass, OClass roleClass) {
        boolean unsafe = false;
        OClass userClass = database.getMetadata().getSchema().getClass("OUser");
        if (userClass == null) {
            userClass = database.getMetadata().getSchema().createClass("OUser", identityClass);
            unsafe = true;
        } else if (!userClass.getSuperClasses().contains(identityClass)) {
            userClass.setSuperClasses(Arrays.asList(identityClass));
        }
        if (!userClass.existsProperty("name")) {
            ((OClassImpl)userClass).createProperty("name", OType.STRING, (OType)null, unsafe).setMandatory(true).setNotNull(true).setCollate("ci").setMin("1").setRegexp("\\S+(.*\\S+)*");
            userClass.createIndex("OUser.name", OClass.INDEX_TYPE.UNIQUE, (OProgressListener)ONullOutputListener.INSTANCE, "name");
        } else {
            OProperty name = userClass.getProperty("name");
            if (name.getAllIndexes().isEmpty()) {
                userClass.createIndex("OUser.name", OClass.INDEX_TYPE.UNIQUE, (OProgressListener)ONullOutputListener.INSTANCE, "name");
            }
        }
        if (!userClass.existsProperty("password")) {
            userClass.createProperty("password", OType.STRING, (OType)null, unsafe).setMandatory(true).setNotNull(true);
        }
        if (!userClass.existsProperty("roles")) {
            userClass.createProperty("roles", OType.LINKSET, roleClass, unsafe);
        }
        if (!userClass.existsProperty("status")) {
            userClass.createProperty("status", OType.STRING, (OType)null, unsafe).setMandatory(true).setNotNull(true);
        }
    }

    private OClass createOrUpdateOSecurityPolicyClass(ODatabaseDocument database) {
        OClass policyClass = database.getMetadata().getSchema().getClass("OSecurityPolicy");
        boolean unsafe = false;
        if (policyClass == null) {
            policyClass = database.getMetadata().getSchema().createClass("OSecurityPolicy");
            unsafe = true;
        }
        if (!policyClass.existsProperty("name")) {
            policyClass.createProperty("name", OType.STRING, (OType)null, unsafe).setMandatory(true).setNotNull(true).setCollate("ci");
            policyClass.createIndex("OSecurityPolicy.name", OClass.INDEX_TYPE.UNIQUE, (OProgressListener)ONullOutputListener.INSTANCE, "name");
        } else {
            OProperty name = policyClass.getProperty("name");
            if (name.getAllIndexes().isEmpty()) {
                policyClass.createIndex("OSecurityPolicy.name", OClass.INDEX_TYPE.UNIQUE, (OProgressListener)ONullOutputListener.INSTANCE, "name");
            }
        }
        if (!policyClass.existsProperty("create")) {
            policyClass.createProperty("create", OType.STRING, (OType)null, unsafe);
        }
        if (!policyClass.existsProperty("read")) {
            policyClass.createProperty("read", OType.STRING, (OType)null, unsafe);
        }
        if (!policyClass.existsProperty("beforeUpdate")) {
            policyClass.createProperty("beforeUpdate", OType.STRING, (OType)null, unsafe);
        }
        if (!policyClass.existsProperty("afterUpdate")) {
            policyClass.createProperty("afterUpdate", OType.STRING, (OType)null, unsafe);
        }
        if (!policyClass.existsProperty("delete")) {
            policyClass.createProperty("delete", OType.STRING, (OType)null, unsafe);
        }
        if (!policyClass.existsProperty("execute")) {
            policyClass.createProperty("execute", OType.STRING, (OType)null, unsafe);
        }
        if (!policyClass.existsProperty("active")) {
            policyClass.createProperty("active", OType.BOOLEAN, (OType)null, unsafe);
        }
        return policyClass;
    }

    private OClass createOrUpdateORoleClass(ODatabaseDocument database, OClass identityClass) {
        OClass roleClass = database.getMetadata().getSchema().getClass("ORole");
        boolean unsafe = false;
        if (roleClass == null) {
            roleClass = database.getMetadata().getSchema().createClass("ORole", identityClass);
            unsafe = true;
        } else if (!roleClass.getSuperClasses().contains(identityClass)) {
            roleClass.setSuperClasses(Arrays.asList(identityClass));
        }
        if (!roleClass.existsProperty("name")) {
            roleClass.createProperty("name", OType.STRING, (OType)null, unsafe).setMandatory(true).setNotNull(true).setCollate("ci");
            roleClass.createIndex("ORole.name", OClass.INDEX_TYPE.UNIQUE, (OProgressListener)ONullOutputListener.INSTANCE, "name");
        } else {
            OProperty name = roleClass.getProperty("name");
            if (name.getAllIndexes().isEmpty()) {
                roleClass.createIndex("ORole.name", OClass.INDEX_TYPE.UNIQUE, (OProgressListener)ONullOutputListener.INSTANCE, "name");
            }
        }
        if (!roleClass.existsProperty("mode")) {
            roleClass.createProperty("mode", OType.BYTE, (OType)null, unsafe);
        }
        if (!roleClass.existsProperty("rules")) {
            roleClass.createProperty("rules", OType.EMBEDDEDMAP, OType.BYTE, unsafe);
        }
        if (!roleClass.existsProperty("inheritedRole")) {
            roleClass.createProperty("inheritedRole", OType.LINK, roleClass, unsafe);
        }
        if (!roleClass.existsProperty("policies")) {
            roleClass.createProperty("policies", OType.LINKMAP, database.getClass("OSecurityPolicy"), unsafe);
        }
        return roleClass;
    }

    @Override
    public void load(ODatabaseSession session) {
        OClass userClass = session.getMetadata().getSchema().getClass("OUser");
        if (userClass != null) {
            OClass roleClass;
            OProperty rules;
            OProperty p;
            if (!userClass.existsProperty("status")) {
                userClass.createProperty("status", OType.STRING).setMandatory(true).setNotNull(true);
            }
            if ((p = userClass.getProperty("name")) == null) {
                p = userClass.createProperty("name", OType.STRING).setMandatory(true).setNotNull(true).setMin("1").setRegexp("\\S+(.*\\S+)*");
            }
            if (userClass.getInvolvedIndexes("name") == null) {
                p.createIndex(OClass.INDEX_TYPE.UNIQUE);
            }
            if ((rules = (roleClass = session.getMetadata().getSchema().getClass("ORole")).getProperty("rules")) != null && !OType.EMBEDDEDMAP.equals((Object)rules.getType())) {
                roleClass.dropProperty("rules");
            }
            if (!roleClass.existsProperty("inheritedRole")) {
                roleClass.createProperty("inheritedRole", OType.LINK, roleClass);
            }
            if ((p = roleClass.getProperty("name")) == null) {
                p = roleClass.createProperty("name", OType.STRING).setMandatory(true).setNotNull(true);
            }
            if (roleClass.getInvolvedIndexes("name") == null) {
                p.createIndex(OClass.INDEX_TYPE.UNIQUE);
            }
        }
        this.setupPredicateSecurity(session);
        if (!((ODatabaseDocumentInternal)session).getStorage().isRemote()) {
            this.initPredicateSecurityOptimizations(session);
        }
    }

    private void setupPredicateSecurity(ODatabaseSession session) {
        OClass securityPolicyClass = session.getMetadata().getSchema().getClass(OSecurityPolicy.class);
        if (securityPolicyClass == null) {
            ORole writerRole;
            ORole readerRole;
            this.createOrUpdateOSecurityPolicyClass(session);
            ORole adminRole = this.getRole(session, "admin");
            if (adminRole != null) {
                this.setSecurityPolicyWithBitmask(session, adminRole, "*", ORole.PERMISSION_ALL);
                adminRole.addRule(ORule.ResourceGeneric.ALL, null, ORole.PERMISSION_ALL).save();
                adminRole.addRule(ORule.ResourceGeneric.CLASS, null, ORole.PERMISSION_ALL).save();
                adminRole.addRule(ORule.ResourceGeneric.CLUSTER, null, ORole.PERMISSION_ALL).save();
                adminRole.addRule(ORule.ResourceGeneric.SYSTEM_CLUSTERS, null, ORole.PERMISSION_ALL).save();
                adminRole.addRule(ORule.ResourceGeneric.DATABASE, null, ORole.PERMISSION_ALL).save();
                adminRole.addRule(ORule.ResourceGeneric.SCHEMA, null, ORole.PERMISSION_ALL).save();
                adminRole.addRule(ORule.ResourceGeneric.COMMAND, null, ORole.PERMISSION_ALL).save();
                adminRole.addRule(ORule.ResourceGeneric.COMMAND_GREMLIN, null, ORole.PERMISSION_ALL).save();
                adminRole.addRule(ORule.ResourceGeneric.FUNCTION, null, ORole.PERMISSION_ALL).save();
                adminRole.save();
            }
            if ((readerRole = this.getRole(session, "reader")) != null) {
                readerRole.addRule(ORule.ResourceGeneric.DATABASE, null, ORole.PERMISSION_READ);
                readerRole.addRule(ORule.ResourceGeneric.SCHEMA, null, ORole.PERMISSION_READ);
                readerRole.addRule(ORule.ResourceGeneric.CLUSTER, "internal", ORole.PERMISSION_READ);
                readerRole.addRule(ORule.ResourceGeneric.CLUSTER, "orole", 0);
                readerRole.addRule(ORule.ResourceGeneric.CLUSTER, "ouser", 0);
                readerRole.addRule(ORule.ResourceGeneric.CLASS, null, ORole.PERMISSION_READ);
                readerRole.addRule(ORule.ResourceGeneric.CLASS, "OUser", 0);
                readerRole.addRule(ORule.ResourceGeneric.CLUSTER, null, ORole.PERMISSION_READ);
                readerRole.addRule(ORule.ResourceGeneric.COMMAND, null, ORole.PERMISSION_READ);
                readerRole.addRule(ORule.ResourceGeneric.RECORD_HOOK, null, ORole.PERMISSION_READ);
                readerRole.addRule(ORule.ResourceGeneric.FUNCTION, null, ORole.PERMISSION_READ);
                readerRole.addRule(ORule.ResourceGeneric.SYSTEM_CLUSTERS, null, 0);
                readerRole.save();
                this.setSecurityPolicyWithBitmask(session, readerRole, ORule.ResourceGeneric.DATABASE.getLegacyName(), ORole.PERMISSION_READ);
                this.setSecurityPolicyWithBitmask(session, readerRole, ORule.ResourceGeneric.SCHEMA.getLegacyName(), ORole.PERMISSION_READ);
                this.setSecurityPolicyWithBitmask(session, readerRole, ORule.ResourceGeneric.CLUSTER.getLegacyName() + "." + "internal", ORole.PERMISSION_READ);
                this.setSecurityPolicyWithBitmask(session, readerRole, ORule.ResourceGeneric.CLUSTER.getLegacyName() + ".orole", ORole.PERMISSION_READ);
                this.setSecurityPolicyWithBitmask(session, readerRole, ORule.ResourceGeneric.CLUSTER.getLegacyName() + ".ouser", ORole.PERMISSION_READ);
                this.setSecurityPolicyWithBitmask(session, readerRole, ORule.ResourceGeneric.CLASS.getLegacyName() + ".*", ORole.PERMISSION_READ);
                this.setSecurityPolicyWithBitmask(session, readerRole, ORule.ResourceGeneric.CLASS.getLegacyName() + ".OUser", ORole.PERMISSION_READ);
                this.setSecurityPolicyWithBitmask(session, readerRole, ORule.ResourceGeneric.CLUSTER.getLegacyName() + ".*", ORole.PERMISSION_READ);
                this.setSecurityPolicyWithBitmask(session, readerRole, ORule.ResourceGeneric.COMMAND.getLegacyName(), ORole.PERMISSION_READ);
                this.setSecurityPolicyWithBitmask(session, readerRole, ORule.ResourceGeneric.RECORD_HOOK.getLegacyName(), ORole.PERMISSION_READ);
                this.setSecurityPolicyWithBitmask(session, readerRole, ORule.ResourceGeneric.FUNCTION.getLegacyName() + ".*", ORole.PERMISSION_READ);
                this.setSecurityPolicyWithBitmask(session, readerRole, ORule.ResourceGeneric.SYSTEM_CLUSTERS.getLegacyName(), 0);
            }
            if ((writerRole = this.getRole(session, "writer")) != null) {
                this.setSecurityPolicyWithBitmask(session, writerRole, "database.class.*.*", ORole.PERMISSION_ALL);
                writerRole.addRule(ORule.ResourceGeneric.DATABASE, null, ORole.PERMISSION_READ);
                writerRole.addRule(ORule.ResourceGeneric.SCHEMA, null, ORole.PERMISSION_READ + ORole.PERMISSION_CREATE + ORole.PERMISSION_UPDATE);
                writerRole.addRule(ORule.ResourceGeneric.CLUSTER, "internal", ORole.PERMISSION_READ);
                readerRole.addRule(ORule.ResourceGeneric.CLUSTER, "orole", 0);
                readerRole.addRule(ORule.ResourceGeneric.CLUSTER, "ouser", 0);
                writerRole.addRule(ORule.ResourceGeneric.CLASS, null, ORole.PERMISSION_ALL);
                writerRole.addRule(ORule.ResourceGeneric.CLASS, "OUser", ORole.PERMISSION_READ);
                writerRole.addRule(ORule.ResourceGeneric.CLUSTER, null, ORole.PERMISSION_ALL);
                writerRole.addRule(ORule.ResourceGeneric.COMMAND, null, ORole.PERMISSION_ALL);
                writerRole.addRule(ORule.ResourceGeneric.RECORD_HOOK, null, ORole.PERMISSION_ALL);
                writerRole.addRule(ORule.ResourceGeneric.FUNCTION, null, ORole.PERMISSION_READ);
                writerRole.addRule(ORule.ResourceGeneric.CLASS, "OSequence", ORole.PERMISSION_READ);
                writerRole.addRule(ORule.ResourceGeneric.CLASS, "OTriggered", ORole.PERMISSION_READ);
                writerRole.addRule(ORule.ResourceGeneric.CLASS, "OSchedule", ORole.PERMISSION_READ);
                writerRole.addRule(ORule.ResourceGeneric.CLASS, OSecurityResource.class.getSimpleName(), ORole.PERMISSION_READ);
                writerRole.addRule(ORule.ResourceGeneric.SYSTEM_CLUSTERS, null, 0);
                writerRole.save();
                this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.DATABASE.getLegacyName(), ORole.PERMISSION_READ);
                this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.SCHEMA.getLegacyName(), ORole.PERMISSION_READ + ORole.PERMISSION_CREATE + ORole.PERMISSION_UPDATE);
                this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.CLUSTER.getLegacyName() + "." + "internal", ORole.PERMISSION_READ);
                this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.CLUSTER.getLegacyName() + ".orole", ORole.PERMISSION_READ);
                this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.CLUSTER.getLegacyName() + ".ouser", ORole.PERMISSION_READ);
                this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.CLASS.getLegacyName() + ".*", ORole.PERMISSION_ALL);
                this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.CLASS.getLegacyName() + ".OUser", ORole.PERMISSION_READ);
                this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.CLUSTER.getLegacyName() + ".*", ORole.PERMISSION_ALL);
                this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.COMMAND.getLegacyName(), ORole.PERMISSION_ALL);
                this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.RECORD_HOOK.getLegacyName(), ORole.PERMISSION_ALL);
                this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.FUNCTION.getLegacyName() + ".*", ORole.PERMISSION_READ);
                this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.CLASS.getLegacyName() + "." + "OSequence", ORole.PERMISSION_READ);
                this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.SYSTEM_CLUSTERS.getLegacyName() + ".OTriggered", ORole.PERMISSION_READ);
                this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.SYSTEM_CLUSTERS.getLegacyName() + ".OSchedule", ORole.PERMISSION_READ);
                this.setSecurityPolicyWithBitmask(session, writerRole, ORule.ResourceGeneric.SYSTEM_CLUSTERS.getLegacyName(), 0);
            }
            this.incrementVersion(session);
        }
    }

    @Override
    public void createClassTrigger(ODatabaseSession session) {
        OClass classTrigger = session.getMetadata().getSchema().getClass("OTriggered");
        if (classTrigger == null) {
            classTrigger = session.getMetadata().getSchema().createAbstractClass("OTriggered");
        }
    }

    @Override
    public OUser getUser(ODatabaseSession session, String iUserName) {
        return this.getUserInternal(session, iUserName);
    }

    public OUser getUserInternal(ODatabaseSession session, String iUserName) {
        return (OUser)OScenarioThreadLocal.executeAsDistributed(() -> {
            try (OResultSet result = session.query("select from OUser where name = ? limit 1", iUserName);){
                if (result.hasNext()) {
                    OUser oUser = new OUser((ODocument)result.next().getElement().get());
                    return oUser;
                }
            }
            return null;
        });
    }

    public ORID getUserRID(ODatabaseSession session, String userName) {
        return (ORID)OScenarioThreadLocal.executeAsDistributed(() -> {
            try (OResultSet result = session.query("select @rid as rid from OUser where name = ? limit 1", userName);){
                if (result.hasNext()) {
                    Object t = result.next().getProperty("rid");
                    return t;
                }
            }
            return null;
        });
    }

    @Override
    public void close() {
    }

    @Override
    public long getVersion(ODatabaseSession session) {
        return this.version.get();
    }

    @Override
    public void incrementVersion(ODatabaseSession session) {
        this.version.incrementAndGet();
        this.securityPredicateCache.clear();
        this.updateAllFilteredProperties((ODatabaseDocumentInternal)session);
        this.initPredicateSecurityOptimizations(session);
    }

    protected void initPredicateSecurityOptimizations(ODatabaseSession session) {
        if (this.skipRoleHasPredicateSecurityForClassUpdate) {
            return;
        }
        OSecurityUser user = session.getUser();
        try {
            if (user != null) {
                ((ODatabaseDocumentInternal)session).setUser(null);
            }
            this.initPredicateSecurityOptimizationsInternal(session);
        }
        finally {
            if (user != null) {
                ((ODatabaseDocumentInternal)session).setUser(user);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPredicateSecurityOptimizationsInternal(ODatabaseSession session) {
        HashMap<String, Map<String, Boolean>> result = new HashMap<String, Map<String, Boolean>>();
        Collection<OClass> allClasses = session.getMetadata().getSchema().getClasses();
        if (session.getClass("ORole") == null) {
            return;
        }
        OSecurityShared oSecurityShared = this;
        synchronized (oSecurityShared) {
            OResultSet rs = session.query("select name, policies from ORole", new Object[0]);
            while (rs.hasNext()) {
                OResult item = rs.next();
                String roleName = (String)item.getProperty("name");
                Map policies = (Map)item.getProperty("policies");
                if (policies == null) continue;
                for (Map.Entry policyEntry : policies.entrySet()) {
                    OSecurityResource res = OSecurityResource.getInstance((String)policyEntry.getKey());
                    for (OClass clazz : allClasses) {
                        if (!this.isClassInvolved(clazz, res) || this.isAllAllowed(session, new OSecurityPolicy((OElement)((OIdentifiable)policyEntry.getValue()).getRecord()))) continue;
                        HashMap<String, Boolean> roleMap = (HashMap<String, Boolean>)result.get(roleName);
                        if (roleMap == null) {
                            roleMap = new HashMap<String, Boolean>();
                            result.put(roleName, roleMap);
                        }
                        roleMap.put(clazz.getName(), true);
                    }
                }
                rs.close();
            }
            this.roleHasPredicateSecurityForClass = result;
        }
    }

    private boolean isAllAllowed(ODatabaseSession db, OSecurityPolicy policy) {
        for (OSecurityPolicy.Scope scope : OSecurityPolicy.Scope.values()) {
            OBooleanExpression predicate;
            String predicateString = policy.get(scope);
            if (predicateString == null || (predicate = OSecurityEngine.parsePredicate(db, predicateString)).isAlwaysTrue()) continue;
            return false;
        }
        return true;
    }

    private boolean isClassInvolved(OClass clazz, OSecurityResource res) {
        String resourceClass;
        if (res instanceof OSecurityResourceAll || res.equals(OSecurityResourceClass.ALL_CLASSES) || res.equals(OSecurityResourceProperty.ALL_PROPERTIES)) {
            return true;
        }
        return res instanceof OSecurityResourceClass ? clazz.isSubClassOf(resourceClass = ((OSecurityResourceClass)res).getClassName()) : res instanceof OSecurityResourceProperty && clazz.isSubClassOf(resourceClass = ((OSecurityResourceProperty)res).getClassName());
    }

    @Override
    public Set<String> getFilteredProperties(ODatabaseSession session, ODocument document) {
        if (session.getUser() == null) {
            return Collections.emptySet();
        }
        if (OSecurityPolicy.class.getSimpleName().equalsIgnoreCase(document.getClassName())) {
            return Collections.emptySet();
        }
        if (document.getClassName() == null) {
            return Collections.emptySet();
        }
        if (this.roleHasPredicateSecurityForClass != null) {
            for (OSecurityRole oSecurityRole : session.getUser().getRoles()) {
                Map<String, Boolean> roleMap = this.roleHasPredicateSecurityForClass.get(oSecurityRole.getName());
                if (roleMap == null) {
                    return Collections.emptySet();
                }
                Boolean val = roleMap.get(document.getClassName());
                if (Boolean.TRUE.equals(val)) continue;
                return Collections.emptySet();
            }
        }
        Set<String> props = document.getPropertyNames();
        HashSet<String> hashSet = new HashSet<String>();
        OClass schemaType = document.getSchemaType().orElse(null);
        if (schemaType == null) {
            return Collections.emptySet();
        }
        for (String prop : props) {
            OBooleanExpression predicate = OSecurityEngine.getPredicateForSecurityResource(session, this, "database.class.`" + schemaType.getName() + "`.`" + prop + "`", OSecurityPolicy.Scope.READ);
            if (OSecurityEngine.evaluateSecuirtyPolicyPredicate(session, predicate, document)) continue;
            hashSet.add(prop);
        }
        return hashSet;
    }

    @Override
    public boolean isAllowedWrite(ODatabaseSession session, ODocument document, String propertyName) {
        OResultInternal originalRecord;
        if (session.getUser() == null) {
            return true;
        }
        OClass clazz = document.getSchemaType().orElse(null);
        if (clazz == null) {
            return true;
        }
        if (document.getIdentity().isNew()) {
            OBooleanExpression predicate = OSecurityEngine.getPredicateForSecurityResource(session, this, "database.class.`" + clazz.getName() + "`.`" + propertyName + "`", OSecurityPolicy.Scope.CREATE);
            return OSecurityEngine.evaluateSecuirtyPolicyPredicate(session, predicate, document);
        }
        OBooleanExpression readPredicate = OSecurityEngine.getPredicateForSecurityResource(session, this, "database.class.`" + clazz.getName() + "`.`" + propertyName + "`", OSecurityPolicy.Scope.READ);
        if (!OSecurityEngine.evaluateSecuirtyPolicyPredicate(session, readPredicate, document)) {
            return false;
        }
        OBooleanExpression beforePredicate = OSecurityEngine.getPredicateForSecurityResource(session, this, "database.class.`" + clazz.getName() + "`.`" + propertyName + "`", OSecurityPolicy.Scope.BEFORE_UPDATE);
        if (!OSecurityEngine.evaluateSecuirtyPolicyPredicate(session, beforePredicate, originalRecord = this.calculateOriginalValue(document, session))) {
            return false;
        }
        OBooleanExpression predicate = OSecurityEngine.getPredicateForSecurityResource(session, this, "database.class.`" + clazz.getName() + "`.`" + propertyName + "`", OSecurityPolicy.Scope.AFTER_UPDATE);
        return OSecurityEngine.evaluateSecuirtyPolicyPredicate(session, predicate, document);
    }

    @Override
    public boolean canCreate(ODatabaseSession session, ORecord record) {
        if (session.getUser() == null) {
            return true;
        }
        if (record instanceof OElement) {
            String className = record instanceof ODocument ? ((ODocument)record).getClassName() : (String)((OElement)record).getSchemaType().map(x -> x.getName()).orElse(null);
            if (this.roleHasPredicateSecurityForClass != null) {
                for (OSecurityRole oSecurityRole : session.getUser().getRoles()) {
                    Map<String, Boolean> roleMap = this.roleHasPredicateSecurityForClass.get(oSecurityRole.getName());
                    if (roleMap == null) {
                        return true;
                    }
                    Boolean val = roleMap.get(className);
                    if (Boolean.TRUE.equals(val)) continue;
                    return true;
                }
            }
            OBooleanExpression predicate = className == null ? null : OSecurityEngine.getPredicateForSecurityResource(session, this, "database.class.`" + className + "`", OSecurityPolicy.Scope.CREATE);
            return OSecurityEngine.evaluateSecuirtyPolicyPredicate(session, predicate, record);
        }
        return true;
    }

    @Override
    public boolean canRead(ODatabaseSession session, ORecord record) {
        if (session.getUser() == null) {
            return true;
        }
        if (record instanceof OElement) {
            if (OSecurityPolicy.class.getSimpleName().equalsIgnoreCase(((ODocument)record).getClassName())) {
                return true;
            }
            if (((ODocument)record).getClassName() == null) {
                return true;
            }
            if (this.roleHasPredicateSecurityForClass != null) {
                for (OSecurityRole oSecurityRole : session.getUser().getRoles()) {
                    Map<String, Boolean> roleMap = this.roleHasPredicateSecurityForClass.get(oSecurityRole.getName());
                    if (roleMap == null) {
                        return true;
                    }
                    Boolean val = roleMap.get(((ODocument)record).getClassName());
                    if (Boolean.TRUE.equals(val)) continue;
                    return true;
                }
            }
            OBooleanExpression predicate = ((OElement)record).getSchemaType().map(x -> OSecurityEngine.getPredicateForSecurityResource(session, this, "database.class.`" + x.getName() + "`", OSecurityPolicy.Scope.READ)).orElse(null);
            return OSecurityEngine.evaluateSecuirtyPolicyPredicate(session, predicate, record);
        }
        return true;
    }

    @Override
    public boolean canUpdate(ODatabaseSession session, ORecord record) {
        if (session.getUser() == null) {
            return true;
        }
        if (record instanceof OElement) {
            OResultInternal oResultInternal;
            OBooleanExpression beforePredicate;
            String className = ((OElement)record).getSchemaType().map(x -> x.getName()).orElse(null);
            if (className != null && this.roleHasPredicateSecurityForClass != null) {
                for (OSecurityRole oSecurityRole : session.getUser().getRoles()) {
                    Map<String, Boolean> roleMap = this.roleHasPredicateSecurityForClass.get(oSecurityRole.getName());
                    if (roleMap == null) {
                        return true;
                    }
                    Boolean val = roleMap.get(className);
                    if (Boolean.TRUE.equals(val)) continue;
                    return true;
                }
            }
            if (!OSecurityEngine.evaluateSecuirtyPolicyPredicate(session, beforePredicate = (OBooleanExpression)((OElement)record).getSchemaType().map(x -> OSecurityEngine.getPredicateForSecurityResource(session, this, "database.class.`" + x.getName() + "`", OSecurityPolicy.Scope.BEFORE_UPDATE)).orElse(null), oResultInternal = this.calculateOriginalValue(record, session))) {
                return false;
            }
            OBooleanExpression predicate = ((OElement)record).getSchemaType().map(x -> OSecurityEngine.getPredicateForSecurityResource(session, this, "database.class.`" + x.getName() + "`", OSecurityPolicy.Scope.AFTER_UPDATE)).orElse(null);
            return OSecurityEngine.evaluateSecuirtyPolicyPredicate(session, predicate, record);
        }
        return true;
    }

    private OResultInternal calculateOriginalValue(ORecord record, ODatabaseSession db) {
        return OSecurityShared.calculateBefore((ODocument)record.getRecord(), db);
    }

    public static OResultInternal calculateBefore(ODocument iDocument, ODatabaseSession db) {
        OResultInternal result = new OResultInternal();
        for (String prop : iDocument.getPropertyNames()) {
            result.setProperty(prop, OSecurityShared.unboxRidbags(iDocument.getProperty(prop)));
        }
        result.setProperty("@rid", iDocument.getIdentity());
        result.setProperty("@class", iDocument.getClassName());
        result.setProperty("@version", iDocument.getVersion());
        for (String prop : iDocument.getDirtyFields()) {
            result.setProperty(prop, OSecurityShared.convert(iDocument.getOriginalValue(prop)));
        }
        return result;
    }

    private static Object convert(Object originalValue) {
        if (originalValue instanceof ORidBag) {
            LinkedHashSet result = new LinkedHashSet();
            ((ORidBag)originalValue).rawIterator().forEachRemaining(x -> result.add(x));
            return result;
        }
        return originalValue;
    }

    public static Object unboxRidbags(Object value) {
        if (value instanceof ORidBag) {
            ArrayList<OIdentifiable> result = new ArrayList<OIdentifiable>(((ORidBag)value).size());
            Iterator<OIdentifiable> iter2 = ((ORidBag)value).rawIterator();
            while (iter2.hasNext()) {
                result.add(iter2.next());
            }
            return result;
        }
        return value;
    }

    @Override
    public boolean canDelete(ODatabaseSession session, ORecord record) {
        if (session.getUser() == null) {
            return true;
        }
        if (record instanceof OElement) {
            OBooleanExpression predicate = ((OElement)record).getSchemaType().map(x -> OSecurityEngine.getPredicateForSecurityResource(session, this, "database.class.`" + x.getName() + "`", OSecurityPolicy.Scope.DELETE)).orElse(null);
            return OSecurityEngine.evaluateSecuirtyPolicyPredicate(session, predicate, record);
        }
        return true;
    }

    @Override
    public boolean canExecute(ODatabaseSession session, OFunction function) {
        if (session.getUser() == null) {
            return true;
        }
        OBooleanExpression predicate = OSecurityEngine.getPredicateForSecurityResource(session, this, "database.function." + function.getName(), OSecurityPolicy.Scope.EXECUTE);
        return OSecurityEngine.evaluateSecuirtyPolicyPredicate(session, predicate, function.getDocument());
    }

    protected OBooleanExpression getPredicateFromCache(String roleName, String key) {
        Map<String, OBooleanExpression> roleMap = this.securityPredicateCache.get(roleName);
        if (roleMap == null) {
            return null;
        }
        OBooleanExpression result = roleMap.get(key.toLowerCase(Locale.ENGLISH));
        if (result != null) {
            return result.copy();
        }
        return null;
    }

    protected void putPredicateInCache(String roleName, String key, OBooleanExpression predicate) {
        if (predicate.isCacheable()) {
            Map<String, OBooleanExpression> roleMap = this.securityPredicateCache.get(roleName);
            if (roleMap == null) {
                roleMap = new ConcurrentHashMap<String, OBooleanExpression>();
                this.securityPredicateCache.put(roleName, roleMap);
            }
            roleMap.put(key.toLowerCase(Locale.ENGLISH), predicate);
        }
    }

    @Override
    public boolean isReadRestrictedBySecurityPolicy(ODatabaseSession session, String resource) {
        if (session.getUser() == null) {
            return false;
        }
        OBooleanExpression predicate = OSecurityEngine.getPredicateForSecurityResource(session, this, resource, OSecurityPolicy.Scope.READ);
        return predicate != null && !OBooleanExpression.TRUE.equals(predicate);
    }

    @Override
    public synchronized Set<OSecurityResourceProperty> getAllFilteredProperties(ODatabaseDocumentInternal database) {
        if (this.filteredProperties == null) {
            this.updateAllFilteredProperties(database);
        }
        if (this.filteredProperties == null) {
            return Collections.emptySet();
        }
        return new HashSet<OSecurityResourceProperty>(this.filteredProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAllFilteredProperties(ODatabaseDocumentInternal session) {
        if (session.getUser() == null) {
            Set<OSecurityResourceProperty> result = this.calculateAllFilteredProperties(session);
            OSecurityShared oSecurityShared = this;
            synchronized (oSecurityShared) {
                this.filteredProperties = result;
            }
        }
        OSecurityShared oSecurityShared = this;
        synchronized (oSecurityShared) {
            if (this.filteredProperties == null) {
                this.filteredProperties = new HashSet<OSecurityResourceProperty>();
            }
            this.updateAllFilteredPropertiesInternal(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAllFilteredPropertiesInternal(ODatabaseDocumentInternal session) {
        OSecurityUser user = session.getUser();
        try {
            if (user != null) {
                session.setUser(null);
            }
            OSecurityShared oSecurityShared = this;
            synchronized (oSecurityShared) {
                this.filteredProperties.clear();
                this.filteredProperties.addAll(this.calculateAllFilteredProperties(session));
            }
        }
        finally {
            if (user != null) {
                session.setUser(user);
            }
        }
    }

    protected Set<OSecurityResourceProperty> calculateAllFilteredProperties(ODatabaseSession session) {
        HashSet<OSecurityResourceProperty> result = new HashSet<OSecurityResourceProperty>();
        if (session.getClass("ORole") == null) {
            return Collections.emptySet();
        }
        OResultSet rs = session.query("select policies from ORole", new Object[0]);
        while (rs.hasNext()) {
            OResult item = rs.next();
            Map policies = (Map)item.getProperty("policies");
            if (policies == null) continue;
            for (Map.Entry policyEntry : policies.entrySet()) {
                try {
                    OSecurityPolicy policy;
                    String readRule;
                    OSecurityResource res = OSecurityResource.getInstance((String)policyEntry.getKey());
                    if (!(res instanceof OSecurityResourceProperty) || (readRule = (policy = new OSecurityPolicy((OElement)((OIdentifiable)policyEntry.getValue()).getRecord())).getReadRule()) == null || readRule.trim().equalsIgnoreCase("true")) continue;
                    result.add((OSecurityResourceProperty)res);
                }
                catch (Exception exception) {}
            }
        }
        rs.close();
        return result;
    }

    public boolean couldHaveActivePredicateSecurityRoles(ODatabaseSession session, String className) {
        if (session.getUser() == null) {
            return false;
        }
        if (this.roleHasPredicateSecurityForClass != null) {
            for (OSecurityRole oSecurityRole : session.getUser().getRoles()) {
                Map<String, Boolean> roleMap = this.roleHasPredicateSecurityForClass.get(oSecurityRole.getName());
                if (roleMap == null) {
                    return false;
                }
                Boolean val = roleMap.get(className);
                if (!Boolean.TRUE.equals(val)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

