/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.sequence;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.sequence.OSequence;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceAction;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceLimitReachedException;
import com.orientechnologies.orient.core.metadata.sequence.SequenceOrderType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class OSequenceCached
extends OSequence {
    private static final String FIELD_CACHE = "cache";
    private long cacheStart;
    private long cacheEnd;
    private boolean firstCache;
    private int increment;
    private Long limitValue = null;
    private Long startValue;
    private SequenceOrderType orderType;
    private boolean recyclable;
    private String name = null;

    public OSequenceCached() {
        this(null, null);
    }

    public OSequenceCached(ODocument iDocument) {
        this(iDocument, null);
    }

    public OSequenceCached(ODocument iDocument, OSequence.CreateParams params) {
        super(iDocument, params);
        if (iDocument == null) {
            if (params == null) {
                params = new OSequence.CreateParams().setDefaults();
            }
            this.setCacheSize(params.cacheSize);
            this.cacheEnd = 0L;
            this.cacheStart = 0L;
            this.allocateCache(this.getCacheSize(), this.getDatabase());
        }
        if (iDocument != null) {
            this.firstCache = true;
            this.cacheStart = this.cacheEnd = OSequenceCached.getValue(iDocument).longValue();
        }
    }

    @Override
    synchronized boolean updateParams(OSequence.CreateParams params, boolean executeViaDistributed) throws ODatabaseException {
        boolean any = super.updateParams(params, executeViaDistributed);
        if (!executeViaDistributed) {
            if (params.cacheSize != null && this.getCacheSize() != params.cacheSize.intValue()) {
                this.setCacheSize(params.cacheSize);
                any = true;
            }
            this.firstCache = true;
            this.save();
        }
        return any;
    }

    private void doRecycle(ODatabaseDocumentInternal finalDb) {
        if (!this.recyclable) {
            throw new OSequenceLimitReachedException("Limit reached");
        }
        this.reloadSequence();
        this.setValue(this.getStart());
        this.allocateCache(this.getCacheSize(), finalDb);
    }

    private void reloadCrucialValues() {
        this.increment = this.getIncrement();
        this.limitValue = this.getLimitValue();
        this.orderType = this.getOrderType();
        this.recyclable = this.getRecyclable();
        this.startValue = this.getStart();
        if (this.name == null) {
            this.name = this.getName();
        }
    }

    private boolean signalToAllocateCache() {
        return this.orderType == SequenceOrderType.ORDER_POSITIVE ? this.cacheStart + (long)this.increment > this.cacheEnd && (this.limitValue == null || this.cacheStart + (long)this.increment <= this.limitValue) : this.cacheStart - (long)this.increment < this.cacheEnd && (this.limitValue == null || this.cacheStart - (long)this.increment >= this.limitValue);
    }

    private <T> T sendSequenceActionSetAndNext(long value) throws ExecutionException, InterruptedException {
        OSequenceAction action = new OSequenceAction(this.getName(), value);
        return ((ODocument)this.tlDocument.get()).getDatabase().sendSequenceAction(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long nextWithNewCurrentValue(long currentValue, boolean executeViaDistributed) throws OSequenceLimitReachedException, ODatabaseException {
        if (!executeViaDistributed) {
            OSequenceCached oSequenceCached = this;
            synchronized (oSequenceCached) {
                this.cacheStart = currentValue;
                return this.nextWork();
            }
        }
        try {
            return (Long)this.sendSequenceActionSetAndNext(currentValue);
        }
        catch (InterruptedException | ExecutionException exc) {
            OLogManager.instance().error(this, exc.getMessage(), exc, null);
            throw new ODatabaseException(exc.getMessage());
        }
    }

    @Override
    protected boolean shouldGoOverDistrtibute() {
        return this.isOnDistributted() && replicationProtocolVersion == 2 && this.signalToAllocateCache();
    }

    @Override
    public long next() throws OSequenceLimitReachedException, ODatabaseException {
        boolean shouldGoOverDistributted = this.shouldGoOverDistrtibute();
        if (shouldGoOverDistributted) {
            return this.nextWithNewCurrentValue(this.cacheStart, true);
        }
        return this.nextWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long nextWork() throws OSequenceLimitReachedException {
        ODatabaseDocumentInternal mainDb = this.getDatabase();
        boolean tx = mainDb.getTransaction().isActive();
        try {
            long l;
            block9: {
                ODatabaseDocumentInternal db = mainDb;
                if (tx) {
                    db = mainDb.copy();
                    db.activateOnCurrentThread();
                }
                try {
                    final ODatabaseDocumentInternal finalDb = db;
                    l = this.callRetry(this.signalToAllocateCache() || this.getCrucialValueChanged(), new Callable<Long>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Long call() throws Exception {
                            OSequenceCached oSequenceCached = OSequenceCached.this;
                            synchronized (oSequenceCached) {
                                float delta;
                                float tillEnd;
                                boolean cachedbefore;
                                boolean detectedCrucialValueChange = false;
                                if (OSequenceCached.this.getCrucialValueChanged()) {
                                    OSequenceCached.this.reloadCrucialValues();
                                    detectedCrucialValueChange = true;
                                }
                                if (OSequenceCached.this.orderType == SequenceOrderType.ORDER_POSITIVE) {
                                    if (OSequenceCached.this.signalToAllocateCache()) {
                                        cachedbefore = !OSequenceCached.this.firstCache;
                                        OSequenceCached.this.allocateCache(OSequenceCached.this.getCacheSize(), finalDb);
                                        if (!cachedbefore) {
                                            if (OSequenceCached.this.limitValue != null && OSequenceCached.this.cacheStart + (long)OSequenceCached.this.increment > OSequenceCached.this.limitValue) {
                                                OSequenceCached.this.doRecycle(finalDb);
                                            } else {
                                                OSequenceCached.this.cacheStart = OSequenceCached.this.cacheStart + (long)OSequenceCached.this.increment;
                                            }
                                        }
                                    } else if (OSequenceCached.this.limitValue != null && OSequenceCached.this.cacheStart + (long)OSequenceCached.this.increment > OSequenceCached.this.limitValue) {
                                        OSequenceCached.this.doRecycle(finalDb);
                                    } else {
                                        OSequenceCached.this.cacheStart = OSequenceCached.this.cacheStart + (long)OSequenceCached.this.increment;
                                    }
                                } else if (OSequenceCached.this.signalToAllocateCache()) {
                                    cachedbefore = !OSequenceCached.this.firstCache;
                                    OSequenceCached.this.allocateCache(OSequenceCached.this.getCacheSize(), finalDb);
                                    if (!cachedbefore) {
                                        if (OSequenceCached.this.limitValue != null && OSequenceCached.this.cacheStart - (long)OSequenceCached.this.increment < OSequenceCached.this.limitValue) {
                                            OSequenceCached.this.doRecycle(finalDb);
                                        } else {
                                            OSequenceCached.this.cacheStart = OSequenceCached.this.cacheStart - (long)OSequenceCached.this.increment;
                                        }
                                    }
                                } else if (OSequenceCached.this.limitValue != null && OSequenceCached.this.cacheStart - (long)OSequenceCached.this.increment < OSequenceCached.this.limitValue) {
                                    OSequenceCached.this.doRecycle(finalDb);
                                } else {
                                    OSequenceCached.this.cacheStart = OSequenceCached.this.cacheStart - (long)OSequenceCached.this.increment;
                                }
                                if (detectedCrucialValueChange) {
                                    OSequenceCached.this.setCrucialValueChanged(false);
                                }
                                if (OSequenceCached.this.limitValue != null && !OSequenceCached.this.recyclable && ((tillEnd = (float)Math.abs(OSequenceCached.this.limitValue - OSequenceCached.this.cacheStart) / (float)OSequenceCached.this.increment) <= (delta = (float)Math.abs(OSequenceCached.this.limitValue - OSequenceCached.this.startValue) / (float)OSequenceCached.this.increment) / 100.0f || tillEnd <= 1.0f)) {
                                    String warningMessage = "Non-recyclable sequence: " + OSequenceCached.this.name + " reaching limt, current value: " + OSequenceCached.this.cacheStart + " limit value: " + OSequenceCached.this.limitValue + " with step: " + OSequenceCached.this.increment;
                                    OLogManager.instance().warn((Object)this, warningMessage, new Object[0]);
                                }
                                OSequenceCached.this.firstCache = false;
                                return OSequenceCached.this.cacheStart;
                            }
                        }
                    }, "next");
                    if (!tx) break block9;
                }
                catch (Throwable throwable) {
                    if (tx) {
                        db.close();
                    }
                    throw throwable;
                }
                db.close();
            }
            return l;
        }
        finally {
            if (tx) {
                mainDb.activateOnCurrentThread();
            }
        }
    }

    @Override
    protected synchronized long currentWork() {
        return this.cacheStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long resetWork() {
        ODatabaseDocumentInternal mainDb = this.getDatabase();
        boolean tx = mainDb.getTransaction().isActive();
        try {
            long l;
            block9: {
                ODatabaseDocumentInternal db = mainDb;
                if (tx) {
                    db = mainDb.copy();
                    db.activateOnCurrentThread();
                }
                try {
                    final ODatabaseDocumentInternal finalDb = db;
                    l = this.callRetry(true, new Callable<Long>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Long call() throws Exception {
                            OSequenceCached oSequenceCached = OSequenceCached.this;
                            synchronized (oSequenceCached) {
                                long newValue = OSequenceCached.this.getStart();
                                OSequenceCached.this.setValue(newValue);
                                OSequenceCached.this.save(finalDb);
                                OSequenceCached.this.firstCache = true;
                                OSequenceCached.this.allocateCache(OSequenceCached.this.getCacheSize(), finalDb);
                                return newValue;
                            }
                        }
                    }, "reset");
                    if (!tx) break block9;
                }
                catch (Throwable throwable) {
                    if (tx) {
                        db.close();
                    }
                    throw throwable;
                }
                db.close();
            }
            return l;
        }
        finally {
            if (tx) {
                mainDb.activateOnCurrentThread();
            }
        }
    }

    @Override
    public OSequence.SEQUENCE_TYPE getSequenceType() {
        return OSequence.SEQUENCE_TYPE.CACHED;
    }

    public final int getCacheSize() {
        return (Integer)this.getDocument().field(FIELD_CACHE, OType.INTEGER);
    }

    public final void setCacheSize(int cacheSize) {
        this.getDocument().field(FIELD_CACHE, cacheSize);
    }

    private final void allocateCache(int cacheSize, ODatabaseDocumentInternal db) {
        long newValue;
        if (this.getCrucialValueChanged()) {
            this.reloadCrucialValues();
            this.setCrucialValueChanged(false);
        }
        SequenceOrderType orederType = this.getOrderType();
        long value = this.getValue();
        if (orederType == SequenceOrderType.ORDER_POSITIVE) {
            newValue = value + (long)(this.getIncrement() * cacheSize);
            if (this.limitValue != null && newValue > this.limitValue) {
                newValue = this.limitValue;
            }
        } else {
            newValue = value - (long)(this.getIncrement() * cacheSize);
            if (this.limitValue != null && newValue < this.limitValue) {
                newValue = this.limitValue;
            }
        }
        this.setValue(newValue);
        this.save(db);
        this.cacheStart = value;
        this.cacheEnd = orederType == SequenceOrderType.ORDER_POSITIVE ? newValue - 1L : newValue + 1L;
        this.firstCache = false;
    }
}

