/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.sequence;

import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.metadata.sequence.OSequence;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceCached;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceLibrary;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceLibraryAbstract;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceOrdered;
import com.orientechnologies.orient.core.record.impl.ODocument;

public class OSequenceHelper {
    public static final OSequence.SEQUENCE_TYPE DEFAULT_SEQUENCE_TYPE = OSequence.SEQUENCE_TYPE.CACHED;

    public static OSequence createSequence(OSequence.SEQUENCE_TYPE sequenceType, OSequence.CreateParams params, ODocument document) {
        switch (sequenceType) {
            case ORDERED: {
                return new OSequenceOrdered(document, params);
            }
            case CACHED: {
                return new OSequenceCached(document, params);
            }
        }
        throw new IllegalArgumentException("sequenceType");
    }

    public static OSequence.SEQUENCE_TYPE getSequenceTyeFromString(String typeAsString) {
        return OSequence.SEQUENCE_TYPE.valueOf(typeAsString);
    }

    public static OSequence createSequence(ODocument document) {
        OSequence.SEQUENCE_TYPE sequenceType = OSequence.getSequenceType(document);
        return OSequenceHelper.createSequence(sequenceType, null, document);
    }

    public static boolean updateParamsOnLocal(OSequence.CreateParams params, OSequence seq) throws ODatabaseException {
        return seq.updateParams(params, false);
    }

    public static long resetSequenceOnLocal(OSequence seq) throws ODatabaseException {
        return seq.reset(false);
    }

    public static long sequenceNextOnLocal(OSequence seq) throws ODatabaseException {
        return seq.next(false);
    }

    public static long sequenceCurrentOnLocal(OSequence seq) throws ODatabaseException {
        return seq.current(false);
    }

    public static void dropLocalSequence(OSequenceLibrary sequenceLibary, String name) throws ODatabaseException {
        if (!(sequenceLibary instanceof OSequenceLibraryAbstract)) {
            throw new ODatabaseException("Sequence library invalid class: " + sequenceLibary.getClass().getName() + ". Sequnce library should implement be derived form OSequenceLibraryAbstract");
        }
        ((OSequenceLibraryAbstract)sequenceLibary).dropSequence(name, false);
    }

    public static OSequence createSequenceOnLocal(OSequenceLibrary sequenceLibary, String sequenceName, OSequence.SEQUENCE_TYPE sequenceType, OSequence.CreateParams params) {
        if (sequenceLibary instanceof OSequenceLibraryAbstract) {
            return ((OSequenceLibraryAbstract)sequenceLibary).createSequence(sequenceName, sequenceType, params, false);
        }
        throw new ODatabaseException("Sequence library invalid class: " + sequenceLibary.getClass().getName() + ". Sequnce library should implement be derived form OSequenceLibraryAbstract");
    }

    public static long sequenceNextWithNewCurrentValueOnLocal(OSequenceCached seq, long currentValue) throws ODatabaseException {
        return seq.nextWithNewCurrentValue(currentValue, false);
    }
}

