/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.OIdentityChangeListener;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordAbstract;
import com.orientechnologies.orient.core.record.impl.ODirtyManager;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;

public class ORecordInternal {
    public static ORecordAbstract fill(ORecord record, ORID iRid, int iVersion, byte[] iBuffer, boolean iDirty) {
        ORecordAbstract rec = (ORecordAbstract)record;
        rec.fill(iRid, iVersion, iBuffer, iDirty);
        return rec;
    }

    public static ORecordAbstract fill(ORecord record, ORID iRid, int iVersion, byte[] iBuffer, boolean iDirty, ODatabaseDocumentInternal db) {
        ORecordAbstract rec = (ORecordAbstract)record;
        rec.fill(iRid, iVersion, iBuffer, iDirty, db);
        return rec;
    }

    public static ORecordAbstract setIdentity(ORecord record, int iClusterId, long iClusterPosition) {
        ORecordAbstract rec = (ORecordAbstract)record;
        rec.setIdentity(iClusterId, iClusterPosition);
        return rec;
    }

    public static ORecordAbstract setIdentity(ORecord record, ORecordId iIdentity) {
        ORecordAbstract rec = (ORecordAbstract)record;
        rec.setIdentity(iIdentity);
        return rec;
    }

    public static void unsetDirty(ORecord record) {
        ORecordAbstract rec = (ORecordAbstract)record;
        rec.unsetDirty();
    }

    public static void setVersion(ORecord record, int iVersion) {
        ORecordAbstract rec = (ORecordAbstract)record;
        rec.setVersion(iVersion);
    }

    public static byte getRecordType(ORecord record) {
        if (record instanceof ORecordAbstract) {
            return ((ORecordAbstract)record).getRecordType();
        }
        ORecordAbstract rec = (ORecordAbstract)record.getRecord();
        return rec.getRecordType();
    }

    public static boolean isContentChanged(ORecord record) {
        ORecordAbstract rec = (ORecordAbstract)record;
        return rec.isContentChanged();
    }

    public static void setContentChanged(ORecord record, boolean changed) {
        ORecordAbstract rec = (ORecordAbstract)record;
        rec.setContentChanged(changed);
    }

    public static void clearSource(ORecord record) {
        ORecordAbstract rec = (ORecordAbstract)record;
        rec.clearSource();
    }

    public static void addIdentityChangeListener(ORecord record, OIdentityChangeListener identityChangeListener) {
        if (!(record instanceof ORecordAbstract)) {
            record = record.getRecord();
        }
        if (record instanceof ORecordAbstract) {
            ((ORecordAbstract)record).addIdentityChangeListener(identityChangeListener);
        }
    }

    public static void removeIdentityChangeListener(ORecord record, OIdentityChangeListener identityChangeListener) {
        ((ORecordAbstract)record).removeIdentityChangeListener(identityChangeListener);
    }

    public static void onBeforeIdentityChanged(ORecord record) {
        ((ORecordAbstract)record).onBeforeIdentityChanged(record);
    }

    public static void onAfterIdentityChanged(ORecord record) {
        ((ORecordAbstract)record).onAfterIdentityChanged(record);
    }

    public static void setRecordSerializer(ORecord record, ORecordSerializer serializer) {
        ((ORecordAbstract)record).recordFormat = serializer;
    }

    public static ODirtyManager getDirtyManager(ORecord record) {
        if (!(record instanceof ORecordAbstract)) {
            record = record.getRecord();
        }
        return ((ORecordAbstract)record).getDirtyManager();
    }

    public static void setDirtyManager(ORecord record, ODirtyManager dirtyManager) {
        if (!(record instanceof ORecordAbstract)) {
            record = record.getRecord();
        }
        ((ORecordAbstract)record).setDirtyManager(dirtyManager);
    }

    public static void track(ORecordElement pointer, OIdentifiable pointed) {
        ORecordElement firstRecord = pointer;
        while (!(firstRecord instanceof ORecord)) {
            firstRecord = pointer.getOwner();
        }
        ((ORecordAbstract)firstRecord).track(pointed);
    }

    public static void unTrack(ORecordElement pointer, OIdentifiable pointed) {
        ORecordElement firstRecord = pointer;
        while (!(firstRecord instanceof ORecord)) {
            firstRecord = pointer.getOwner();
        }
        ((ORecordAbstract)firstRecord).unTrack(pointed);
    }

    public static ORecordSerializer getRecordSerializer(ORecord iRecord) {
        return ((ORecordAbstract)iRecord).recordFormat;
    }
}

