/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record;

import com.orientechnologies.orient.core.serialization.OBinaryProtocol;

public class ORecordVersionHelper {
    public static final int SERIALIZED_SIZE = 4;

    protected ORecordVersionHelper() {
    }

    public static int increment(int version) {
        if (ORecordVersionHelper.isTombstone(version)) {
            throw new IllegalStateException("Record was deleted and cannot be updated.");
        }
        return version + 1;
    }

    public static int decrement(int version) {
        if (ORecordVersionHelper.isTombstone(version)) {
            throw new IllegalStateException("Record was deleted and cannot be updated.");
        }
        return version - 1;
    }

    public static boolean isUntracked(int version) {
        return version == -1;
    }

    public static int setRollbackMode(int version) {
        return Integer.MIN_VALUE + version;
    }

    public static int clearRollbackMode(int version) {
        return version - Integer.MIN_VALUE;
    }

    public static boolean isTemporary(int version) {
        return version < -1;
    }

    public static boolean isValid(int version) {
        return version > -1;
    }

    public static boolean isTombstone(int version) {
        return version < 0;
    }

    public static byte[] toStream(int version) {
        return OBinaryProtocol.int2bytes(version);
    }

    public static int fromStream(byte[] stream) {
        return OBinaryProtocol.bytes2int(stream);
    }

    public static int reset() {
        return 0;
    }

    public static int disable() {
        return -1;
    }

    public static int compareTo(int v1, int v2) {
        int otherVersion;
        int myVersion = ORecordVersionHelper.isTombstone(v1) ? -v1 : v1;
        if (myVersion == (otherVersion = ORecordVersionHelper.isTombstone(v2) ? -v2 : v2)) {
            return 0;
        }
        if (myVersion < otherVersion) {
            return -1;
        }
        return 1;
    }

    public static String toString(int version) {
        return String.valueOf(version);
    }

    public static int fromString(String string) {
        return Integer.parseInt(string);
    }
}

