/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;

public class ODirtyManager {
    private ODirtyManager overrider;
    private Set<ORecord> newRecords;
    private Set<ORecord> updateRecords;

    public void setDirty(ORecord record) {
        ODirtyManager real = this.getReal();
        if (record.getIdentity().isNew() && !record.getIdentity().isTemporary()) {
            if (real.newRecords == null) {
                real.newRecords = Collections.newSetFromMap(new IdentityHashMap());
            }
            real.newRecords.add(record);
        } else {
            if (real.updateRecords == null) {
                real.updateRecords = Collections.newSetFromMap(new IdentityHashMap());
            }
            real.updateRecords.add(record);
        }
    }

    public ODirtyManager getReal() {
        ODirtyManager real = this;
        while (real.overrider != null) {
            real = real.overrider;
        }
        if (this.overrider != null && this.overrider != real) {
            this.overrider = real;
        }
        return real;
    }

    public Set<ORecord> getNewRecords() {
        return this.getReal().newRecords;
    }

    public Set<ORecord> getUpdateRecords() {
        return this.getReal().updateRecords;
    }

    public boolean isSame(ODirtyManager other) {
        return this.getReal() == other.getReal();
    }

    public void merge(ODirtyManager toMerge) {
        if (this.isSame(toMerge)) {
            return;
        }
        this.newRecords = ODirtyManager.mergeSet(this.newRecords, toMerge.getNewRecords());
        this.updateRecords = ODirtyManager.mergeSet(this.updateRecords, toMerge.getUpdateRecords());
        toMerge.override(this);
    }

    private static Set<ORecord> mergeSet(Set<ORecord> target, Set<ORecord> source) {
        if (source != null) {
            if (target == null) {
                return source;
            }
            if (target.size() > source.size()) {
                target.addAll(source);
                return target;
            }
            source.addAll(target);
            return source;
        }
        return target;
    }

    public void track(ORecord pointing, OIdentifiable pointed) {
        this.getReal().internalTrack(pointing, pointed);
    }

    public void unTrack(ORecord pointing, OIdentifiable pointed) {
        this.getReal().internalUnTrack(pointing, pointed);
    }

    private void internalUnTrack(ORecord pointing, OIdentifiable pointed) {
    }

    private void internalTrack(ORecord pointing, OIdentifiable pointed) {
        if (pointed instanceof ORecord) {
            ORecordInternal.setDirtyManager((ORecord)pointed, this);
        }
    }

    private void override(ODirtyManager oDirtyManager) {
        ODirtyManager real = this.getReal();
        if (real == (oDirtyManager = oDirtyManager.getReal())) {
            return;
        }
        real.overrider = oDirtyManager;
        real.newRecords = null;
        real.updateRecords = null;
    }

    public void clearForSave() {
        ODirtyManager real = this.getReal();
        real.newRecords = null;
        real.updateRecords = null;
    }

    public void removeNew(ORecord record) {
        ODirtyManager real = this.getReal();
        if (real.newRecords != null) {
            real.newRecords.remove(record);
        }
    }

    public void clear() {
        this.clearForSave();
    }
}

