/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OView;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.impl.ODocument;

public class OViewDocument
extends ODocument {
    private OView view;

    public OViewDocument(OView view) {
        this.view = view;
    }

    public OViewDocument(ODatabaseDocumentInternal database, int cluster) {
        this.view = database.getViewFromCluster(cluster);
    }

    @Override
    public OView getSchemaClass() {
        return this.view;
    }

    @Override
    public String getClassName() {
        OView clazz = this.getSchemaClass();
        return clazz == null ? null : clazz.getName();
    }

    @Override
    public void setProperty(String iFieldName, Object iPropertyValue) {
        String originField;
        super.setProperty(iFieldName, iPropertyValue);
        if (this.view != null && this.view.isUpdatable() && (originField = this.view.getOriginRidField()) != null) {
            Object origin = this.getProperty(originField);
            if (origin instanceof ORID) {
                origin = ((ORID)origin).getRecord();
            }
            if (origin instanceof OElement) {
                ((OElement)origin).setProperty(iFieldName, iPropertyValue);
            }
        }
    }
}

