/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.serialization.OStreamable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;

public class OStreamableHelper {
    static final byte NULL = 0;
    static final byte STREAMABLE = 1;
    static final byte SERIALIZABLE = 2;
    static final byte STRING = 10;
    static final byte INTEGER = 11;
    static final byte SHORT = 12;
    static final byte LONG = 13;
    static final byte BOOLEAN = 14;
    private static ClassLoader streamableClassLoader;

    public static void setStreamableClassLoader(ClassLoader streamableClassLoader) {
        OStreamableHelper.streamableClassLoader = streamableClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toStream(DataOutput out, Object object) throws IOException {
        if (object == null) {
            out.writeByte(0);
        } else if (object instanceof OStreamable) {
            out.writeByte(1);
            out.writeUTF(object.getClass().getName());
            ((OStreamable)object).toStream(out);
        } else if (object instanceof String) {
            out.writeByte(10);
            out.writeUTF((String)object);
        } else if (object instanceof Integer) {
            out.writeByte(11);
            out.writeInt((Integer)object);
        } else if (object instanceof Short) {
            out.writeByte(12);
            out.writeShort(((Short)object).shortValue());
        } else if (object instanceof Long) {
            out.writeByte(13);
            out.writeLong((Long)object);
        } else if (object instanceof Boolean) {
            out.writeByte(14);
            out.writeBoolean((Boolean)object);
        } else if (object instanceof Serializable) {
            out.writeByte(2);
            ByteArrayOutputStream mem = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(mem);
            try {
                oos.writeObject(object);
                oos.flush();
                byte[] buffer = mem.toByteArray();
                out.writeInt(buffer.length);
                out.write(buffer);
            }
            finally {
                oos.close();
                mem.close();
            }
        } else {
            throw new OSerializationException("Object not supported: " + object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fromStream(DataInput in) throws IOException {
        Object object = null;
        byte objectType = in.readByte();
        switch (objectType) {
            case 0: {
                return null;
            }
            case 1: {
                String payloadClassName = in.readUTF();
                try {
                    object = streamableClassLoader != null ? (Object)streamableClassLoader.loadClass(payloadClassName).newInstance() : (Object)Class.forName(payloadClassName).newInstance();
                    ((OStreamable)object).fromStream(in);
                }
                catch (Exception e) {
                    OException.wrapException(new OSerializationException("Cannot unmarshall object from distributed request"), e);
                }
                break;
            }
            case 2: {
                byte[] buffer = new byte[in.readInt()];
                in.readFully(buffer);
                ByteArrayInputStream mem = new ByteArrayInputStream(buffer);
                ObjectInputStream ois = streamableClassLoader != null ? new ObjectInputStream(mem){

                    @Override
                    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                        return streamableClassLoader.loadClass(desc.getName());
                    }
                } : new ObjectInputStream(mem);
                try {
                    try {
                        object = ois.readObject();
                    }
                    catch (ClassNotFoundException e) {
                        OException.wrapException(new OSerializationException("Cannot unmarshall object from distributed request"), e);
                    }
                    break;
                }
                finally {
                    ois.close();
                    mem.close();
                }
            }
            case 10: {
                return in.readUTF();
            }
            case 11: {
                return in.readInt();
            }
            case 12: {
                return in.readShort();
            }
            case 13: {
                return in.readLong();
            }
            case 14: {
                return in.readBoolean();
            }
            default: {
                throw new OSerializationException("Object type not supported: " + objectType);
            }
        }
        return object;
    }
}

