/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.binary;

import com.orientechnologies.common.serialization.types.OUUIDSerializer;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV37;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OVarIntSerializer;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OBonsaiBucketPointer;
import com.orientechnologies.orient.core.storage.ridbag.ORemoteTreeRidBag;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.Change;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.ChangeSerializationHelper;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import java.util.HashMap;
import java.util.UUID;

public class ORecordSerializerNetworkV37Client
extends ORecordSerializerNetworkV37 {
    public static final ORecordSerializerNetworkV37Client INSTANCE = new ORecordSerializerNetworkV37Client();
    public static final String NAME = "onet_ser_v37_client";

    @Override
    protected ORidBag readRidBag(BytesContainer bytes) {
        UUID uuid = OUUIDSerializer.INSTANCE.deserialize(bytes.bytes, bytes.offset);
        bytes.skip(16);
        if (uuid.getMostSignificantBits() == -1L && uuid.getLeastSignificantBits() == -1L) {
            uuid = null;
        }
        byte b = bytes.bytes[bytes.offset];
        bytes.skip(1);
        if (b == 1) {
            ORidBag bag = new ORidBag(uuid);
            int size = OVarIntSerializer.readAsInteger(bytes);
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    OIdentifiable id = this.readOptimizedLink(bytes);
                    if (id.equals(NULL_RECORD_ID)) {
                        bag.add(null);
                        continue;
                    }
                    bag.add(id);
                }
                bag.enableTracking(null);
                bag.transactionClear();
            }
            return bag;
        }
        long fileId = OVarIntSerializer.readAsLong(bytes);
        long pageIndex = OVarIntSerializer.readAsLong(bytes);
        int pageOffset = OVarIntSerializer.readAsInteger(bytes);
        int bagSize = OVarIntSerializer.readAsInteger(bytes);
        HashMap<OIdentifiable, Change> changes = new HashMap<OIdentifiable, Change>();
        int size = OVarIntSerializer.readAsInteger(bytes);
        while (size-- > 0) {
            OIdentifiable link = this.readOptimizedLink(bytes);
            byte type = bytes.bytes[bytes.offset];
            bytes.skip(1);
            int change = OVarIntSerializer.readAsInteger(bytes);
            changes.put(link, ChangeSerializationHelper.createChangeInstance(type, change));
        }
        OBonsaiCollectionPointer pointer = null;
        if (fileId != -1L) {
            pointer = new OBonsaiCollectionPointer(fileId, new OBonsaiBucketPointer(pageIndex, pageOffset));
        }
        return new ORidBag(new ORemoteTreeRidBag(pointer));
    }
}

