/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.binary;

import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.OBlob;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ODocumentSerializer;
import com.orientechnologies.orient.core.sql.executor.OResult;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class OResultBinary
implements OResult {
    private ODocumentSerializer serializer;
    private Optional<ORecordId> id;
    private final byte[] bytes;
    private final int offset;
    private final int fieldLength;
    private OImmutableSchema schema;

    public OResultBinary(OImmutableSchema schema, byte[] bytes, int offset, int fieldLength, ODocumentSerializer serializer) {
        this.schema = schema;
        this.id = Optional.empty();
        this.bytes = bytes;
        this.serializer = serializer;
        this.offset = offset;
        this.fieldLength = fieldLength;
    }

    public OResultBinary(ODatabaseSession db, byte[] bytes, int offset, int fieldLength, ODocumentSerializer serializer, ORecordId id) {
        this.schema = ((OMetadataInternal)db.getMetadata()).getImmutableSchemaSnapshot();
        this.id = Optional.of(id);
        this.bytes = bytes;
        this.serializer = serializer;
        this.offset = offset;
        this.fieldLength = fieldLength;
    }

    public int getFieldLength() {
        return this.fieldLength;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public <T> T getProperty(String name) {
        BytesContainer bytes = new BytesContainer(this.bytes);
        bytes.skip(this.offset);
        return (T)this.serializer.deserializeFieldTyped(bytes, name, !this.id.isPresent(), this.schema, null);
    }

    @Override
    public OElement getElementProperty(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public OVertex getVertexProperty(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public OEdge getEdgeProperty(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public OBlob getBlobProperty(String name) {
        return null;
    }

    @Override
    public Set<String> getPropertyNames() {
        BytesContainer container = new BytesContainer(this.bytes);
        container.skip(this.offset);
        String[] fields = this.serializer.getFieldNames(new ODocument(), container, !this.id.isPresent());
        return new HashSet<String>(Arrays.asList(fields));
    }

    @Override
    public Optional<ORID> getIdentity() {
        return this.id.map(id -> id);
    }

    @Override
    public boolean isElement() {
        return true;
    }

    @Override
    public Optional<OElement> getElement() {
        return Optional.of(this.toDocument());
    }

    @Override
    public OElement toElement() {
        return this.toDocument();
    }

    @Override
    public boolean isBlob() {
        return false;
    }

    @Override
    public Optional<OBlob> getBlob() {
        return null;
    }

    @Override
    public Optional<ORecord> getRecord() {
        return Optional.of(this.toDocument());
    }

    @Override
    public boolean isProjection() {
        return false;
    }

    @Override
    public Object getMetadata(String key) {
        return null;
    }

    @Override
    public Set<String> getMetadataKeys() {
        return null;
    }

    @Override
    public boolean hasProperty(String varName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private ODocument toDocument() {
        ODocument doc = new ODocument();
        BytesContainer bytes = new BytesContainer(this.bytes);
        bytes.skip(this.offset);
        this.serializer.deserialize(doc, bytes);
        return doc;
    }
}

