/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.string;

import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerCSVAbstract;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ORecordSerializerSchemaAware2CSV
extends ORecordSerializerCSVAbstract {
    public static final String NAME = "ORecordDocument2csv";
    public static final ORecordSerializerSchemaAware2CSV INSTANCE = new ORecordSerializerSchemaAware2CSV();
    private static final long serialVersionUID = 1L;

    public String toString() {
        return NAME;
    }

    @Override
    public int getCurrentVersion() {
        return 0;
    }

    @Override
    public int getMinSupportedVersion() {
        return 0;
    }

    public String getClassName(String content) {
        if ((content = content.trim()).length() == 0) {
            return null;
        }
        int posFirstValue = content.indexOf(58);
        int pos = content.indexOf("@");
        if (pos > -1 && (pos < posFirstValue || posFirstValue == -1)) {
            return content.substring(0, pos);
        }
        return null;
    }

    @Override
    public ORecord fromString(String iContent, ORecord iRecord, String[] iFields) {
        HashSet<String> fieldSet;
        if ((iContent = iContent.trim()).length() == 0) {
            return iRecord;
        }
        ODocument record = (ODocument)iRecord;
        ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.instance().getIfDefined();
        int posFirstValue = iContent.indexOf(58);
        int pos = iContent.indexOf("@");
        if (pos > -1 && (pos < posFirstValue || posFirstValue == -1)) {
            if (record.getIdentity().getClusterId() < 0 || database == null) {
                ODocumentInternal.fillClassNameIfNeeded((ODocument)iRecord, iContent.substring(0, pos));
            }
            iContent = iContent.substring(pos + 1);
        } else {
            record.setClassNameIfExists(null);
        }
        if (iFields != null && iFields.length == 1 && iFields[0].equals("@class")) {
            return iRecord;
        }
        List<String> fields = OStringSerializerHelper.smartSplit(iContent, ',', true, true, new char[0]);
        String fieldName = null;
        if (iFields != null && iFields.length > 0) {
            fieldSet = new HashSet<String>(iFields.length);
            for (String f : iFields) {
                fieldSet.add(f);
            }
        } else {
            fieldSet = null;
        }
        for (String fieldEntry : fields) {
            fieldEntry = fieldEntry.trim();
            boolean uncertainType = false;
            try {
                Object value;
                OType linkedType;
                OClass linkedClass;
                OType type;
                pos = fieldEntry.indexOf(58);
                if (pos <= -1) continue;
                fieldName = fieldEntry.substring(0, pos);
                if (fieldSet != null && !fieldSet.contains(fieldName) || record.containsField(fieldName)) continue;
                String fieldValue = fieldEntry.length() > pos + 1 ? fieldEntry.substring(pos + 1) : null;
                boolean setFieldType = false;
                OProperty prop = ODocumentInternal.getImmutableSchemaClass(record) != null ? ODocumentInternal.getImmutableSchemaClass(record).getProperty(fieldName) : null;
                if (prop != null && prop.getType() != OType.ANY) {
                    type = prop.getType();
                    linkedClass = prop.getLinkedClass();
                    linkedType = prop.getLinkedType();
                } else {
                    type = record.fieldType(fieldName);
                    if (type == OType.ANY) {
                        type = null;
                    }
                    if (type != null) {
                        setFieldType = true;
                    }
                    linkedClass = null;
                    linkedType = null;
                    if (fieldValue != null && type == null) {
                        if (fieldValue.length() > 1 && fieldValue.charAt(0) == '\"' && fieldValue.charAt(fieldValue.length() - 1) == '\"') {
                            type = OType.STRING;
                        } else if (fieldValue.startsWith("<#@")) {
                            type = OType.LINKSET;
                        } else if (fieldValue.charAt(0) == '[' && fieldValue.charAt(fieldValue.length() - 1) == ']' || fieldValue.charAt(0) == '<' && fieldValue.charAt(fieldValue.length() - 1) == '>') {
                            type = fieldValue.charAt(0) == '[' ? OType.EMBEDDEDLIST : OType.EMBEDDEDSET;
                            value = fieldValue.substring(1, fieldValue.length() - 1);
                            if (!((String)value).isEmpty()) {
                                if (((String)value).charAt(0) == '#') {
                                    int max = ((String)value).length();
                                    boolean allLinks = true;
                                    boolean checkRid = true;
                                    for (int i = 0; i < max; ++i) {
                                        char c = ((String)value).charAt(i);
                                        if (checkRid) {
                                            if (c != '#') {
                                                allLinks = false;
                                                break;
                                            }
                                            checkRid = false;
                                            continue;
                                        }
                                        if (c != ',') continue;
                                        checkRid = true;
                                    }
                                    if (allLinks) {
                                        type = fieldValue.charAt(0) == '[' ? OType.LINKLIST : OType.LINKSET;
                                        linkedType = OType.LINK;
                                    }
                                } else if (((String)value).charAt(0) == '(') {
                                    linkedType = OType.EMBEDDED;
                                } else if (((String)value).charAt(0) == '^') {
                                    linkedType = OType.CUSTOM;
                                } else if (Character.isDigit(((String)value).charAt(0)) || ((String)value).charAt(0) == '+' || ((String)value).charAt(0) == '-') {
                                    String[] items = ((String)value).split(",");
                                    linkedType = ORecordSerializerSchemaAware2CSV.getType(items[0]);
                                } else if (((String)value).charAt(0) == '\'' || ((String)value).charAt(0) == '\"') {
                                    linkedType = OType.STRING;
                                }
                            } else {
                                uncertainType = true;
                            }
                        } else {
                            type = fieldValue.charAt(0) == '{' && fieldValue.charAt(fieldValue.length() - 1) == '}' ? OType.EMBEDDEDMAP : (fieldValue.charAt(0) == '#' ? OType.LINK : (fieldValue.charAt(0) == '(' ? (fieldValue.startsWith("(ORIDs") ? OType.LINKSET : OType.EMBEDDED) : (fieldValue.charAt(0) == '%' ? OType.LINKBAG : (fieldValue.equals("true") || fieldValue.equals("false") ? OType.BOOLEAN : ORecordSerializerSchemaAware2CSV.getType(fieldValue)))));
                        }
                    }
                }
                value = this.fieldFromStream(iRecord, type, linkedClass, linkedType, fieldName, fieldValue);
                if ("@class".equals(fieldName)) {
                    ODocumentInternal.fillClassNameIfNeeded((ODocument)iRecord, value.toString());
                } else {
                    record.field(fieldName, value, type);
                }
                if (!uncertainType) continue;
                record.setFieldType(fieldName, null);
            }
            catch (Exception e) {
                throw OException.wrapException(new OSerializationException("Error on unmarshalling field '" + fieldName + "' in record " + iRecord.getIdentity() + " with value: " + fieldEntry), e);
            }
        }
        return iRecord;
    }

    @Override
    public byte[] toStream(ORecord iRecord) {
        byte[] result = super.toStream(iRecord);
        if (result == null || result.length > 0) {
            return result;
        }
        ODocument recordSchemaAware = (ODocument)iRecord;
        if (recordSchemaAware.fields() > 0) {
            return null;
        }
        return result;
    }

    public byte[] writeClassOnly(ORecord iSource) {
        ODocument record = (ODocument)iSource;
        StringBuilder iOutput = new StringBuilder();
        if (ODocumentInternal.getImmutableSchemaClass(record) != null) {
            iOutput.append(ODocumentInternal.getImmutableSchemaClass(record).getStreamableName());
            iOutput.append("@");
        }
        try {
            return iOutput.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw OException.wrapException(new OSerializationException("error writing class name"), e);
        }
    }

    @Override
    protected StringBuilder toString(ORecord iRecord, StringBuilder iOutput, String iFormat, boolean autoDetectCollectionType) {
        String[] fieldNames;
        if (iRecord == null) {
            throw new OSerializationException("Expected a record but was null");
        }
        if (!(iRecord instanceof ODocument)) {
            throw new OSerializationException("Cannot marshall a record of type " + iRecord.getClass().getSimpleName());
        }
        ODocument record = (ODocument)iRecord;
        if (ODocumentInternal.getImmutableSchemaClass(record) != null) {
            iOutput.append(ODocumentInternal.getImmutableSchemaClass(record).getStreamableName());
            iOutput.append("@");
        }
        int i = 0;
        for (String fieldName : fieldNames = record.fieldNames()) {
            Object fieldValue = record.rawField(fieldName);
            if (i > 0) {
                iOutput.append(',');
            }
            OProperty prop = ODocumentInternal.getImmutableSchemaClass(record) != null ? ODocumentInternal.getImmutableSchemaClass(record).getProperty(fieldName) : null;
            String fieldClassName = this.getClassName(fieldValue);
            OType type = record.fieldType(fieldName);
            if (type == OType.ANY) {
                type = null;
            }
            OClass linkedClass = null;
            OType linkedType = null;
            if (prop != null && prop.getType() != OType.ANY) {
                type = prop.getType();
                linkedClass = prop.getLinkedClass();
                linkedType = prop.getLinkedType();
            } else if (fieldValue != null && type == null) {
                Object firstValue;
                Boolean autoConvertLinks;
                int size;
                if (fieldValue.getClass() == byte[].class) {
                    type = OType.BINARY;
                } else if (ODatabaseRecordThreadLocal.instance().isDefined() && fieldValue instanceof ORecord) {
                    if (type == null) {
                        type = fieldValue instanceof ODocument && ((ODocument)fieldValue).hasOwners() ? OType.EMBEDDED : OType.LINK;
                    }
                    linkedClass = this.getLinkInfo(ODatabaseRecordThreadLocal.instance().get(), fieldClassName);
                } else if (fieldValue instanceof ORID) {
                    type = OType.LINK;
                } else if (fieldValue instanceof Date) {
                    type = OType.DATETIME;
                } else if (fieldValue instanceof String) {
                    type = OType.STRING;
                } else if (fieldValue instanceof Integer || fieldValue instanceof BigInteger) {
                    type = OType.INTEGER;
                } else if (fieldValue instanceof Long) {
                    type = OType.LONG;
                } else if (fieldValue instanceof Float) {
                    type = OType.FLOAT;
                } else if (fieldValue instanceof Short) {
                    type = OType.SHORT;
                } else if (fieldValue instanceof Byte) {
                    type = OType.BYTE;
                } else if (fieldValue instanceof Double) {
                    type = OType.DOUBLE;
                } else if (fieldValue instanceof BigDecimal) {
                    type = OType.DECIMAL;
                } else if (fieldValue instanceof ORidBag) {
                    type = OType.LINKBAG;
                }
                if (fieldValue instanceof OMultiCollectionIterator) {
                    type = ((OMultiCollectionIterator)fieldValue).isEmbedded() ? OType.EMBEDDEDLIST : OType.LINKLIST;
                    linkedType = ((OMultiCollectionIterator)fieldValue).isEmbedded() ? OType.EMBEDDED : OType.LINK;
                } else if (fieldValue instanceof Collection || fieldValue.getClass().isArray()) {
                    size = OMultiValue.getSize(fieldValue);
                    autoConvertLinks = null;
                    if (fieldValue instanceof ORecordLazyMultiValue && (autoConvertLinks = Boolean.valueOf(((ORecordLazyMultiValue)fieldValue).isAutoConvertToRecord())).booleanValue()) {
                        ((ORecordLazyMultiValue)fieldValue).setAutoConvertToRecord(false);
                    }
                    if (autoDetectCollectionType) {
                        if (size > 0) {
                            firstValue = OMultiValue.getFirstValue(fieldValue);
                            if (firstValue != null) {
                                if (firstValue instanceof ORID) {
                                    linkedClass = null;
                                    linkedType = OType.LINK;
                                    type = fieldValue instanceof Set ? OType.LINKSET : OType.LINKLIST;
                                } else if (ODatabaseRecordThreadLocal.instance().isDefined() && firstValue instanceof ODocument && !((ODocument)firstValue).isEmbedded() && firstValue instanceof ORecord) {
                                    linkedClass = this.getLinkInfo(ODatabaseRecordThreadLocal.instance().get(), this.getClassName(firstValue));
                                    if (type == null) {
                                        linkedType = OType.LINK;
                                        type = fieldValue instanceof Set ? OType.LINKSET : OType.LINKLIST;
                                    } else {
                                        linkedType = OType.EMBEDDED;
                                    }
                                } else {
                                    if (firstValue instanceof ODocument && (((ODocument)firstValue).hasOwners() || type == OType.EMBEDDEDSET || type == OType.EMBEDDEDLIST || type == OType.EMBEDDEDMAP)) {
                                        linkedType = OType.EMBEDDED;
                                    } else if (firstValue instanceof Enum) {
                                        linkedType = OType.STRING;
                                    } else {
                                        linkedType = OType.getTypeByClass(firstValue.getClass());
                                        if (linkedType != OType.LINK) {
                                            linkedType = null;
                                        }
                                    }
                                    if (type == null) {
                                        type = fieldValue instanceof ORecordLazySet ? OType.LINKSET : (fieldValue instanceof Set ? OType.EMBEDDEDSET : OType.EMBEDDEDLIST);
                                    }
                                }
                            }
                        } else if (type == null) {
                            type = OType.EMBEDDEDLIST;
                        }
                    }
                    if (fieldValue instanceof ORecordLazyMultiValue && autoConvertLinks.booleanValue()) {
                        ((ORecordLazyMultiValue)fieldValue).setAutoConvertToRecord(true);
                    }
                } else if (fieldValue instanceof Map && type == null) {
                    size = OMultiValue.getSize(fieldValue);
                    autoConvertLinks = null;
                    if (fieldValue instanceof ORecordLazyMap && (autoConvertLinks = Boolean.valueOf(((ORecordLazyMap)fieldValue).isAutoConvertToRecord())).booleanValue()) {
                        ((ORecordLazyMap)fieldValue).setAutoConvertToRecord(false);
                    }
                    if (size > 0 && (firstValue = OMultiValue.getFirstValue(fieldValue)) != null && ODatabaseRecordThreadLocal.instance().isDefined() && firstValue instanceof ODocument && !((ODocument)firstValue).isEmbedded() && firstValue instanceof ORecord) {
                        linkedClass = this.getLinkInfo(ODatabaseRecordThreadLocal.instance().get(), this.getClassName(firstValue));
                        linkedType = OType.LINK;
                        type = OType.LINKMAP;
                    }
                    if (type == null) {
                        type = OType.EMBEDDEDMAP;
                    }
                    if (fieldValue instanceof ORecordLazyMap && autoConvertLinks.booleanValue()) {
                        ((ORecordLazyMap)fieldValue).setAutoConvertToRecord(true);
                    }
                }
            }
            if (type == OType.TRANSIENT) continue;
            if (type == null) {
                type = OType.EMBEDDED;
            }
            iOutput.append(fieldName);
            iOutput.append(':');
            this.fieldToStream(record, iOutput, type, linkedClass, linkedType, fieldName, fieldValue, true);
            ++i;
        }
        float overSize = ODocumentInternal.getImmutableSchemaClass(record) != null ? ODocumentInternal.getImmutableSchemaClass(record).getOverSize() : 0.0f;
        int newSize = record.hasOwners() ? iOutput.length() : (record.getSize() == iOutput.length() ? record.getSize() : (record.getSize() > iOutput.length() && !OGlobalConfiguration.RECORD_DOWNSIZING_ENABLED.getValueAsBoolean() ? record.getSize() : (overSize > 0.0f ? (int)((float)iOutput.length() * overSize) : iOutput.length())));
        if (newSize > iOutput.length()) {
            iOutput.ensureCapacity(newSize);
            for (int b = iOutput.length(); b < newSize; ++b) {
                iOutput.append(' ');
            }
        }
        return iOutput;
    }

    private String getClassName(Object iValue) {
        if (iValue instanceof ODocument) {
            return ((ODocument)iValue).getClassName();
        }
        return iValue != null ? iValue.getClass().getSimpleName() : null;
    }

    private OClass getLinkInfo(ODatabaseInternal<?> iDatabase, String iFieldClassName) {
        if (iDatabase == null || iDatabase.isClosed() || iFieldClassName == null) {
            return null;
        }
        OClass linkedClass = ((OMetadataInternal)iDatabase.getMetadata()).getImmutableSchemaSnapshot().getClass(iFieldClassName);
        return linkedClass;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

