/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.index.OIndexMetadata;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OChainedIndexProxy<T>
implements OIndexInternal {
    private final OIndex firstIndex;
    private final List<OIndex> indexChain;
    private final OIndex lastIndex;

    private OChainedIndexProxy(List<OIndex> indexChain) {
        this.firstIndex = indexChain.get(0);
        this.indexChain = Collections.unmodifiableList(indexChain);
        this.lastIndex = indexChain.get(indexChain.size() - 1);
    }

    public static <T> Collection<OChainedIndexProxy<T>> createProxies(OClass iSchemaClass, OSQLFilterItemField.FieldChain longChain) {
        ArrayList<OChainedIndexProxy<T>> proxies = new ArrayList<OChainedIndexProxy<T>>();
        for (List<OIndex> indexChain : OChainedIndexProxy.getIndexesForChain(iSchemaClass, longChain)) {
            proxies.add(new OChainedIndexProxy<T>(indexChain));
        }
        return proxies;
    }

    private static boolean isComposite(OIndex currentIndex) {
        return currentIndex.getDefinition().getParamCount() > 1;
    }

    private static Iterable<List<OIndex>> getIndexesForChain(OClass iSchemaClass, OSQLFilterItemField.FieldChain fieldChain) {
        List<OIndex> baseIndexes = OChainedIndexProxy.prepareBaseIndexes(iSchemaClass, fieldChain);
        if (baseIndexes == null) {
            return Collections.emptyList();
        }
        Collection<OIndex> lastIndexes = OChainedIndexProxy.prepareLastIndexVariants(iSchemaClass, fieldChain);
        ArrayList<List<OIndex>> result = new ArrayList<List<OIndex>>();
        for (OIndex lastIndex : lastIndexes) {
            ArrayList<OIndex> indexes = new ArrayList<OIndex>(fieldChain.getItemCount());
            indexes.addAll(baseIndexes);
            indexes.add(lastIndex);
            result.add(indexes);
        }
        return result;
    }

    private static Collection<OIndex> prepareLastIndexVariants(OClass iSchemaClass, OSQLFilterItemField.FieldChain fieldChain) {
        OClass oClass = iSchemaClass;
        ArrayList<OIndex> result = new ArrayList<OIndex>();
        for (int i = 0; i < fieldChain.getItemCount() - 1; ++i) {
            if ((oClass = oClass.getProperty(fieldChain.getItemName(i)).getLinkedClass()) != null) continue;
            return result;
        }
        TreeSet<OIndex> involvedIndexes = new TreeSet<OIndex>(Comparator.comparingInt(o -> o.getDefinition().getParamCount()));
        involvedIndexes.addAll(oClass.getInvolvedIndexes(fieldChain.getItemName(fieldChain.getItemCount() - 1)));
        HashSet indexTypes = new HashSet(3);
        for (OIndex involvedIndex : involvedIndexes) {
            if (indexTypes.contains(involvedIndex.getInternal().getClass())) continue;
            result.add(involvedIndex);
            indexTypes.add(involvedIndex.getInternal().getClass());
        }
        return result;
    }

    private static List<OIndex> prepareBaseIndexes(OClass iSchemaClass, OSQLFilterItemField.FieldChain fieldChain) {
        ArrayList<OIndex> result = new ArrayList<OIndex>(fieldChain.getItemCount() - 1);
        OClass oClass = iSchemaClass;
        for (int i = 0; i < fieldChain.getItemCount() - 1; ++i) {
            Set<OIndex> involvedIndexes = oClass.getInvolvedIndexes(fieldChain.getItemName(i));
            OIndex bestIndex = OChainedIndexProxy.findBestIndex(involvedIndexes);
            if (bestIndex == null) {
                return null;
            }
            result.add(bestIndex);
            oClass = oClass.getProperty(fieldChain.getItemName(i)).getLinkedClass();
        }
        return result;
    }

    protected static OIndex findBestIndex(Iterable<OIndex> indexes) {
        OIndex bestIndex = null;
        for (OIndex index : indexes) {
            if (OChainedIndexProxy.priorityOfUsage(index) <= OChainedIndexProxy.priorityOfUsage(bestIndex)) continue;
            bestIndex = index;
        }
        return bestIndex;
    }

    private static int priorityOfUsage(OIndex index) {
        if (index == null) {
            return -1;
        }
        OClass.INDEX_TYPE indexType = OClass.INDEX_TYPE.valueOf(index.getType());
        boolean isComposite = OChainedIndexProxy.isComposite(index);
        boolean supportNullValues = OChainedIndexProxy.supportNullValues(index);
        int priority = 1;
        if (isComposite) {
            if (!supportNullValues) {
                return -1;
            }
        } else {
            priority += 10;
        }
        switch (indexType) {
            case UNIQUE_HASH_INDEX: 
            case NOTUNIQUE_HASH_INDEX: {
                if (isComposite) {
                    return -1;
                }
                priority += 10;
                break;
            }
            case UNIQUE: 
            case NOTUNIQUE: {
                priority += 5;
                break;
            }
            case PROXY: 
            case FULLTEXT: 
            case DICTIONARY: 
            case DICTIONARY_HASH_INDEX: 
            case SPATIAL: {
                return -1;
            }
        }
        return priority;
    }

    public static boolean isAppropriateAsBase(OIndex index) {
        return OChainedIndexProxy.priorityOfUsage(index) > 0;
    }

    private static boolean supportNullValues(OIndex index) {
        ODocument metadata = index.getMetadata();
        if (metadata == null) {
            return false;
        }
        Boolean ignoreNullValues = (Boolean)metadata.field("ignoreNullValues");
        return Boolean.FALSE.equals(ignoreNullValues);
    }

    @Override
    public String getDatabaseName() {
        return this.firstIndex.getDatabaseName();
    }

    public List<String> getIndexNames() {
        ArrayList<String> names = new ArrayList<String>(this.indexChain.size());
        for (OIndex oIndex : this.indexChain) {
            names.add(oIndex.getName());
        }
        return names;
    }

    @Override
    public String getName() {
        StringBuilder res = new StringBuilder("IndexChain{");
        List<String> indexNames = this.getIndexNames();
        for (int i = 0; i < indexNames.size(); ++i) {
            String indexName = indexNames.get(i);
            if (i > 0) {
                res.append(", ");
            }
            res.append(indexName);
        }
        res.append("}");
        return res.toString();
    }

    @Deprecated
    public T get(Object key) {
        List lastIndexResult;
        try (Stream<ORID> stream = this.lastIndex.getInternal().getRids(key);){
            lastIndexResult = stream.collect(Collectors.toList());
        }
        HashSet<ORID> result = new HashSet<ORID>(this.applyTailIndexes(lastIndexResult));
        return (T)result;
    }

    @Override
    public Stream<ORID> getRids(Object key) {
        List lastIndexResult;
        try (Stream<ORID> stream = this.lastIndex.getInternal().getRids(key);){
            lastIndexResult = stream.collect(Collectors.toList());
        }
        HashSet<ORID> result = new HashSet<ORID>(this.applyTailIndexes(lastIndexResult));
        return result.stream().map(OIdentifiable::getIdentity);
    }

    @Override
    public OIndexInternal getInternal() {
        return this;
    }

    @Override
    public OIndexDefinition getDefinition() {
        return this.lastIndex.getDefinition();
    }

    private List<ORID> applyTailIndexes(Object lastIndexResult) {
        OIndex beforeTheLastIndex = this.indexChain.get(this.indexChain.size() - 2);
        Set<Comparable> currentKeys = OChainedIndexProxy.prepareKeys(beforeTheLastIndex, lastIndexResult);
        for (int j = this.indexChain.size() - 2; j > 0; --j) {
            Set<Comparable> newKeys;
            OIndex currentIndex = this.indexChain.get(j);
            OIndex nextIndex = this.indexChain.get(j - 1);
            if (OChainedIndexProxy.isComposite(currentIndex)) {
                newKeys = new TreeSet<Comparable>();
                for (Comparable currentKey : currentKeys) {
                    List<ORID> currentResult = OChainedIndexProxy.getFromCompositeIndex(currentKey, currentIndex);
                    newKeys.addAll(OChainedIndexProxy.prepareKeys(nextIndex, currentResult));
                }
            } else {
                List keys;
                try (Stream<ORawPair<Object, ORID>> stream = currentIndex.getInternal().streamEntries(currentKeys, true);){
                    keys = stream.map(pair -> (ORID)pair.second).collect(Collectors.toList());
                }
                newKeys = OChainedIndexProxy.prepareKeys(nextIndex, keys);
            }
            OChainedIndexProxy.updateStatistic(currentIndex);
            currentKeys = newKeys;
        }
        return this.applyFirstIndex(currentKeys);
    }

    private List<ORID> applyFirstIndex(Collection<Comparable> currentKeys) {
        List<ORID> result;
        if (OChainedIndexProxy.isComposite(this.firstIndex)) {
            result = new ArrayList<ORID>();
            for (Comparable key : currentKeys) {
                result.addAll(OChainedIndexProxy.getFromCompositeIndex(key, this.firstIndex));
            }
        } else {
            try (Stream<ORawPair<Object, ORID>> stream = this.firstIndex.getInternal().streamEntries(currentKeys, true);){
                result = stream.map(pair -> (ORID)pair.second).collect(Collectors.toList());
            }
        }
        OChainedIndexProxy.updateStatistic(this.firstIndex);
        return result;
    }

    private static List<ORID> getFromCompositeIndex(Comparable currentKey, OIndex currentIndex) {
        try (Stream<ORawPair<Object, ORID>> stream = currentIndex.getInternal().streamEntriesBetween(currentKey, true, currentKey, true, true);){
            List<ORID> list = stream.map(pair -> (ORID)pair.second).collect(Collectors.toList());
            return list;
        }
    }

    private static Set<Comparable> prepareKeys(OIndex index, Object keys) {
        OIndexDefinition indexDefinition = index.getDefinition();
        if (keys instanceof Collection) {
            TreeSet<Comparable> newKeys = new TreeSet<Comparable>();
            for (Object o : (Collection)keys) {
                newKeys.add((Comparable)indexDefinition.createValue(o));
            }
            return newKeys;
        }
        return Collections.singleton((Comparable)indexDefinition.createValue(keys));
    }

    private static void updateStatistic(OIndex index) {
        OProfiler profiler = Orient.instance().getProfiler();
        if (profiler.isRecording()) {
            Orient.instance().getProfiler().updateCounter(profiler.getDatabaseMetric(index.getDatabaseName(), "query.indexUsed"), "Used index in query", 1L);
            int paramCount = index.getDefinition().getParamCount();
            if (paramCount > 1) {
                String profiler_prefix = profiler.getDatabaseMetric(index.getDatabaseName(), "query.compositeIndexUsed");
                profiler.updateCounter(profiler_prefix, "Used composite index in query", 1L);
                profiler.updateCounter(profiler_prefix + "." + paramCount, "Used composite index in query with " + paramCount + " params", 1L);
            }
        }
    }

    @Override
    public OIndex create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OType[] getKeyTypes() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    public Iterator<Map.Entry<Object, T>> iterator() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OIndex put(Object key, OIdentifiable value) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public boolean remove(Object key) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public boolean remove(Object key, OIdentifiable rid) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    @Deprecated
    public OIndex clear() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public long getSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long count(Object iKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getKeySize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() {
    }

    @Override
    public long getRebuildVersion() {
        return 0L;
    }

    @Override
    public boolean isRebuilding() {
        return false;
    }

    @Override
    public Object getFirstKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getLastKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OIndexCursor cursor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OIndexCursor descCursor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OIndexKeyCursor keyCursor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getCollatingValue(Object key) {
        return this.lastIndex.getInternal().getCollatingValue(key);
    }

    @Override
    public boolean loadFromConfiguration(ODocument iConfig) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ODocument updateConfiguration() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OIndex addCluster(String iClusterName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OIndex removeCluster(String iClusterName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canBeUsedInEqualityOperators() {
        return this.lastIndex.getInternal().canBeUsedInEqualityOperators();
    }

    @Override
    public boolean hasRangeQuerySupport() {
        return this.lastIndex.getInternal().hasRangeQuerySupport();
    }

    @Override
    public OIndexMetadata loadMetadata(ODocument iConfig) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void preCommit(OIndexAbstract.IndexTxSnapshot snapshots) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addTxOperation(OIndexAbstract.IndexTxSnapshot snapshots, OTransactionIndexChanges changes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void commit(OIndexAbstract.IndexTxSnapshot snapshots) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void postCommit(OIndexAbstract.IndexTxSnapshot snapshots) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setType(OType type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getIndexNameByKey(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean acquireAtomicExclusiveLock(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long size() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OIndex delete() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public String getType() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public String getAlgorithm() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public boolean isAutomatic() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public long rebuild() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public long rebuild(OProgressListener iProgressListener) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public ODocument getConfiguration() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public ODocument getMetadata() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public Set<String> getClusters() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OIndexCursor iterateEntries(Collection<?> keys, boolean ascSortOrder) {
        return null;
    }

    @Override
    public OIndexCursor iterateEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        return null;
    }

    @Override
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        return null;
    }

    @Override
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        return null;
    }

    @Override
    public int getIndexId() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public boolean isUnique() {
        return this.firstIndex.isUnique();
    }

    @Override
    public Stream<ORawPair<Object, ORID>> stream() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public Stream<ORawPair<Object, ORID>> descStream() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public Stream<Object> keyStream() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public int getVersion() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public boolean supportsOrderedIterations() {
        return false;
    }

    @Override
    public Stream<ORawPair<Object, ORID>> streamEntries(Collection<?> keys, boolean ascSortOrder) {
        return this.applyTailIndexes(this.lastIndex.getInternal().streamEntries(keys, ascSortOrder));
    }

    @Override
    public Stream<ORawPair<Object, ORID>> streamEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        return this.applyTailIndexes(this.lastIndex.getInternal().streamEntriesBetween(fromKey, fromInclusive, toKey, toInclusive, ascOrder));
    }

    @Override
    public Stream<ORawPair<Object, ORID>> streamEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        return this.applyTailIndexes(this.lastIndex.getInternal().streamEntriesMajor(fromKey, fromInclusive, ascOrder));
    }

    @Override
    public Stream<ORawPair<Object, ORID>> streamEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        return this.applyTailIndexes(this.lastIndex.getInternal().streamEntriesMinor(toKey, toInclusive, ascOrder));
    }

    @Override
    public boolean isNativeTxSupported() {
        return false;
    }

    @Override
    public Iterable<OTransactionIndexChangesPerKey.OTransactionIndexEntry> interpretTxKeyChanges(OTransactionIndexChangesPerKey changes) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public void doPut(OAbstractPaginatedStorage storage, Object key, ORID rid) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public boolean doRemove(OAbstractPaginatedStorage storage, Object key, ORID rid) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public boolean doRemove(OAbstractPaginatedStorage storage, Object key) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    private Stream<ORawPair<Object, ORID>> applyTailIndexes(Stream<ORawPair<Object, ORID>> indexStream) {
        return indexStream.flatMap(entry -> this.applyTailIndexes(entry.second).stream().map(rid -> new ORawPair<Object, ORID>(null, (ORID)rid)));
    }

    @Override
    public int compareTo(OIndex o) {
        throw new UnsupportedOperationException();
    }
}

