/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.metadata.sequence.OSequence;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.util.Arrays;
import java.util.Map;

public class OCommandExecutorSQLCreateSequence
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_CREATE = "CREATE";
    public static final String KEYWORD_SEQUENCE = "SEQUENCE";
    public static final String KEYWORD_TYPE = "TYPE";
    public static final String KEYWORD_START = "START";
    public static final String KEYWORD_INCREMENT = "INCREMENT";
    public static final String KEYWORD_CACHE = "CACHE";
    private String sequenceName;
    private OSequence.SEQUENCE_TYPE sequenceType;
    private OSequence.CreateParams params;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLCreateSequence parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            String temp;
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            this.init((OCommandRequestText)iRequest);
            this.parserRequiredKeyword(KEYWORD_CREATE);
            this.parserRequiredKeyword(KEYWORD_SEQUENCE);
            this.sequenceName = this.parserRequiredWord(false, "Expected <sequence name>");
            this.params = new OSequence.CreateParams().setDefaults();
            while ((temp = this.parseOptionalWord(true, new String[0])) != null && !this.parserIsEnded()) {
                if (temp.equals(KEYWORD_TYPE)) {
                    String typeAsString = this.parserRequiredWord(true, "Expected <sequence type>");
                    try {
                        this.sequenceType = OSequenceHelper.getSequenceTyeFromString(typeAsString);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw OException.wrapException(new OCommandSQLParsingException("Unknown sequence type '" + typeAsString + "'. Supported attributes are: " + Arrays.toString((Object[])OSequence.SEQUENCE_TYPE.values())), e);
                    }
                }
                if (temp.equals(KEYWORD_START)) {
                    String startAsString = this.parserRequiredWord(true, "Expected <start value>");
                    this.params.setStart(Long.parseLong(startAsString));
                    continue;
                }
                if (temp.equals(KEYWORD_INCREMENT)) {
                    String incrementAsString = this.parserRequiredWord(true, "Expected <increment value>");
                    this.params.setIncrement(Integer.parseInt(incrementAsString));
                    continue;
                }
                if (!temp.equals(KEYWORD_CACHE)) continue;
                String cacheAsString = this.parserRequiredWord(true, "Expected <cache value>");
                this.params.setCacheSize(Integer.parseInt(cacheAsString));
            }
            if (this.sequenceType == null) {
                this.sequenceType = OSequenceHelper.DEFAULT_SEQUENCE_TYPE;
            }
        }
        finally {
            textRequest.setText(originalQuery);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.sequenceName == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseDocumentInternal database = OCommandExecutorSQLCreateSequence.getDatabase();
        try {
            database.getMetadata().getSequenceLibrary().createSequence(this.sequenceName, this.sequenceType, this.params);
        }
        catch (ODatabaseException exc) {
            String message = "Unable to execute command: " + exc.getMessage();
            OLogManager.instance().error(this, message, exc, new Object[]{null});
            throw new OCommandExecutionException(message);
        }
        return database.getMetadata().getSequenceLibrary().getSequenceCount();
    }

    @Override
    public String getSyntax() {
        return "CREATE SEQUENCE <sequence> [TYPE <CACHED|ORDERED>] [START <value>] [INCREMENT <value>] [CACHE <value>]";
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }
}

