/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.OChainedIndexProxy;
import com.orientechnologies.orient.core.sql.OIndexSearchResult;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorBetween;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorContains;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorIn;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMajor;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMajorEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMinor;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMinorEquals;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class OFilterAnalyzer {
    public List<OIndex> getInvolvedIndexes(OClass iSchemaClass, OIndexSearchResult searchResultFields) {
        Set<OIndex> involvedIndexes = iSchemaClass.getInvolvedIndexes(searchResultFields.fields());
        ArrayList<OIndex> result = new ArrayList<OIndex>(involvedIndexes.size());
        if (searchResultFields.lastField.isLong()) {
            result.addAll(OChainedIndexProxy.createProxies(iSchemaClass, searchResultFields.lastField));
        } else {
            for (OIndex involvedIndex : involvedIndexes) {
                result.add(involvedIndex);
            }
        }
        return result;
    }

    public List<List<OIndexSearchResult>> analyzeMainCondition(OSQLFilterCondition condition, OClass schemaClass, OCommandContext context) {
        return this.analyzeOrFilterBranch(schemaClass, condition, context);
    }

    private List<List<OIndexSearchResult>> analyzeOrFilterBranch(OClass iSchemaClass, OSQLFilterCondition condition, OCommandContext iContext) {
        if (condition == null) {
            return null;
        }
        OQueryOperator operator = condition.getOperator();
        while (operator == null) {
            if (condition.getRight() == null && condition.getLeft() instanceof OSQLFilterCondition) {
                condition = (OSQLFilterCondition)condition.getLeft();
                operator = condition.getOperator();
                continue;
            }
            return null;
        }
        OIndexReuseType indexReuseType = operator.getIndexReuseType(condition.getLeft(), condition.getRight());
        if (OIndexReuseType.INDEX_UNION.equals((Object)indexReuseType)) {
            return this.analyzeUnion(iSchemaClass, condition, iContext);
        }
        ArrayList<List<OIndexSearchResult>> result = new ArrayList<List<OIndexSearchResult>>();
        List<OIndexSearchResult> sub = this.analyzeCondition(condition, iSchemaClass, iContext);
        result.add(sub);
        return result;
    }

    public List<OIndexSearchResult> analyzeCondition(OSQLFilterCondition condition, OClass schemaClass, OCommandContext context) {
        ArrayList<OIndexSearchResult> indexSearchResults = new ArrayList<OIndexSearchResult>();
        OIndexSearchResult lastCondition = this.analyzeFilterBranch(schemaClass, condition, indexSearchResults, context);
        if (indexSearchResults.isEmpty() && lastCondition != null) {
            indexSearchResults.add(lastCondition);
        }
        Collections.sort(indexSearchResults, new Comparator<OIndexSearchResult>(){

            @Override
            public int compare(OIndexSearchResult searchResultOne, OIndexSearchResult searchResultTwo) {
                return searchResultTwo.getFieldCount() - searchResultOne.getFieldCount();
            }
        });
        return indexSearchResults;
    }

    private OIndexSearchResult analyzeFilterBranch(OClass iSchemaClass, OSQLFilterCondition condition, List<OIndexSearchResult> iIndexSearchResults, OCommandContext iContext) {
        if (condition == null) {
            return null;
        }
        OQueryOperator operator = condition.getOperator();
        while (operator == null) {
            if (condition.getRight() == null && condition.getLeft() instanceof OSQLFilterCondition) {
                condition = (OSQLFilterCondition)condition.getLeft();
                operator = condition.getOperator();
                continue;
            }
            return null;
        }
        OIndexReuseType indexReuseType = operator.getIndexReuseType(condition.getLeft(), condition.getRight());
        switch (indexReuseType) {
            case INDEX_INTERSECTION: {
                return this.analyzeIntersection(iSchemaClass, condition, iIndexSearchResults, iContext);
            }
            case INDEX_METHOD: {
                return this.analyzeIndexMethod(iSchemaClass, condition, iIndexSearchResults, iContext);
            }
            case INDEX_OPERATOR: {
                return this.analyzeOperator(iSchemaClass, condition, iIndexSearchResults, iContext);
            }
        }
        return null;
    }

    private OIndexSearchResult analyzeOperator(OClass iSchemaClass, OSQLFilterCondition condition, List<OIndexSearchResult> iIndexSearchResults, OCommandContext iContext) {
        return condition.getOperator().getOIndexSearchResult(iSchemaClass, condition, iIndexSearchResults, iContext);
    }

    private OIndexSearchResult analyzeIndexMethod(OClass iSchemaClass, OSQLFilterCondition condition, List<OIndexSearchResult> iIndexSearchResults, OCommandContext ctx) {
        OIndexSearchResult result = this.createIndexedProperty(condition, condition.getLeft(), ctx);
        if (result == null) {
            result = this.createIndexedProperty(condition, condition.getRight(), ctx);
        }
        if (result == null) {
            return null;
        }
        if (this.checkIndexExistence(iSchemaClass, result)) {
            iIndexSearchResults.add(result);
        }
        return result;
    }

    private OIndexSearchResult analyzeIntersection(OClass iSchemaClass, OSQLFilterCondition condition, List<OIndexSearchResult> iIndexSearchResults, OCommandContext iContext) {
        OIndexSearchResult leftResult = this.analyzeFilterBranch(iSchemaClass, (OSQLFilterCondition)condition.getLeft(), iIndexSearchResults, iContext);
        OIndexSearchResult rightResult = this.analyzeFilterBranch(iSchemaClass, (OSQLFilterCondition)condition.getRight(), iIndexSearchResults, iContext);
        if (leftResult != null && rightResult != null && leftResult.canBeMerged(rightResult)) {
            OIndexSearchResult mergeResult = leftResult.merge(rightResult);
            if (iSchemaClass.areIndexed(mergeResult.fields())) {
                iIndexSearchResults.add(mergeResult);
            }
            return leftResult.merge(rightResult);
        }
        return null;
    }

    private List<List<OIndexSearchResult>> analyzeUnion(OClass iSchemaClass, OSQLFilterCondition condition, OCommandContext iContext) {
        ArrayList<List<OIndexSearchResult>> result = new ArrayList<List<OIndexSearchResult>>();
        result.addAll(this.analyzeOrFilterBranch(iSchemaClass, (OSQLFilterCondition)condition.getLeft(), iContext));
        result.addAll(this.analyzeOrFilterBranch(iSchemaClass, (OSQLFilterCondition)condition.getRight(), iContext));
        return result;
    }

    private OIndexSearchResult createIndexedProperty(OSQLFilterCondition iCondition, Object iItem, OCommandContext ctx) {
        if (iItem == null || !(iItem instanceof OSQLFilterItemField)) {
            return null;
        }
        if (iCondition.getLeft() instanceof OSQLFilterItemField && iCondition.getRight() instanceof OSQLFilterItemField) {
            return null;
        }
        OSQLFilterItemField item = (OSQLFilterItemField)iItem;
        if (item.hasChainOperators() && !item.isFieldChain()) {
            return null;
        }
        boolean inverted = iCondition.getRight() == iItem;
        Object origValue = inverted ? iCondition.getLeft() : iCondition.getRight();
        OQueryOperator operator = iCondition.getOperator();
        if (inverted) {
            if (operator instanceof OQueryOperatorIn) {
                operator = new OQueryOperatorContains();
            } else if (operator instanceof OQueryOperatorContains) {
                operator = new OQueryOperatorIn();
            } else if (operator instanceof OQueryOperatorMajor) {
                operator = new OQueryOperatorMinor();
            } else if (operator instanceof OQueryOperatorMinor) {
                operator = new OQueryOperatorMajor();
            } else if (operator instanceof OQueryOperatorMajorEquals) {
                operator = new OQueryOperatorMinorEquals();
            } else if (operator instanceof OQueryOperatorMinorEquals) {
                operator = new OQueryOperatorMajorEquals();
            }
        }
        if (iCondition.getOperator() instanceof OQueryOperatorBetween || operator instanceof OQueryOperatorIn) {
            return new OIndexSearchResult(operator, item.getFieldChain(), origValue);
        }
        Object value = OSQLHelper.getValue(origValue, null, ctx);
        return new OIndexSearchResult(operator, item.getFieldChain(), value);
    }

    private boolean checkIndexExistence(OClass iSchemaClass, OIndexSearchResult result) {
        return iSchemaClass.areIndexed(result.fields()) && (!result.lastField.isLong() || this.checkIndexChainExistence(iSchemaClass, result));
    }

    private boolean checkIndexChainExistence(OClass iSchemaClass, OIndexSearchResult result) {
        int fieldCount = result.lastField.getItemCount();
        OClass cls = iSchemaClass.getProperty(result.lastField.getItemName(0)).getLinkedClass();
        for (int i = 1; i < fieldCount; ++i) {
            if (cls == null || !cls.areIndexed(result.lastField.getItemName(i))) {
                return false;
            }
            cls = cls.getProperty(result.lastField.getItemName(i)).getLinkedClass();
        }
        return true;
    }
}

