/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.AggregationContext;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.ProjectionCalculationStep;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OGroupBy;
import com.orientechnologies.orient.core.sql.parser.OProjection;
import com.orientechnologies.orient.core.sql.parser.OProjectionItem;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AggregateProjectionCalculationStep
extends ProjectionCalculationStep {
    private final OGroupBy groupBy;
    private final long timeoutMillis;
    private Map<List, OResultInternal> aggregateResults = new LinkedHashMap<List, OResultInternal>();
    private List<OResultInternal> finalResults = null;
    private int nextItem = 0;
    private long cost = 0L;

    public AggregateProjectionCalculationStep(OProjection projection, OGroupBy groupBy, OCommandContext ctx, long timeoutMillis, boolean profilingEnabled) {
        super(projection, ctx, profilingEnabled);
        this.groupBy = groupBy;
        this.timeoutMillis = timeoutMillis;
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, final int nRecords) throws OTimeoutException {
        if (this.finalResults == null) {
            this.executeAggregation(ctx, nRecords);
        }
        return new OResultSet(){
            private int localNext = 0;

            @Override
            public boolean hasNext() {
                return this.localNext <= nRecords && AggregateProjectionCalculationStep.this.nextItem < AggregateProjectionCalculationStep.this.finalResults.size();
            }

            @Override
            public OResult next() {
                if (this.localNext > nRecords || AggregateProjectionCalculationStep.this.nextItem >= AggregateProjectionCalculationStep.this.finalResults.size()) {
                    throw new IllegalStateException();
                }
                OResult result = (OResult)AggregateProjectionCalculationStep.this.finalResults.get(AggregateProjectionCalculationStep.this.nextItem);
                AggregateProjectionCalculationStep.this.nextItem++;
                ++this.localNext;
                return result;
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    private void executeAggregation(OCommandContext ctx, int nRecords) {
        long timeoutBegin = System.currentTimeMillis();
        if (!this.prev.isPresent()) {
            throw new OCommandExecutionException("Cannot execute an aggregation or a GROUP BY without a previous result");
        }
        OExecutionStepInternal prevStep = (OExecutionStepInternal)this.prev.get();
        OResultSet lastRs = prevStep.syncPull(ctx, nRecords);
        while (lastRs.hasNext()) {
            if (this.timeoutMillis > 0L && timeoutBegin + this.timeoutMillis < System.currentTimeMillis()) {
                this.sendTimeout();
            }
            this.aggregate(lastRs.next(), ctx);
            if (lastRs.hasNext()) continue;
            lastRs = prevStep.syncPull(ctx, nRecords);
        }
        this.finalResults = new ArrayList<OResultInternal>();
        this.finalResults.addAll(this.aggregateResults.values());
        this.aggregateResults.clear();
        for (OResultInternal item : this.finalResults) {
            if (this.timeoutMillis > 0L && timeoutBegin + this.timeoutMillis < System.currentTimeMillis()) {
                this.sendTimeout();
            }
            for (String name : item.getTemporaryProperties()) {
                Object prevVal = item.getTemporaryProperty(name);
                if (!(prevVal instanceof AggregationContext)) continue;
                item.setTemporaryProperty(name, ((AggregationContext)prevVal).getFinalValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aggregate(OResult next, OCommandContext ctx) {
        long begin = this.profilingEnabled ? System.nanoTime() : 0L;
        try {
            OResultInternal preAggr;
            ArrayList<Object> key = new ArrayList<Object>();
            if (this.groupBy != null) {
                for (OExpression item : this.groupBy.getItems()) {
                    Object val = item.execute(next, ctx);
                    key.add(val);
                }
            }
            if ((preAggr = this.aggregateResults.get(key)) == null) {
                preAggr = new OResultInternal();
                this.aggregateResults.put(key, preAggr);
            }
            for (OProjectionItem proj : this.projection.getItems()) {
                String alias = proj.getProjectionAlias().getStringValue();
                if (proj.isAggregate()) {
                    AggregationContext aggrCtx = (AggregationContext)preAggr.getTemporaryProperty(alias);
                    if (aggrCtx == null) {
                        aggrCtx = proj.getAggregationContext(ctx);
                        preAggr.setTemporaryProperty(alias, aggrCtx);
                    }
                    aggrCtx.apply(next, ctx);
                    continue;
                }
                preAggr.setProperty(alias, proj.execute(next, ctx));
            }
        }
        finally {
            if (this.profilingEnabled) {
                this.cost += System.nanoTime() - begin;
            }
        }
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        String result = spaces + "+ CALCULATE AGGREGATE PROJECTIONS";
        if (this.profilingEnabled) {
            result = result + " (" + this.getCostFormatted() + ")";
        }
        result = result + "\n" + spaces + "      " + this.projection.toString() + "" + (this.groupBy == null ? "" : spaces + "\n  " + this.groupBy.toString());
        return result;
    }

    @Override
    public OExecutionStep copy(OCommandContext ctx) {
        return new AggregateProjectionCalculationStep(this.projection.copy(), this.groupBy == null ? null : this.groupBy.copy(), ctx, this.timeoutMillis, this.profilingEnabled);
    }

    @Override
    public long getCost() {
        return this.cost;
    }
}

