/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CartesianProductStep
extends AbstractExecutionStep {
    private List<OInternalExecutionPlan> subPlans = new ArrayList<OInternalExecutionPlan>();
    private boolean inited = false;
    private List<Boolean> completedPrefetch = new ArrayList<Boolean>();
    private List<OInternalResultSet> preFetches = new ArrayList<OInternalResultSet>();
    private List<OResultSet> resultSets = new ArrayList<OResultSet>();
    private List<OResult> currentTuple = new ArrayList<OResult>();
    private OResultInternal nextRecord;
    private long cost = 0L;

    public CartesianProductStep(OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, final int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        this.init(ctx);
        return new OResultSet(){
            private int currentCount = 0;

            @Override
            public boolean hasNext() {
                if (this.currentCount >= nRecords) {
                    return false;
                }
                return CartesianProductStep.this.nextRecord != null;
            }

            @Override
            public OResult next() {
                if (this.currentCount >= nRecords || CartesianProductStep.this.nextRecord == null) {
                    throw new IllegalStateException();
                }
                OResultInternal result = CartesianProductStep.this.nextRecord;
                CartesianProductStep.this.fetchNextRecord();
                ++this.currentCount;
                return result;
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    private void init(OCommandContext ctx) {
        if (this.subPlans == null || this.subPlans.isEmpty()) {
            return;
        }
        if (this.inited) {
            return;
        }
        for (OInternalExecutionPlan plan : this.subPlans) {
            this.resultSets.add(new OLocalResultSet(plan));
            this.preFetches.add(new OInternalResultSet());
        }
        this.fetchFirstRecord();
        this.inited = true;
    }

    private void fetchFirstRecord() {
        boolean i = false;
        for (OResultSet rs : this.resultSets) {
            if (!rs.hasNext()) {
                this.nextRecord = null;
                return;
            }
            OResult item = rs.next();
            this.currentTuple.add(item);
            this.completedPrefetch.add(false);
        }
        this.buildNextRecord();
    }

    private void fetchNextRecord() {
        this.fetchNextRecord(this.resultSets.size() - 1);
    }

    private void fetchNextRecord(int level) {
        OResultSet currentRs = this.resultSets.get(level);
        if (!currentRs.hasNext()) {
            if (level <= 0) {
                this.nextRecord = null;
                this.currentTuple = null;
                return;
            }
            currentRs = this.preFetches.get(level);
            currentRs.reset();
            this.resultSets.set(level, currentRs);
            this.currentTuple.set(level, currentRs.next());
            this.fetchNextRecord(level - 1);
        } else {
            this.currentTuple.set(level, currentRs.next());
        }
        this.buildNextRecord();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildNextRecord() {
        long begin = this.profilingEnabled ? System.nanoTime() : 0L;
        try {
            if (this.currentTuple == null) {
                this.nextRecord = null;
                return;
            }
            this.nextRecord = new OResultInternal();
            for (int i = 0; i < this.currentTuple.size(); ++i) {
                OResult res = this.currentTuple.get(i);
                for (String s : res.getPropertyNames()) {
                    this.nextRecord.setProperty(s, res.getProperty(s));
                }
                if (this.completedPrefetch.get(i).booleanValue()) continue;
                this.preFetches.get(i).add(res);
                if (this.resultSets.get(i).hasNext()) continue;
                this.completedPrefetch.set(i, true);
            }
        }
        finally {
            if (this.profilingEnabled) {
                this.cost += System.nanoTime() - begin;
            }
        }
    }

    public void addSubPlan(OInternalExecutionPlan subPlan) {
        this.subPlans.add(subPlan);
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String result = "";
        String ind = OExecutionStepInternal.getIndent(depth, indent);
        int[] blockSizes = new int[this.subPlans.size()];
        for (int i = 0; i < this.subPlans.size(); ++i) {
            OInternalExecutionPlan currentPlan = this.subPlans.get(this.subPlans.size() - 1 - i);
            String partial = currentPlan.prettyPrint(0, indent);
            String[] partials = partial.split("\n");
            blockSizes[this.subPlans.size() - 1 - i] = partials.length + 2;
            result = "+-------------------------\n" + result;
            for (int j = 0; j < partials.length; ++j) {
                String p = partials[partials.length - 1 - j];
                result = result.length() > 0 ? this.appendPipe(p) + "\n" + result : this.appendPipe(p);
            }
            result = "+-------------------------\n" + result;
        }
        result = this.addArrows(result, blockSizes);
        result = result + this.foot(blockSizes);
        result = ind + result;
        result = result.replaceAll("\n", "\n" + ind);
        result = this.head(depth, indent, this.subPlans.size()) + "\n" + result;
        return result;
    }

    private String addArrows(String input, int[] blockSizes) {
        StringBuilder result = new StringBuilder();
        String[] rows = input.split("\n");
        int rowNum = 0;
        for (int block = 0; block < blockSizes.length; ++block) {
            int blockSize = blockSizes[block];
            for (int subRow = 0; subRow < blockSize; ++subRow) {
                for (int col = 0; col < blockSizes.length * 3; ++col) {
                    if (this.isHorizontalRow(col, subRow, block, blockSize)) {
                        result.append("-");
                        continue;
                    }
                    if (this.isPlus(col, subRow, block, blockSize)) {
                        result.append("+");
                        continue;
                    }
                    if (this.isVerticalRow(col, subRow, block, blockSize)) {
                        result.append("|");
                        continue;
                    }
                    result.append(" ");
                }
                result.append(rows[rowNum]);
                result.append("\n");
                ++rowNum;
            }
        }
        return result.toString();
    }

    private boolean isHorizontalRow(int col, int subRow, int block, int blockSize) {
        if (col < block * 3 + 2) {
            return false;
        }
        return subRow == blockSize / 2;
    }

    private boolean isPlus(int col, int subRow, int block, int blockSize) {
        return col == block * 3 + 1 && subRow == blockSize / 2;
    }

    private boolean isVerticalRow(int col, int subRow, int block, int blockSize) {
        return col == block * 3 + 1 ? subRow > blockSize / 2 : col < block * 3 + 1 && col % 3 == 1;
    }

    private String head(int depth, int indent, int nItems) {
        String ind = OExecutionStepInternal.getIndent(depth, indent);
        String result = ind + "+ CARTESIAN PRODUCT";
        if (this.profilingEnabled) {
            result = result + " (" + this.getCostFormatted() + ")";
        }
        return result;
    }

    private String foot(int[] blockSizes) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < blockSizes.length; ++i) {
            result.append(" V ");
        }
        return result.toString();
    }

    private String appendPipe(String p) {
        return "| " + p;
    }

    @Override
    public long getCost() {
        return this.cost;
    }
}

