/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OCluster;

public class CheckClusterTypeStep
extends AbstractExecutionStep {
    private OCluster cluster;
    private String clusterName;
    private String targetClass;
    private long cost = 0L;
    private boolean found = false;

    public CheckClusterTypeStep(String targetClusterName, String clazz, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.clusterName = targetClusterName;
        this.targetClass = clazz;
    }

    public CheckClusterTypeStep(OCluster targetCluster, String clazz, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.cluster = targetCluster;
        this.targetClass = clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        long begin = this.profilingEnabled ? System.nanoTime() : 0L;
        try {
            int clusterId;
            if (this.found) {
                OInternalResultSet oInternalResultSet = new OInternalResultSet();
                return oInternalResultSet;
            }
            ODatabase db = ctx.getDatabase();
            if (this.clusterName != null) {
                clusterId = db.getClusterIdByName(this.clusterName);
            } else if (this.cluster.getClusterName() != null) {
                clusterId = db.getClusterIdByName(this.cluster.getClusterName());
            } else {
                clusterId = this.cluster.getClusterNumber();
                if (db.getClusterNameById(clusterId) == null) {
                    throw new OCommandExecutionException("Cluster not found: " + clusterId);
                }
            }
            if (clusterId < 0) {
                throw new OCommandExecutionException("Cluster not found: " + this.clusterName);
            }
            OClass clazz = db.getMetadata().getSchema().getClass(this.targetClass);
            if (clazz == null) {
                throw new OCommandExecutionException("Class not found: " + this.targetClass);
            }
            for (int clust : clazz.getPolymorphicClusterIds()) {
                if (clust != clusterId) continue;
                this.found = true;
                break;
            }
            if (!this.found) {
                throw new OCommandExecutionException("Cluster " + clusterId + " does not belong to class " + this.targetClass);
            }
            OInternalResultSet oInternalResultSet = new OInternalResultSet();
            return oInternalResultSet;
        }
        finally {
            if (this.profilingEnabled) {
                this.cost += System.nanoTime() - begin;
            }
        }
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ CHECK TARGET CLUSTER FOR CLASS");
        if (this.profilingEnabled) {
            result.append(" (" + this.getCostFormatted() + ")");
        }
        result.append("\n");
        result.append(spaces);
        result.append("  " + this.targetClass);
        return result.toString();
    }

    @Override
    public long getCost() {
        return this.cost;
    }
}

