/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;

public class CountStep
extends AbstractExecutionStep {
    private long cost = 0L;
    private boolean executed = false;

    public CountStep(OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        if (this.executed) {
            return new OInternalResultSet();
        }
        OResultInternal resultRecord = new OResultInternal();
        this.executed = true;
        long count = 0L;
        block3: while (true) {
            OResultSet prevResult;
            if (!(prevResult = this.getPrev().get().syncPull(ctx, nRecords)).hasNext()) {
                long begin = this.profilingEnabled ? System.nanoTime() : 0L;
                try {
                    OInternalResultSet result = new OInternalResultSet();
                    resultRecord.setProperty("count", count);
                    result.add(resultRecord);
                    OInternalResultSet oInternalResultSet = result;
                    return oInternalResultSet;
                }
                finally {
                    if (this.profilingEnabled) {
                        this.cost += System.nanoTime() - begin;
                    }
                }
            }
            while (true) {
                if (!prevResult.hasNext()) continue block3;
                ++count;
                prevResult.next();
            }
            break;
        }
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ COUNT");
        if (this.profilingEnabled) {
            result.append(" (" + this.getCostFormatted() + ")");
        }
        return result.toString();
    }

    @Override
    public long getCost() {
        return this.cost;
    }

    @Override
    public boolean canBeCached() {
        return true;
    }

    @Override
    public OExecutionStep copy(OCommandContext ctx) {
        return new CountStep(ctx, this.profilingEnabled);
    }
}

