/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OUpdatableResult;
import com.orientechnologies.orient.core.sql.parser.OBatch;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class CreateEdgesStep
extends AbstractExecutionStep {
    private final OIdentifier targetClass;
    private final OIdentifier targetCluster;
    private final String uniqueIndexName;
    private final OIdentifier fromAlias;
    private final OIdentifier toAlias;
    private final Number wait;
    private final Number retry;
    private final OBatch batch;
    private Iterator fromIter;
    private Iterator toIterator;
    private OVertex currentFrom;
    private OVertex currentTo;
    private OEdge edgeToUpdate;
    private boolean finished = false;
    private List toList = new ArrayList();
    private OIndex uniqueIndex;
    private boolean inited = false;
    private long cost = 0L;

    public CreateEdgesStep(OIdentifier targetClass, OIdentifier targetClusterName, String uniqueIndex, OIdentifier fromAlias, OIdentifier toAlias, Number wait, Number retry, OBatch batch, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.targetClass = targetClass;
        this.targetCluster = targetClusterName;
        this.uniqueIndexName = uniqueIndex;
        this.fromAlias = fromAlias;
        this.toAlias = toAlias;
        this.wait = wait;
        this.retry = retry;
        this.batch = batch;
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, final int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        this.init();
        return new OResultSet(){
            private int currentBatch = 0;

            @Override
            public boolean hasNext() {
                if (CreateEdgesStep.this.currentTo == null) {
                    CreateEdgesStep.this.loadNextFromTo();
                }
                return this.currentBatch < nRecords && CreateEdgesStep.this.currentTo != null && !CreateEdgesStep.this.finished;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OResult next() {
                if (CreateEdgesStep.this.currentTo == null) {
                    CreateEdgesStep.this.loadNextFromTo();
                }
                long begin = CreateEdgesStep.this.profilingEnabled ? System.nanoTime() : 0L;
                try {
                    if (CreateEdgesStep.this.finished || this.currentBatch >= nRecords) {
                        throw new IllegalStateException();
                    }
                    if (CreateEdgesStep.this.currentTo == null) {
                        throw new OCommandExecutionException("Invalid TO vertex for edge");
                    }
                    OEdge edge = CreateEdgesStep.this.edgeToUpdate != null ? CreateEdgesStep.this.edgeToUpdate : CreateEdgesStep.this.currentFrom.addEdge(CreateEdgesStep.this.currentTo, CreateEdgesStep.this.targetClass.getStringValue());
                    OUpdatableResult result = new OUpdatableResult(edge);
                    result.setElement(edge);
                    CreateEdgesStep.this.currentTo = null;
                    ++this.currentBatch;
                    OUpdatableResult oUpdatableResult = result;
                    return oUpdatableResult;
                }
                finally {
                    if (CreateEdgesStep.this.profilingEnabled) {
                        CreateEdgesStep.this.cost = CreateEdgesStep.this.cost + (System.nanoTime() - begin);
                    }
                }
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Iterator toIter;
        OInternalResultSet toValues;
        CreateEdgesStep createEdgesStep = this;
        synchronized (createEdgesStep) {
            if (this.inited) {
                return;
            }
            this.inited = true;
        }
        OInternalResultSet fromValues = this.ctx.getVariable(this.fromAlias.getStringValue());
        if (fromValues instanceof Iterable && !(fromValues instanceof OIdentifiable)) {
            fromValues = ((Iterable)((Object)fromValues)).iterator();
        } else if (!(fromValues instanceof Iterator)) {
            fromValues = Collections.singleton(fromValues).iterator();
        }
        if (fromValues instanceof OInternalResultSet) {
            fromValues = ((OInternalResultSet)fromValues).copy();
        }
        if ((toValues = this.ctx.getVariable(this.toAlias.getStringValue())) instanceof Iterable && !(toValues instanceof OIdentifiable)) {
            toValues = ((Iterable)((Object)toValues)).iterator();
        } else if (!(toValues instanceof Iterator)) {
            toValues = Collections.singleton(toValues).iterator();
        }
        if (toValues instanceof OInternalResultSet) {
            toValues = ((OInternalResultSet)toValues).copy();
        }
        this.fromIter = fromValues;
        if (this.fromIter instanceof OResultSet) {
            try {
                ((OResultSet)this.fromIter).reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((toIter = (Iterator)toValues) instanceof OResultSet) {
            try {
                ((OResultSet)toIter).reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        while (toIter != null && toIter.hasNext()) {
            this.toList.add(toIter.next());
        }
        this.toIterator = this.toList.iterator();
        OVertex oVertex = this.currentFrom = this.fromIter != null && this.fromIter.hasNext() ? this.asVertex(this.fromIter.next()) : null;
        if (this.uniqueIndexName != null) {
            ODatabaseDocumentInternal database = (ODatabaseDocumentInternal)this.ctx.getDatabase();
            this.uniqueIndex = database.getMetadata().getIndexManagerInternal().getIndex(database, this.uniqueIndexName);
            if (this.uniqueIndex == null) {
                throw new OCommandExecutionException("Index not found for upsert: " + this.uniqueIndexName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadNextFromTo() {
        long begin = this.profilingEnabled ? System.nanoTime() : 0L;
        try {
            this.edgeToUpdate = null;
            this.currentTo = null;
            if (!this.toIterator.hasNext()) {
                this.toIterator = this.toList.iterator();
                if (!this.fromIter.hasNext()) {
                    this.finished = true;
                    return;
                }
                OVertex oVertex = this.currentFrom = this.fromIter.hasNext() ? this.asVertex(this.fromIter.next()) : null;
            }
            if (this.toIterator.hasNext() || this.toList.size() > 0 && this.fromIter.hasNext()) {
                OEdge existingEdge;
                if (this.currentFrom == null && !this.fromIter.hasNext()) {
                    this.finished = true;
                    return;
                }
                Object obj = this.toIterator.next();
                this.currentTo = this.asVertex(obj);
                if (this.currentTo == null) {
                    throw new OCommandExecutionException("Invalid TO vertex for edge");
                }
                if (this.isUpsert() && (existingEdge = this.getExistingEdge(this.currentFrom, this.currentTo)) != null) {
                    this.edgeToUpdate = existingEdge;
                }
                return;
            }
            this.currentTo = null;
            return;
        }
        finally {
            if (this.profilingEnabled) {
                this.cost += System.nanoTime() - begin;
            }
        }
    }

    private OEdge getExistingEdge(OVertex currentFrom, OVertex currentTo) {
        Object key = this.uniqueIndex.getDefinition().createValue(currentFrom.getIdentity(), currentTo.getIdentity());
        try (Stream<ORID> stream = this.uniqueIndex.getInternal().getRids(key);){
            Iterator iterator = stream.iterator();
            if (iterator.hasNext()) {
                OEdge oEdge = (OEdge)((ORID)iterator.next()).getRecord();
                return oEdge;
            }
        }
        return null;
    }

    private boolean isUpsert() {
        return this.uniqueIndex != null;
    }

    private OVertex asVertex(Object currentFrom) {
        Object from;
        if (currentFrom instanceof ORID) {
            currentFrom = ((ORID)currentFrom).getRecord();
        }
        if (currentFrom instanceof OResult) {
            from = currentFrom;
            currentFrom = ((OResult)currentFrom).getVertex().orElseThrow(() -> new OCommandExecutionException("Invalid vertex for edge creation: " + from.toString()));
        }
        if (currentFrom instanceof OVertex) {
            return (OVertex)currentFrom;
        }
        if (currentFrom instanceof OElement) {
            from = currentFrom;
            return ((OElement)currentFrom).asVertex().orElseThrow(() -> new OCommandExecutionException("Invalid vertex for edge creation: " + from.toString()));
        }
        throw new OCommandExecutionException("Invalid vertex for edge creation: " + (currentFrom == null ? "null" : currentFrom.toString()));
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        String result = spaces + "+ FOR EACH x in " + this.fromAlias + "\n";
        result = result + spaces + "    FOR EACH y in " + this.toAlias + "\n";
        result = result + spaces + "       CREATE EDGE " + this.targetClass + " FROM x TO y";
        if (this.profilingEnabled) {
            result = result + " (" + this.getCostFormatted() + ")";
        }
        if (this.targetCluster != null) {
            result = result + "\n" + spaces + "       (target cluster " + this.targetCluster + ")";
        }
        return result;
    }

    @Override
    public long getCost() {
        return this.cost;
    }

    @Override
    public boolean canBeCached() {
        return true;
    }

    @Override
    public OExecutionStep copy(OCommandContext ctx) {
        return new CreateEdgesStep(this.targetClass == null ? null : this.targetClass.copy(), this.targetCluster == null ? null : this.targetCluster.copy(), this.uniqueIndexName, this.fromAlias == null ? null : this.fromAlias.copy(), this.toAlias == null ? null : this.toAlias.copy(), this.wait, this.retry, this.batch == null ? null : this.batch.copy(), ctx, this.profilingEnabled);
    }
}

