/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.ORidSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class DistinctExecutionStep
extends AbstractExecutionStep {
    private Set<OResult> pastItems = new HashSet<OResult>();
    private ORidSet pastRids = new ORidSet();
    private OResultSet lastResult = null;
    private OResult nextValue;
    private long cost = 0L;

    public DistinctExecutionStep(OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, final int nRecords) throws OTimeoutException {
        OResultSet result = new OResultSet(){
            private int nextLocal = 0;

            @Override
            public boolean hasNext() {
                if (this.nextLocal >= nRecords) {
                    return false;
                }
                if (DistinctExecutionStep.this.nextValue != null) {
                    return true;
                }
                DistinctExecutionStep.this.fetchNext(nRecords);
                return DistinctExecutionStep.this.nextValue != null;
            }

            @Override
            public OResult next() {
                if (this.nextLocal >= nRecords) {
                    throw new IllegalStateException();
                }
                if (DistinctExecutionStep.this.nextValue == null) {
                    DistinctExecutionStep.this.fetchNext(nRecords);
                }
                if (DistinctExecutionStep.this.nextValue == null) {
                    throw new IllegalStateException();
                }
                OResult result = DistinctExecutionStep.this.nextValue;
                DistinctExecutionStep.this.nextValue = null;
                ++this.nextLocal;
                return result;
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchNext(int nRecords) {
        while (this.nextValue == null) {
            if (this.lastResult == null || !this.lastResult.hasNext()) {
                this.lastResult = this.getPrev().get().syncPull(this.ctx, nRecords);
            }
            if (this.lastResult == null || !this.lastResult.hasNext()) {
                return;
            }
            long begin = this.profilingEnabled ? System.nanoTime() : 0L;
            try {
                this.nextValue = this.lastResult.next();
                if (this.alreadyVisited(this.nextValue)) {
                    this.nextValue = null;
                    continue;
                }
                this.markAsVisited(this.nextValue);
                continue;
            }
            finally {
                if (!this.profilingEnabled) continue;
                this.cost += System.nanoTime() - begin;
                continue;
            }
            break;
        }
        return;
    }

    private void markAsVisited(OResult nextValue) {
        if (nextValue.isElement()) {
            ORID identity = nextValue.getElement().get().getIdentity();
            int cluster = identity.getClusterId();
            long pos = identity.getClusterPosition();
            if (cluster >= 0 && pos >= 0L) {
                this.pastRids.add(identity);
                return;
            }
        }
        this.pastItems.add(nextValue);
    }

    private boolean alreadyVisited(OResult nextValue) {
        if (nextValue.isElement()) {
            ORID identity = nextValue.getElement().get().getIdentity();
            int cluster = identity.getClusterId();
            long pos = identity.getClusterPosition();
            if (cluster >= 0 && pos >= 0L) {
                return this.pastRids.contains(identity);
            }
        }
        return this.pastItems.contains(nextValue);
    }

    @Override
    public void sendTimeout() {
    }

    @Override
    public void close() {
        this.prev.ifPresent(x -> x.close());
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String result = OExecutionStepInternal.getIndent(depth, indent) + "+ DISTINCT";
        if (this.profilingEnabled) {
            result = result + " (" + this.getCostFormatted() + ")";
        }
        return result;
    }

    @Override
    public long getCost() {
        return this.cost;
    }
}

