/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

public class FetchEdgesToVerticesStep
extends AbstractExecutionStep {
    private final String toAlias;
    private final OIdentifier targetCluster;
    private final OIdentifier targetClass;
    private boolean inited = false;
    private Iterator toIter;
    private OEdge nextEdge;
    private Iterator<OEdge> currentToEdgesIter;

    public FetchEdgesToVerticesStep(String toAlias, OIdentifier targetClass, OIdentifier targetCluster, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.toAlias = toAlias;
        this.targetClass = targetClass;
        this.targetCluster = targetCluster;
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, final int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        this.init();
        return new OResultSet(){
            private int currentBatch = 0;

            @Override
            public boolean hasNext() {
                return this.currentBatch < nRecords && FetchEdgesToVerticesStep.this.nextEdge != null;
            }

            @Override
            public OResult next() {
                if (!this.hasNext()) {
                    throw new IllegalStateException();
                }
                OEdge edge = FetchEdgesToVerticesStep.this.nextEdge;
                FetchEdgesToVerticesStep.this.fetchNextEdge();
                OResultInternal result = new OResultInternal();
                result.setElement(edge);
                return result;
            }

            @Override
            public void close() {
                if (FetchEdgesToVerticesStep.this.toIter instanceof OResultSet) {
                    ((OResultSet)FetchEdgesToVerticesStep.this.toIter).close();
                }
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        FetchEdgesToVerticesStep fetchEdgesToVerticesStep = this;
        synchronized (fetchEdgesToVerticesStep) {
            if (this.inited) {
                return;
            }
            this.inited = true;
        }
        Iterator<Object> toValues = null;
        toValues = this.ctx.getVariable(this.toAlias);
        if (toValues instanceof Iterable && !(toValues instanceof OIdentifiable)) {
            toValues = ((Iterable)((Object)toValues)).iterator();
        } else if (!(toValues instanceof Iterator)) {
            toValues = Collections.singleton(toValues).iterator();
        }
        this.toIter = toValues;
        this.fetchNextEdge();
    }

    private void fetchNextEdge() {
        OEdge edge;
        this.nextEdge = null;
        while (true) {
            if (this.currentToEdgesIter == null || !this.currentToEdgesIter.hasNext()) {
                if (this.toIter == null) {
                    return;
                }
                if (this.toIter.hasNext()) {
                    Object from = this.toIter.next();
                    if (from instanceof OResult) {
                        from = ((OResult)from).toElement();
                    }
                    if (from instanceof OIdentifiable && !(from instanceof OElement)) {
                        from = ((OIdentifiable)from).getRecord();
                    }
                    if (from instanceof OElement && ((OElement)from).isVertex()) {
                        Iterable<OEdge> edges = ((OElement)from).asVertex().get().getEdges(ODirection.IN);
                        this.currentToEdgesIter = edges.iterator();
                        continue;
                    }
                    throw new OCommandExecutionException("Invalid vertex: " + from);
                }
                return;
            }
            edge = this.currentToEdgesIter.next();
            if (this.matchesClass(edge) && this.matchesCluster(edge)) break;
        }
        this.nextEdge = edge;
    }

    private boolean matchesCluster(OEdge edge) {
        if (this.targetCluster == null) {
            return true;
        }
        int clusterId = edge.getIdentity().getClusterId();
        String clusterName = this.ctx.getDatabase().getClusterNameById(clusterId);
        return clusterName.equals(this.targetCluster.getStringValue());
    }

    private boolean matchesClass(OEdge edge) {
        if (this.targetClass == null) {
            return true;
        }
        return edge.getSchemaType().get().isSubClassOf(this.targetClass.getStringValue());
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        String result = spaces + "+ FOR EACH x in " + this.toAlias + "\n";
        result = result + spaces + "       FETCH EDGES TO x";
        if (this.targetClass != null) {
            result = result + "\n" + spaces + "       (target class " + this.targetClass + ")";
        }
        if (this.targetCluster != null) {
            result = result + "\n" + spaces + "       (target cluster " + this.targetCluster + ")";
        }
        return result;
    }
}

