/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Map;
import java.util.Optional;

public class FetchFromDatabaseMetadataStep
extends AbstractExecutionStep {
    private boolean served = false;
    private long cost = 0L;

    public FetchFromDatabaseMetadataStep(OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        return new OResultSet(){

            @Override
            public boolean hasNext() {
                return !FetchFromDatabaseMetadataStep.this.served;
            }

            @Override
            public OResult next() {
                long begin = FetchFromDatabaseMetadataStep.this.profilingEnabled ? System.nanoTime() : 0L;
                try {
                    if (!FetchFromDatabaseMetadataStep.this.served) {
                        OResultInternal result = new OResultInternal();
                        ODatabase db = ctx.getDatabase();
                        result.setProperty("name", db.getName());
                        result.setProperty("user", db.getUser() == null ? null : db.getUser().getName());
                        result.setProperty("type", String.valueOf(db.get(ODatabase.ATTRIBUTES.TYPE)));
                        result.setProperty("status", String.valueOf(db.get(ODatabase.ATTRIBUTES.STATUS)));
                        result.setProperty("defaultClusterId", String.valueOf(db.get(ODatabase.ATTRIBUTES.DEFAULTCLUSTERID)));
                        result.setProperty("dateFormat", String.valueOf(db.get(ODatabase.ATTRIBUTES.DATEFORMAT)));
                        result.setProperty("dateTimeFormat", String.valueOf(db.get(ODatabase.ATTRIBUTES.DATETIMEFORMAT)));
                        result.setProperty("timezone", String.valueOf(db.get(ODatabase.ATTRIBUTES.TIMEZONE)));
                        result.setProperty("localeCountry", String.valueOf(db.get(ODatabase.ATTRIBUTES.LOCALECOUNTRY)));
                        result.setProperty("localeLanguage", String.valueOf(db.get(ODatabase.ATTRIBUTES.LOCALELANGUAGE)));
                        result.setProperty("charset", String.valueOf(db.get(ODatabase.ATTRIBUTES.CHARSET)));
                        result.setProperty("clusterSelection", String.valueOf(db.get(ODatabase.ATTRIBUTES.CLUSTERSELECTION)));
                        result.setProperty("minimumClusters", String.valueOf(db.get(ODatabase.ATTRIBUTES.MINIMUMCLUSTERS)));
                        result.setProperty("conflictStrategy", String.valueOf(db.get(ODatabase.ATTRIBUTES.CONFLICTSTRATEGY)));
                        result.setProperty("validation", String.valueOf(db.get(ODatabase.ATTRIBUTES.VALIDATION)));
                        FetchFromDatabaseMetadataStep.this.served = true;
                        OResultInternal oResultInternal = result;
                        return oResultInternal;
                    }
                    throw new IllegalStateException();
                }
                finally {
                    if (FetchFromDatabaseMetadataStep.this.profilingEnabled) {
                        FetchFromDatabaseMetadataStep.this.cost = FetchFromDatabaseMetadataStep.this.cost + (System.nanoTime() - begin);
                    }
                }
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }

            @Override
            public void reset() {
                FetchFromDatabaseMetadataStep.this.served = false;
            }
        };
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        String result = spaces + "+ FETCH DATABASE METADATA";
        if (this.profilingEnabled) {
            result = result + " (" + this.getCostFormatted() + ")";
        }
        return result;
    }

    @Override
    public long getCost() {
        return this.cost;
    }
}

