/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OUnwind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class UnwindStep
extends AbstractExecutionStep {
    private final OUnwind unwind;
    private List<String> unwindFields;
    private OResultSet lastResult = null;
    private Iterator<OResult> nextSubsequence = null;
    private OResult nextElement = null;

    public UnwindStep(OUnwind unwind, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.unwind = unwind;
        this.unwindFields = unwind.getItems().stream().map(x -> x.getStringValue()).collect(Collectors.toList());
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, final int nRecords) throws OTimeoutException {
        if (this.prev == null || !this.prev.isPresent()) {
            throw new OCommandExecutionException("Cannot expand without a target");
        }
        return new OResultSet(){
            private long localCount = 0L;

            @Override
            public boolean hasNext() {
                if (this.localCount >= (long)nRecords) {
                    return false;
                }
                if (UnwindStep.this.nextElement == null) {
                    UnwindStep.this.fetchNext(ctx, nRecords);
                }
                return UnwindStep.this.nextElement != null;
            }

            @Override
            public OResult next() {
                if (this.localCount >= (long)nRecords) {
                    throw new IllegalStateException();
                }
                if (UnwindStep.this.nextElement == null) {
                    UnwindStep.this.fetchNext(ctx, nRecords);
                }
                if (UnwindStep.this.nextElement == null) {
                    throw new IllegalStateException();
                }
                OResult result = UnwindStep.this.nextElement;
                ++this.localCount;
                UnwindStep.this.nextElement = null;
                UnwindStep.this.fetchNext(ctx, nRecords);
                return result;
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    private void fetchNext(OCommandContext ctx, int n) {
        while (true) {
            if (this.nextSubsequence != null && this.nextSubsequence.hasNext()) break;
            if (this.nextSubsequence == null || !this.nextSubsequence.hasNext()) {
                if (this.lastResult == null || !this.lastResult.hasNext()) {
                    this.lastResult = this.getPrev().get().syncPull(ctx, n);
                }
                if (!this.lastResult.hasNext()) {
                    return;
                }
            }
            OResult nextAggregateItem = this.lastResult.next();
            this.nextSubsequence = this.unwind(nextAggregateItem, this.unwindFields, ctx).iterator();
        }
        this.nextElement = this.nextSubsequence.next();
    }

    private Collection<OResult> unwind(OResult doc, List<String> unwindFields, OCommandContext iContext) {
        ArrayList<OResult> result = new ArrayList<OResult>();
        if (unwindFields.size() == 0) {
            result.add(doc);
        } else {
            String firstField = unwindFields.get(0);
            List<String> nextFields = unwindFields.subList(1, unwindFields.size());
            Object fieldValue = doc.getProperty(firstField);
            if (fieldValue == null || fieldValue instanceof ODocument) {
                result.addAll(this.unwind(doc, nextFields, iContext));
                return result;
            }
            if (!(fieldValue instanceof Iterable) && !fieldValue.getClass().isArray()) {
                result.addAll(this.unwind(doc, nextFields, iContext));
                return result;
            }
            Iterator<Object> iterator = fieldValue.getClass().isArray() ? OMultiValue.getMultiValueIterator(fieldValue) : ((Iterable)fieldValue).iterator();
            if (!iterator.hasNext()) {
                OResultInternal unwindedDoc = new OResultInternal();
                this.copy(doc, unwindedDoc);
                unwindedDoc.setProperty(firstField, null);
                result.addAll(this.unwind(unwindedDoc, nextFields, iContext));
            } else {
                do {
                    Object o = iterator.next();
                    OResultInternal unwindedDoc = new OResultInternal();
                    this.copy(doc, unwindedDoc);
                    unwindedDoc.setProperty(firstField, o);
                    result.addAll(this.unwind(unwindedDoc, nextFields, iContext));
                } while (iterator.hasNext());
            }
        }
        return result;
    }

    private void copy(OResult from, OResultInternal to) {
        for (String prop : from.getPropertyNames()) {
            to.setProperty(prop, from.getProperty(prop));
        }
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        return spaces + "+ " + this.unwind;
    }
}

