/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.functions.OSQLFunction;
import com.orientechnologies.orient.core.storage.OAutoshardedStorage;
import java.util.List;
import java.util.Set;

public abstract class OSQLFunctionAbstract
implements OSQLFunction {
    protected String name;
    protected int minParams;
    protected int maxParams;

    public OSQLFunctionAbstract(String iName, int iMinParams, int iMaxParams) {
        this.name = iName;
        this.minParams = iMinParams;
        this.maxParams = iMaxParams;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getMinParams() {
        return this.minParams;
    }

    @Override
    public int getMaxParams() {
        return this.maxParams;
    }

    public String toString() {
        return this.name + "()";
    }

    @Override
    public void config(Object[] iConfiguredParameters) {
    }

    @Override
    public boolean aggregateResults() {
        return false;
    }

    @Override
    public boolean filterResult() {
        return false;
    }

    @Override
    public Object getResult() {
        return null;
    }

    @Override
    public void setResult(Object iResult) {
    }

    @Override
    public boolean shouldMergeDistributedResult() {
        return false;
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        throw new IllegalStateException("By default SQL function execution result cannot be merged");
    }

    protected boolean returnDistributedResult() {
        return OScenarioThreadLocal.INSTANCE.isRunModeDistributed();
    }

    protected String getDistributedStorageId() {
        return ((OAutoshardedStorage)((Object)ODatabaseRecordThreadLocal.instance().get().getStorage())).getStorageId();
    }

    protected Object getSingleItem(Object source) {
        if (OMultiValue.isMultiValue(source)) {
            if (OMultiValue.getSize(source) > 1) {
                return null;
            }
            if ((source = OMultiValue.getFirstValue(source)) instanceof OResult && ((OResult)source).isElement()) {
                source = ((OResult)source).getElement().get();
            }
        }
        return source;
    }

    protected Object getSingleProperty(Object source, boolean requireSingleProperty) {
        if (source instanceof OResult) {
            OResult result = (OResult)source;
            Set<String> propertyNames = result.getPropertyNames();
            if (propertyNames.size() != 1) {
                return requireSingleProperty ? null : source;
            }
            return result.getProperty(propertyNames.iterator().next());
        }
        return source;
    }
}

