/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.math;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.filter.OSQLPredicate;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMathAbstract;
import java.util.List;

public class OSQLFunctionInterval
extends OSQLFunctionMathAbstract {
    public static final String NAME = "interval";
    private OSQLPredicate predicate;

    public OSQLFunctionInterval() {
        super(NAME, 2, 0);
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        if (iParams == null || iParams.length < 2) {
            return -1;
        }
        Comparable first = (Comparable)iParams[0];
        if (first == null) {
            return -1;
        }
        for (int i = 1; i < iParams.length; ++i) {
            Comparable other = (Comparable)iParams[i];
            if (other.compareTo(first) <= 0) continue;
            return i - 1;
        }
        return -1;
    }

    @Override
    public boolean aggregateResults() {
        return false;
    }

    @Override
    public String getSyntax() {
        return "interval(<field> [,<field>*])";
    }

    @Override
    public Object getResult() {
        return null;
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        return null;
    }
}

