/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OPropertyMapIndexDefinition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class OQueryOperatorContainsKey
extends OQueryOperatorEqualityNotNulls {
    public OQueryOperatorContainsKey() {
        super("CONTAINSKEY", 5, false);
    }

    @Override
    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        if (iLeft instanceof Map) {
            Map map = (Map)iLeft;
            return map.containsKey(iRight);
        }
        if (iRight instanceof Map) {
            Map map = (Map)iRight;
            return map.containsKey(iLeft);
        }
        return false;
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.INDEX_METHOD;
    }

    @Override
    public Stream<ORawPair<Object, ORID>> executeIndexQuery(OCommandContext iContext, OIndex index, List<Object> keyParams, boolean ascSortOrder) {
        Stream<ORawPair<Object, ORID>> stream;
        OIndexDefinition indexDefinition = index.getDefinition();
        OIndexInternal internalIndex = index.getInternal();
        if (!internalIndex.canBeUsedInEqualityOperators()) {
            return null;
        }
        if (indexDefinition.getParamCount() == 1) {
            if (!(indexDefinition instanceof OPropertyMapIndexDefinition) || ((OPropertyMapIndexDefinition)indexDefinition).getIndexBy() != OPropertyMapIndexDefinition.INDEX_BY.KEY) {
                return null;
            }
            Object key = ((OIndexDefinitionMultiValue)indexDefinition).createSingleValue(keyParams.get(0));
            if (key == null) {
                return null;
            }
            stream = index.getInternal().getRids(key).map(rid -> new ORawPair<Object, ORID>(key, (ORID)rid));
        } else {
            OCompositeIndexDefinition compositeIndexDefinition = (OCompositeIndexDefinition)indexDefinition;
            if (!(compositeIndexDefinition.getMultiValueDefinition() instanceof OPropertyMapIndexDefinition) || ((OPropertyMapIndexDefinition)compositeIndexDefinition.getMultiValueDefinition()).getIndexBy() != OPropertyMapIndexDefinition.INDEX_BY.KEY) {
                return null;
            }
            OCompositeKey keyOne = compositeIndexDefinition.createSingleValue(keyParams);
            if (keyOne == null) {
                return null;
            }
            if (internalIndex.hasRangeQuerySupport()) {
                OCompositeKey keyTwo = compositeIndexDefinition.createSingleValue(keyParams);
                stream = index.getInternal().streamEntriesBetween(keyOne, true, keyTwo, true, ascSortOrder);
            } else if (indexDefinition.getParamCount() == keyParams.size()) {
                stream = index.getInternal().getRids(keyOne).map(rid -> new ORawPair<Object, ORID>(keyOne, (ORID)rid));
            } else {
                return null;
            }
        }
        this.updateProfiler(iContext, index, keyParams, indexDefinition);
        return stream;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }
}

