/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEquality;
import java.util.List;
import java.util.stream.Stream;

public class OQueryOperatorIs
extends OQueryOperatorEquality {
    public OQueryOperatorIs() {
        super("IS", 5, false);
    }

    @Override
    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        if (iCondition.getLeft() instanceof OSQLFilterItemField) {
            if ("_DEFINED_".equals(iCondition.getRight())) {
                return this.evaluateDefined(iRecord, "" + iCondition.getLeft());
            }
            if (iCondition.getRight() instanceof OSQLFilterItemField && "not defined".equalsIgnoreCase("" + iCondition.getRight())) {
                return !this.evaluateDefined(iRecord, "" + iCondition.getLeft());
            }
        }
        if ("_NOT_NULL_".equals(iRight)) {
            return iLeft != null;
        }
        if ("_NOT_NULL_".equals(iLeft)) {
            return iRight != null;
        }
        if ("_DEFINED_".equals(iLeft)) {
            return this.evaluateDefined(iRecord, (String)iRight);
        }
        if ("_DEFINED_".equals(iRight)) {
            return this.evaluateDefined(iRecord, (String)iLeft);
        }
        return iLeft == iRight;
    }

    protected boolean evaluateDefined(OIdentifiable iRecord, String iFieldName) {
        if (iRecord instanceof ODocument) {
            return ((ODocument)iRecord).containsField(iFieldName);
        }
        return false;
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        if (iRight == null) {
            return OIndexReuseType.INDEX_METHOD;
        }
        return OIndexReuseType.NO_INDEX;
    }

    @Override
    public Stream<ORawPair<Object, ORID>> executeIndexQuery(OCommandContext iContext, OIndex index, List<Object> keyParams, boolean ascSortOrder) {
        Stream<ORawPair<Object, ORID>> stream;
        OIndexDefinition indexDefinition = index.getDefinition();
        OIndexInternal internalIndex = index.getInternal();
        if (!internalIndex.canBeUsedInEqualityOperators()) {
            return null;
        }
        if (indexDefinition.getParamCount() == 1) {
            Object key = indexDefinition instanceof OIndexDefinitionMultiValue ? ((OIndexDefinitionMultiValue)indexDefinition).createSingleValue(keyParams.get(0)) : indexDefinition.createValue(keyParams);
            stream = index.getInternal().getRids(key).map(rid -> new ORawPair<Object, ORID>(key, (ORID)rid));
        } else {
            OCompositeIndexDefinition compositeIndexDefinition = (OCompositeIndexDefinition)indexDefinition;
            OCompositeKey keyOne = compositeIndexDefinition.createSingleValue(keyParams);
            OCompositeKey keyTwo = compositeIndexDefinition.createSingleValue(keyParams);
            if (internalIndex.hasRangeQuerySupport()) {
                stream = index.getInternal().streamEntriesBetween(keyOne, true, keyTwo, true, ascSortOrder);
            } else if (indexDefinition.getParamCount() == keyParams.size()) {
                stream = index.getInternal().getRids(keyOne).map(rid -> new ORawPair<Object, ORID>(keyOne, (ORID)rid));
            } else {
                return null;
            }
        }
        this.updateProfiler(iContext, index, keyParams, indexDefinition);
        return stream;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }
}

