/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OSecurityInternal;
import com.orientechnologies.orient.core.metadata.security.OSecurityPolicy;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OSecurityResourceSegment;
import com.orientechnologies.orient.core.sql.parser.OSimpleExecStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OAlterRoleStatement
extends OSimpleExecStatement {
    protected OIdentifier name;
    protected List<Op> operations = new ArrayList<Op>();

    public OAlterRoleStatement(int id) {
        super(id);
    }

    public OAlterRoleStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeSimple(OCommandContext ctx) {
        OInternalResultSet rs = new OInternalResultSet();
        ODatabaseSession db = (ODatabaseSession)ctx.getDatabase();
        OSecurityInternal security = ((ODatabaseInternal)((Object)db)).getSharedContext().getSecurity();
        ORole role = db.getMetadata().getSecurity().getRole(this.name.getStringValue());
        if (role == null) {
            throw new OCommandExecutionException("role not found: " + this.name.getStringValue());
        }
        for (Op op : this.operations) {
            OResultInternal result = new OResultInternal();
            result.setProperty("operation", "alter role");
            result.setProperty("name", this.name.getStringValue());
            result.setProperty("resource", op.resource.toString());
            if (op.type == Op.TYPE_ADD) {
                OSecurityPolicy policy = security.getSecurityPolicy(db, op.policyName.getStringValue());
                result.setProperty("operation", "ADD POLICY");
                result.setProperty("policyName", op.policyName.getStringValue());
                try {
                    security.setSecurityPolicy(db, role, op.resource.toString(), policy);
                    result.setProperty("result", "OK");
                }
                catch (Exception e) {
                    result.setProperty("result", "failure");
                }
            } else {
                result.setProperty("operation", "REMOVE POLICY");
                try {
                    security.removeSecurityPolicy(db, role, op.resource.toString());
                    result.setProperty("result", "OK");
                }
                catch (Exception e) {
                    result.setProperty("result", "failure");
                }
            }
            rs.add(result);
        }
        return rs;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("ALTER ROLE ");
        this.name.toString(params, builder);
        for (Op operation : this.operations) {
            if (operation.type == Op.TYPE_ADD) {
                builder.append(" SET POLICY ");
                operation.policyName.toString(params, builder);
                builder.append(" ON ");
                operation.resource.toString(params, builder);
                continue;
            }
            builder.append(" REMOVE POLICY ON ");
            operation.resource.toString(params, builder);
        }
    }

    static class Op {
        protected static int TYPE_ADD = 0;
        protected static int TYPE_REMOVE = 1;
        protected final int type;
        protected final OSecurityResourceSegment resource;
        protected final OIdentifier policyName;

        Op(int type, OSecurityResourceSegment resource, OIdentifier policyName) {
            this.type = type;
            this.resource = resource;
            this.policyName = policyName;
        }
    }
}

