/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.security.OSecurityInternal;
import com.orientechnologies.orient.core.metadata.security.OSecurityPolicy;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OSimpleExecStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.Map;

public class OAlterSecurityPolicyStatement
extends OSimpleExecStatement {
    protected OIdentifier name;
    protected OBooleanExpression create;
    protected OBooleanExpression read;
    protected OBooleanExpression beforeUpdate;
    protected OBooleanExpression afterUpdate;
    protected OBooleanExpression delete;
    protected OBooleanExpression execute;
    protected boolean removeCreate = false;
    protected boolean removeRead = false;
    protected boolean removeBeforeUpdate = false;
    protected boolean removeAfterUpdate = false;
    protected boolean removeDelete = false;
    protected boolean removeExecute = false;

    public OAlterSecurityPolicyStatement(int id) {
        super(id);
    }

    public OAlterSecurityPolicyStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeSimple(OCommandContext ctx) {
        ODatabaseSession db = (ODatabaseSession)ctx.getDatabase();
        OSecurityInternal security = ((ODatabaseInternal)((Object)db)).getSharedContext().getSecurity();
        OSecurityPolicy policy = security.getSecurityPolicy(db, this.name.getStringValue());
        if (policy == null) {
            throw new OCommandExecutionException("Cannot find security policy " + this.name.toString());
        }
        if (this.create != null) {
            policy.setCreateRule(this.create.toString());
        }
        if (this.read != null) {
            policy.setReadRule(this.read.toString());
        }
        if (this.beforeUpdate != null) {
            policy.setBeforeUpdateRule(this.beforeUpdate.toString());
        }
        if (this.afterUpdate != null) {
            policy.setAfterUpdateRule(this.afterUpdate.toString());
        }
        if (this.delete != null) {
            policy.setDeleteRule(this.delete.toString());
        }
        if (this.execute != null) {
            policy.setExecuteRule(this.execute.toString());
        }
        if (this.removeCreate) {
            policy.setCreateRule(null);
        }
        if (this.removeRead) {
            policy.setReadRule(null);
        }
        if (this.removeBeforeUpdate) {
            policy.setBeforeUpdateRule(null);
        }
        if (this.removeAfterUpdate) {
            policy.setAfterUpdateRule(null);
        }
        if (this.removeDelete) {
            policy.setDeleteRule(null);
        }
        if (this.removeExecute) {
            policy.setExecuteRule(null);
        }
        security.saveSecurityPolicy(db, policy);
        OResultInternal result = new OResultInternal();
        result.setProperty("operation", "alter security policy");
        result.setProperty("name", this.name.getStringValue());
        OInternalResultSet rs = new OInternalResultSet();
        rs.add(result);
        return rs;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("ALTER SECURITY POLICY ");
        this.name.toString(params, builder);
        boolean firstSet = true;
        if (this.create != null) {
            if (firstSet) {
                builder.append(" SET ");
            } else {
                builder.append(", ");
            }
            builder.append("CREATE = (");
            this.create.toString(params, builder);
            builder.append(")");
            firstSet = false;
        }
        if (this.read != null) {
            if (firstSet) {
                builder.append(" SET ");
            } else {
                builder.append(", ");
            }
            builder.append("READ = (");
            this.read.toString(params, builder);
            builder.append(")");
            firstSet = false;
        }
        if (this.beforeUpdate != null) {
            if (firstSet) {
                builder.append(" SET ");
            } else {
                builder.append(", ");
            }
            builder.append("BEFORE UPDATE = (");
            this.beforeUpdate.toString(params, builder);
            builder.append(")");
            firstSet = false;
        }
        if (this.afterUpdate != null) {
            if (firstSet) {
                builder.append(" SET ");
            } else {
                builder.append(", ");
            }
            builder.append("AFTER UPDATE = (");
            this.afterUpdate.toString(params, builder);
            builder.append(")");
            firstSet = false;
        }
        if (this.delete != null) {
            if (firstSet) {
                builder.append(" SET ");
            } else {
                builder.append(", ");
            }
            builder.append("DELETE = (");
            this.delete.toString(params, builder);
            builder.append(")");
            firstSet = false;
        }
        if (this.execute != null) {
            if (firstSet) {
                builder.append(" SET ");
            } else {
                builder.append(", ");
            }
            builder.append("EXECUTE = (");
            this.execute.toString(params, builder);
            builder.append(")");
            firstSet = false;
        }
        boolean firstRemove = true;
        if (this.removeCreate) {
            if (firstRemove) {
                builder.append(" REMOVE ");
            } else {
                builder.append(", ");
            }
            builder.append("CREATE");
            firstRemove = false;
        }
        if (this.removeRead) {
            if (firstRemove) {
                builder.append(" REMOVE ");
            } else {
                builder.append(", ");
            }
            builder.append("READ");
            firstRemove = false;
        }
        if (this.removeBeforeUpdate) {
            if (firstRemove) {
                builder.append(" REMOVE ");
            } else {
                builder.append(", ");
            }
            builder.append("BEFORE UPDATE");
            firstRemove = false;
        }
        if (this.removeAfterUpdate) {
            if (firstRemove) {
                builder.append(" REMOVE ");
            } else {
                builder.append(", ");
            }
            builder.append("AFTER UPDATE");
            firstRemove = false;
        }
        if (this.removeDelete) {
            if (firstRemove) {
                builder.append(" REMOVE ");
            } else {
                builder.append(", ");
            }
            builder.append("DELETE");
            firstRemove = false;
        }
        if (this.removeExecute) {
            if (firstRemove) {
                builder.append(" REMOVE ");
            } else {
                builder.append(", ");
            }
            builder.append("EXECUTE");
            firstRemove = false;
        }
    }
}

