/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.sql.executor.AggregationContext;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.AggregateProjectionSplit;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OLevelZeroIdentifier;
import com.orientechnologies.orient.core.sql.parser.ORecordAttribute;
import com.orientechnologies.orient.core.sql.parser.OSuffixIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class OBaseIdentifier
extends SimpleNode {
    protected OLevelZeroIdentifier levelZero;
    protected OSuffixIdentifier suffix;

    public OBaseIdentifier(int id) {
        super(id);
    }

    public OBaseIdentifier(OrientSql p, int id) {
        super(p, id);
    }

    public OBaseIdentifier(OIdentifier identifier) {
        this.suffix = new OSuffixIdentifier(identifier);
    }

    public OBaseIdentifier(ORecordAttribute attr) {
        this.suffix = new OSuffixIdentifier(attr);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.levelZero != null) {
            this.levelZero.toString(params, builder);
        } else if (this.suffix != null) {
            this.suffix.toString(params, builder);
        }
    }

    public Object execute(OIdentifiable iCurrentRecord, OCommandContext ctx) {
        if (this.levelZero != null) {
            return this.levelZero.execute(iCurrentRecord, ctx);
        }
        if (this.suffix != null) {
            return this.suffix.execute(iCurrentRecord, ctx);
        }
        return null;
    }

    public Object execute(OResult iCurrentRecord, OCommandContext ctx) {
        if (this.levelZero != null) {
            return this.levelZero.execute(iCurrentRecord, ctx);
        }
        if (this.suffix != null) {
            return this.suffix.execute(iCurrentRecord, ctx);
        }
        return null;
    }

    public boolean isFunctionAny() {
        if (this.levelZero != null) {
            return this.levelZero.isFunctionAny();
        }
        return false;
    }

    public boolean isIndexedFunctionCall() {
        if (this.levelZero != null) {
            return this.levelZero.isIndexedFunctionCall();
        }
        return false;
    }

    public long estimateIndexedFunction(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.levelZero != null) {
            return this.levelZero.estimateIndexedFunction(target, context, operator, right);
        }
        return -1L;
    }

    public Iterable<OIdentifiable> executeIndexedFunction(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.levelZero != null) {
            return this.levelZero.executeIndexedFunction(target, context, operator, right);
        }
        return null;
    }

    public boolean canExecuteIndexedFunctionWithoutIndex(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.levelZero == null) {
            return false;
        }
        return this.levelZero.canExecuteIndexedFunctionWithoutIndex(target, context, operator, right);
    }

    public boolean allowsIndexedFunctionExecutionOnTarget(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.levelZero == null) {
            return false;
        }
        return this.levelZero.allowsIndexedFunctionExecutionOnTarget(target, context, operator, right);
    }

    public boolean executeIndexedFunctionAfterIndexSearch(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.levelZero == null) {
            return false;
        }
        return this.levelZero.executeIndexedFunctionAfterIndexSearch(target, context, operator, right);
    }

    public boolean isBaseIdentifier() {
        return this.suffix != null && this.suffix.isBaseIdentifier();
    }

    public boolean isExpand() {
        if (this.levelZero != null) {
            return this.levelZero.isExpand();
        }
        return false;
    }

    public OExpression getExpandContent() {
        return this.levelZero.getExpandContent();
    }

    public boolean needsAliases(Set<String> aliases) {
        if (this.levelZero != null && this.levelZero.needsAliases(aliases)) {
            return true;
        }
        return this.suffix != null && this.suffix.needsAliases(aliases);
    }

    public boolean isAggregate() {
        if (this.levelZero != null && this.levelZero.isAggregate()) {
            return true;
        }
        return this.suffix != null && this.suffix.isAggregate();
    }

    public boolean isCount() {
        if (this.levelZero != null && this.levelZero.isCount()) {
            return true;
        }
        return this.suffix != null && this.suffix.isCount();
    }

    public boolean isEarlyCalculated(OCommandContext ctx) {
        if (this.levelZero != null && this.levelZero.isEarlyCalculated(ctx)) {
            return true;
        }
        return this.suffix != null && this.suffix.isEarlyCalculated(ctx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SimpleNode splitForAggregation(AggregateProjectionSplit aggregateProj, OCommandContext ctx) {
        if (!this.isAggregate()) return this;
        OBaseIdentifier result = new OBaseIdentifier(-1);
        if (this.levelZero != null) {
            SimpleNode splitResult = this.levelZero.splitForAggregation(aggregateProj, ctx);
            if (!(splitResult instanceof OLevelZeroIdentifier)) return splitResult;
            result.levelZero = (OLevelZeroIdentifier)splitResult;
            return result;
        } else {
            if (this.suffix == null) throw new IllegalStateException();
            result.suffix = this.suffix.splitForAggregation(aggregateProj);
        }
        return result;
    }

    public AggregationContext getAggregationContext(OCommandContext ctx) {
        if (this.isAggregate()) {
            if (this.levelZero != null) {
                return this.levelZero.getAggregationContext(ctx);
            }
            if (this.suffix != null) {
                return this.suffix.getAggregationContext(ctx);
            }
            throw new OCommandExecutionException("cannot aggregate on " + this.toString());
        }
        throw new OCommandExecutionException("cannot aggregate on " + this.toString());
    }

    public void setLevelZero(OLevelZeroIdentifier levelZero) {
        this.levelZero = levelZero;
    }

    @Override
    public OBaseIdentifier copy() {
        OBaseIdentifier result = new OBaseIdentifier(-1);
        result.levelZero = this.levelZero == null ? null : this.levelZero.copy();
        result.suffix = this.suffix == null ? null : this.suffix.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBaseIdentifier that = (OBaseIdentifier)o;
        if (this.levelZero != null ? !this.levelZero.equals(that.levelZero) : that.levelZero != null) {
            return false;
        }
        return !(this.suffix != null ? !this.suffix.equals(that.suffix) : that.suffix != null);
    }

    public int hashCode() {
        int result = this.levelZero != null ? this.levelZero.hashCode() : 0;
        result = 31 * result + (this.suffix != null ? this.suffix.hashCode() : 0);
        return result;
    }

    public boolean refersToParent() {
        if (this.levelZero != null && this.levelZero.refersToParent()) {
            return true;
        }
        return this.suffix != null && this.suffix.refersToParent();
    }

    public OSuffixIdentifier getSuffix() {
        return this.suffix;
    }

    public OLevelZeroIdentifier getLevelZero() {
        return this.levelZero;
    }

    public void applyRemove(OResultInternal result, OCommandContext ctx) {
        if (this.suffix == null) {
            throw new OCommandExecutionException("cannot apply REMOVE " + this.toString());
        }
        this.suffix.applyRemove(result, ctx);
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        if (this.levelZero != null) {
            result.setProperty("levelZero", this.levelZero.serialize());
        }
        if (this.suffix != null) {
            result.setProperty("suffix", this.suffix.serialize());
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        if (fromResult.getProperty("levelZero") != null) {
            this.levelZero = new OLevelZeroIdentifier(-1);
            this.levelZero.deserialize((OResult)fromResult.getProperty("levelZero"));
        }
        if (fromResult.getProperty("suffix") != null) {
            this.suffix = new OSuffixIdentifier(-1);
            this.suffix.deserialize((OResult)fromResult.getProperty("suffix"));
        }
    }

    public boolean isDefinedFor(OResult currentRecord) {
        if (this.suffix != null) {
            return this.suffix.isDefinedFor(currentRecord);
        }
        return true;
    }

    public boolean isDefinedFor(OElement currentRecord) {
        if (this.suffix != null) {
            return this.suffix.isDefinedFor(currentRecord);
        }
        return true;
    }

    public void extractSubQueries(OIdentifier letAlias, SubQueryCollector collector) {
        if (this.levelZero != null) {
            this.levelZero.extractSubQueries(letAlias, collector);
        }
    }

    public void extractSubQueries(SubQueryCollector collector) {
        if (this.levelZero != null) {
            this.levelZero.extractSubQueries(collector);
        }
    }

    public OCollate getCollate(OResult currentRecord, OCommandContext ctx) {
        return this.suffix == null ? null : this.suffix.getCollate(currentRecord, ctx);
    }

    public boolean isCacheable() {
        if (this.levelZero != null) {
            return this.levelZero.isCacheable();
        }
        if (this.suffix != null) {
            return this.suffix.isCacheable();
        }
        return true;
    }

    public boolean isIndexChain(OCommandContext ctx, OClass clazz) {
        if (this.suffix != null && this.suffix.isBaseIdentifier()) {
            OProperty prop = clazz.getProperty(this.suffix.identifier.getStringValue());
            if (prop == null) {
                return false;
            }
            Collection<OIndex> allIndexes = prop.getAllIndexes();
            return allIndexes != null && allIndexes.stream().anyMatch(idx -> idx.getDefinition().getFields().size() == 1);
        }
        return false;
    }
}

