/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.sequence.OSequence;
import com.orientechnologies.orient.core.metadata.sequence.SequenceOrderType;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OSimpleExecStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class OCreateSequenceStatement
extends OSimpleExecStatement {
    public static final int TYPE_CACHED = 0;
    public static final int TYPE_ORDERED = 1;
    OIdentifier name;
    public boolean ifNotExists = false;
    int type;
    OExpression start;
    OExpression increment;
    OExpression cache;
    boolean positive = OSequence.DEFAULT_ORDER_TYPE == SequenceOrderType.ORDER_POSITIVE;
    boolean cyclic = false;
    OExpression limitValue;

    public OCreateSequenceStatement(int id) {
        super(id);
    }

    public OCreateSequenceStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeSimple(OCommandContext ctx) {
        OSequence seq = ctx.getDatabase().getMetadata().getSequenceLibrary().getSequence(this.name.getStringValue());
        if (seq != null) {
            if (this.ifNotExists) {
                return new OInternalResultSet();
            }
            throw new OCommandExecutionException("Sequence " + this.name.getStringValue() + " already exists");
        }
        OResultInternal result = new OResultInternal();
        result.setProperty("operation", "create sequence");
        result.setProperty("name", this.name.getStringValue());
        try {
            this.executeInternal(ctx, result);
        }
        catch (InterruptedException | ExecutionException exc) {
            String message = "Unable to execute command: " + exc.getMessage();
            OLogManager.instance().error(this, message, exc, new Object[]{null});
            throw new OCommandExecutionException(message);
        }
        OInternalResultSet rs = new OInternalResultSet();
        rs.add(result);
        return rs;
    }

    private void executeInternal(OCommandContext ctx, OResultInternal result) throws ExecutionException, InterruptedException {
        OSequence.CreateParams params = this.createParams(ctx, result);
        OSequence.SEQUENCE_TYPE seqType = this.type == 0 ? OSequence.SEQUENCE_TYPE.CACHED : OSequence.SEQUENCE_TYPE.ORDERED;
        result.setProperty("type", seqType.toString());
        ctx.getDatabase().getMetadata().getSequenceLibrary().createSequence(this.name.getStringValue(), seqType, params);
    }

    private OSequence.CreateParams createParams(OCommandContext ctx, OResultInternal result) {
        Object o;
        OSequence.CreateParams params = new OSequence.CreateParams();
        if (this.start != null) {
            o = this.start.execute((OIdentifiable)null, ctx);
            if (o instanceof Number) {
                params.setStart(((Number)o).longValue());
                result.setProperty("start", o);
            } else {
                throw new OCommandExecutionException("Invalid start value: " + o);
            }
        }
        if (this.increment != null) {
            o = this.increment.execute((OIdentifiable)null, ctx);
            if (o instanceof Number) {
                params.setIncrement(((Number)o).intValue());
                result.setProperty("increment", o);
            } else {
                throw new OCommandExecutionException("Invalid increment value: " + o);
            }
        }
        if (this.cache != null) {
            o = this.cache.execute((OIdentifiable)null, ctx);
            if (o instanceof Number) {
                params.setCacheSize(((Number)o).intValue());
                result.setProperty("cacheSize", o);
            } else {
                throw new OCommandExecutionException("Invalid cache value: " + o);
            }
        }
        if (this.limitValue != null) {
            o = this.limitValue.execute((OIdentifiable)null, ctx);
            if (o instanceof Number) {
                params.setLimitValue(((Number)o).longValue());
                result.setProperty("limitValue", o);
            } else {
                throw new OCommandExecutionException("Invalid limit value: " + o);
            }
        }
        params.setOrderType(this.positive ? SequenceOrderType.ORDER_POSITIVE : SequenceOrderType.ORDER_NEGATIVE);
        result.setProperty("orderType", params.getOrderType().toString());
        params.setRecyclable(this.cyclic);
        result.setProperty("recycable", params.getRecyclable());
        return params;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("CREATE SEQUENCE ");
        this.name.toString(params, builder);
        if (this.ifNotExists) {
            builder.append(" IF NOT EXISTS");
        }
        builder.append(" TYPE ");
        switch (this.type) {
            case 0: {
                builder.append(" CACHED");
                break;
            }
            case 1: {
                builder.append(" ORDERED");
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type for CREATE SEQUENCE: " + this.type);
            }
        }
        if (this.start != null) {
            builder.append(" START ");
            this.start.toString(params, builder);
        }
        if (this.increment != null) {
            builder.append(" INCREMENT ");
            this.increment.toString(params, builder);
        }
        if (this.cache != null) {
            builder.append(" CACHE ");
            this.cache.toString(params, builder);
        }
        if (this.limitValue != null) {
            builder.append(" LIMIT ");
            this.limitValue.toString(params, builder);
        }
        if (this.cyclic) {
            builder.append(" CYCLE ").append(Boolean.toString(this.cyclic).toUpperCase());
        }
        if (this.positive) {
            builder.append(" ASC");
        } else {
            builder.append(" DESC");
        }
    }

    @Override
    public OCreateSequenceStatement copy() {
        OCreateSequenceStatement result = new OCreateSequenceStatement(-1);
        result.name = this.name == null ? null : this.name.copy();
        result.ifNotExists = this.ifNotExists;
        result.type = this.type;
        result.start = this.start == null ? null : this.start.copy();
        result.increment = this.increment == null ? null : this.increment.copy();
        result.cache = this.cache == null ? null : this.cache.copy();
        result.limitValue = this.limitValue == null ? null : this.limitValue.copy();
        result.cyclic = this.cyclic;
        result.positive = this.positive;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCreateSequenceStatement that = (OCreateSequenceStatement)o;
        if (this.ifNotExists != that.ifNotExists) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.start != null ? !this.start.equals(that.start) : that.start != null) {
            return false;
        }
        if (this.increment != null ? !this.increment.equals(that.increment) : that.increment != null) {
            return false;
        }
        if (this.cache != null ? !this.cache.equals(that.cache) : that.cache != null) {
            return false;
        }
        if (this.limitValue != null ? !this.limitValue.equals(that.limitValue) : that.limitValue != null) {
            return false;
        }
        if (this.cyclic != that.cyclic) {
            return false;
        }
        return this.positive == that.positive;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.ifNotExists ? 1 : 0);
        result = 31 * result + this.type;
        result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
        result = 31 * result + (this.increment != null ? this.increment.hashCode() : 0);
        result = 31 * result + (this.cache != null ? this.cache.hashCode() : 0);
        result = 31 * result + (this.limitValue != null ? this.limitValue.hashCode() : 0);
        result = 31 * result + Boolean.hashCode(this.cyclic);
        result = 31 * result + Boolean.hashCode(this.positive);
        return result;
    }
}

