/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.sql.executor.ODeleteEdgeExecutionPlanner;
import com.orientechnologies.orient.core.sql.executor.ODeleteExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OBatch;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OLimit;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSet;
import com.orientechnologies.orient.core.sql.parser.ORid;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ODeleteEdgeStatement
extends OStatement {
    private static final Object unset = new Object();
    protected OIdentifier className;
    protected OIdentifier targetClusterName;
    protected ORid rid;
    protected List<ORid> rids;
    protected OExpression leftExpression;
    protected OExpression rightExpression;
    protected OWhereClause whereClause;
    protected OLimit limit;
    protected OBatch batch = null;

    public ODeleteEdgeStatement(int id) {
        super(id);
    }

    public ODeleteEdgeStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet execute(ODatabase db, Map params, OCommandContext parentCtx, boolean usePlanCache) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        ctx.setInputParameters(params);
        ODeleteExecutionPlan executionPlan = usePlanCache ? (ODeleteExecutionPlan)this.createExecutionPlan(ctx, false) : (ODeleteExecutionPlan)this.createExecutionPlanNoCache(ctx, false);
        executionPlan.executeInternal();
        return new OLocalResultSet(executionPlan);
    }

    @Override
    public OResultSet execute(ODatabase db, Object[] args, OCommandContext parentCtx, boolean usePlanCache) {
        HashMap<Integer, Object> params = new HashMap<Integer, Object>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                params.put(i, args[i]);
            }
        }
        return this.execute(db, params, parentCtx, usePlanCache);
    }

    @Override
    public OInternalExecutionPlan createExecutionPlan(OCommandContext ctx, boolean enableProfiling) {
        ODeleteEdgeExecutionPlanner planner = new ODeleteEdgeExecutionPlanner(this);
        OInternalExecutionPlan result = planner.createExecutionPlan(ctx, enableProfiling, true);
        result.setStatement(this.originalStatement);
        return result;
    }

    @Override
    public OInternalExecutionPlan createExecutionPlanNoCache(OCommandContext ctx, boolean enableProfiling) {
        ODeleteEdgeExecutionPlanner planner = new ODeleteEdgeExecutionPlanner(this);
        OInternalExecutionPlan result = planner.createExecutionPlan(ctx, enableProfiling, false);
        result.setStatement(this.originalStatement);
        return result;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("DELETE EDGE");
        if (this.className != null) {
            builder.append(" ");
            this.className.toString(params, builder);
            if (this.targetClusterName != null) {
                builder.append(" CLUSTER ");
                this.targetClusterName.toString(params, builder);
            }
        }
        if (this.rid != null) {
            builder.append(" ");
            this.rid.toString(params, builder);
        }
        if (this.rids != null) {
            builder.append(" [");
            boolean first = true;
            for (ORid rid : this.rids) {
                if (!first) {
                    builder.append(", ");
                }
                rid.toString(params, builder);
                first = false;
            }
            builder.append("]");
        }
        if (this.leftExpression != null) {
            builder.append(" FROM ");
            this.leftExpression.toString(params, builder);
        }
        if (this.rightExpression != null) {
            builder.append(" TO ");
            this.rightExpression.toString(params, builder);
        }
        if (this.whereClause != null) {
            builder.append(" WHERE ");
            this.whereClause.toString(params, builder);
        }
        if (this.limit != null) {
            this.limit.toString(params, builder);
        }
        if (this.batch != null) {
            this.batch.toString(params, builder);
        }
    }

    @Override
    public ODeleteEdgeStatement copy() {
        ODeleteEdgeStatement result = null;
        try {
            result = (ODeleteEdgeStatement)this.getClass().getConstructor(Integer.TYPE).newInstance(-1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        result.className = this.className == null ? null : this.className.copy();
        result.targetClusterName = this.targetClusterName == null ? null : this.targetClusterName.copy();
        result.rid = this.rid == null ? null : this.rid.copy();
        result.rids = this.rids == null ? null : this.rids.stream().map(x -> x.copy()).collect(Collectors.toList());
        result.leftExpression = this.leftExpression == null ? null : this.leftExpression.copy();
        result.rightExpression = this.rightExpression == null ? null : this.rightExpression.copy();
        result.whereClause = this.whereClause == null ? null : this.whereClause.copy();
        result.limit = this.limit == null ? null : this.limit.copy();
        result.batch = this.batch == null ? null : this.batch.copy();
        return result;
    }

    @Override
    public boolean executinPlanCanBeCached() {
        if (this.leftExpression != null && !this.leftExpression.isCacheable()) {
            return false;
        }
        if (this.rightExpression != null && !this.rightExpression.isCacheable()) {
            return false;
        }
        return this.whereClause == null || this.whereClause.isCacheable();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ODeleteEdgeStatement that = (ODeleteEdgeStatement)o;
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.targetClusterName != null ? !this.targetClusterName.equals(that.targetClusterName) : that.targetClusterName != null) {
            return false;
        }
        if (this.rid != null ? !this.rid.equals(that.rid) : that.rid != null) {
            return false;
        }
        if (this.rids != null ? !this.rids.equals(that.rids) : that.rids != null) {
            return false;
        }
        if (this.leftExpression != null ? !this.leftExpression.equals(that.leftExpression) : that.leftExpression != null) {
            return false;
        }
        if (this.rightExpression != null ? !this.rightExpression.equals(that.rightExpression) : that.rightExpression != null) {
            return false;
        }
        if (this.whereClause != null ? !this.whereClause.equals(that.whereClause) : that.whereClause != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) {
            return false;
        }
        return !(this.batch != null ? !this.batch.equals(that.batch) : that.batch != null);
    }

    public int hashCode() {
        int result = this.className != null ? this.className.hashCode() : 0;
        result = 31 * result + (this.targetClusterName != null ? this.targetClusterName.hashCode() : 0);
        result = 31 * result + (this.rid != null ? this.rid.hashCode() : 0);
        result = 31 * result + (this.rids != null ? this.rids.hashCode() : 0);
        result = 31 * result + (this.leftExpression != null ? this.leftExpression.hashCode() : 0);
        result = 31 * result + (this.rightExpression != null ? this.rightExpression.hashCode() : 0);
        result = 31 * result + (this.whereClause != null ? this.whereClause.hashCode() : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.batch != null ? this.batch.hashCode() : 0);
        return result;
    }

    public OIdentifier getClassName() {
        return this.className;
    }

    public void setClassName(OIdentifier className) {
        this.className = className;
    }

    public OIdentifier getTargetClusterName() {
        return this.targetClusterName;
    }

    public void setTargetClusterName(OIdentifier targetClusterName) {
        this.targetClusterName = targetClusterName;
    }

    public ORid getRid() {
        return this.rid;
    }

    public void setRid(ORid rid) {
        this.rid = rid;
    }

    public List<ORid> getRids() {
        return this.rids;
    }

    public void setRids(List<ORid> rids) {
        this.rids = rids;
    }

    public OWhereClause getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(OWhereClause whereClause) {
        this.whereClause = whereClause;
    }

    public OLimit getLimit() {
        return this.limit;
    }

    public void setLimit(OLimit limit) {
        this.limit = limit;
    }

    public OBatch getBatch() {
        return this.batch;
    }

    public void setBatch(OBatch batch) {
        this.batch = batch;
    }

    public OExpression getLeftExpression() {
        return this.leftExpression;
    }

    public void setLeftExpression(OExpression leftExpression) {
        this.leftExpression = leftExpression;
    }

    public OExpression getRightExpression() {
        return this.rightExpression;
    }

    public void setRightExpression(OExpression rightExpression) {
        this.rightExpression = rightExpression;
    }
}

