/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.ODDLStatement;
import com.orientechnologies.orient.core.sql.parser.OIndexName;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.Map;

public class ODropIndexStatement
extends ODDLStatement {
    protected boolean all = false;
    protected OIndexName name;
    protected boolean ifExists = false;

    public ODropIndexStatement(int id) {
        super(id);
    }

    public ODropIndexStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeDDL(OCommandContext ctx) {
        OInternalResultSet rs = new OInternalResultSet();
        ODatabaseDocumentInternal db = (ODatabaseDocumentInternal)ctx.getDatabase();
        OIndexManagerAbstract idxMgr = db.getMetadata().getIndexManagerInternal();
        if (this.all) {
            for (OIndex oIndex : idxMgr.getIndexes(db)) {
                db.getMetadata().getIndexManagerInternal().dropIndex(db, oIndex.getName());
                OResultInternal result = new OResultInternal();
                result.setProperty("operation", "drop index");
                result.setProperty("clusterName", oIndex.getName());
                rs.add(result);
            }
        } else {
            if (!idxMgr.existsIndex(this.name.getValue()) && !this.ifExists) {
                throw new OCommandExecutionException("Index not found: " + this.name.getValue());
            }
            idxMgr.dropIndex(db, this.name.getValue());
            OResultInternal result = new OResultInternal();
            result.setProperty("operation", "drop index");
            result.setProperty("indexName", this.name.getValue());
            rs.add(result);
        }
        return rs;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("DROP INDEX ");
        if (this.all) {
            builder.append("*");
        } else {
            this.name.toString(params, builder);
        }
        if (this.ifExists) {
            builder.append(" IF EXISTS");
        }
    }

    @Override
    public ODropIndexStatement copy() {
        ODropIndexStatement result = new ODropIndexStatement(-1);
        result.all = this.all;
        result.name = this.name == null ? null : this.name.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ODropIndexStatement that = (ODropIndexStatement)o;
        if (this.all != that.all) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.all ? 1 : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }
}

