/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.sql.executor.AggregationContext;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.AggregateProjectionSplit;
import com.orientechnologies.orient.core.sql.parser.OArrayConcatExpression;
import com.orientechnologies.orient.core.sql.parser.OBaseExpression;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OJson;
import com.orientechnologies.orient.core.sql.parser.OMathExpression;
import com.orientechnologies.orient.core.sql.parser.OModifier;
import com.orientechnologies.orient.core.sql.parser.ONumber;
import com.orientechnologies.orient.core.sql.parser.ORecordAttribute;
import com.orientechnologies.orient.core.sql.parser.ORid;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OExpression
extends SimpleNode {
    protected Boolean singleQuotes;
    protected Boolean doubleQuotes;
    protected boolean isNull = false;
    protected ORid rid;
    protected OMathExpression mathExpression;
    protected OArrayConcatExpression arrayConcatExpression;
    protected OJson json;
    protected Boolean booleanValue;

    public OExpression(int id) {
        super(id);
    }

    public OExpression(OrientSql p, int id) {
        super(p, id);
    }

    public OExpression(OIdentifier identifier) {
        this.mathExpression = new OBaseExpression(identifier);
    }

    public OExpression(OIdentifier identifier, OModifier modifier) {
        this.mathExpression = new OBaseExpression(identifier, modifier);
    }

    public OExpression(ORecordAttribute attr, OModifier modifier) {
        this.mathExpression = new OBaseExpression(attr, modifier);
    }

    public Object execute(OIdentifiable iCurrentRecord, OCommandContext ctx) {
        if (this.isNull) {
            return null;
        }
        if (this.rid != null) {
            return this.rid.toRecordId(iCurrentRecord, ctx);
        }
        if (this.mathExpression != null) {
            return this.mathExpression.execute(iCurrentRecord, ctx);
        }
        if (this.arrayConcatExpression != null) {
            return this.arrayConcatExpression.execute(iCurrentRecord, ctx);
        }
        if (this.json != null) {
            return this.json.toMap(iCurrentRecord, ctx);
        }
        if (this.booleanValue != null) {
            return this.booleanValue;
        }
        if (this.value instanceof ONumber) {
            return ((ONumber)this.value).getValue();
        }
        if (this.value instanceof ORid) {
            ORid v = (ORid)this.value;
            return new ORecordId(v.cluster.getValue().intValue(), v.position.getValue().longValue());
        }
        if (this.value instanceof OMathExpression) {
            return ((OMathExpression)this.value).execute(iCurrentRecord, ctx);
        }
        if (this.value instanceof OArrayConcatExpression) {
            return ((OArrayConcatExpression)this.value).execute(iCurrentRecord, ctx);
        }
        if (this.value instanceof OJson) {
            return ((OJson)this.value).toMap(iCurrentRecord, ctx);
        }
        if (this.value instanceof String) {
            return this.value;
        }
        if (this.value instanceof Number) {
            return this.value;
        }
        return this.value;
    }

    public Object execute(OResult iCurrentRecord, OCommandContext ctx) {
        if (this.isNull) {
            return null;
        }
        if (this.rid != null) {
            return this.rid.toRecordId(iCurrentRecord, ctx);
        }
        if (this.mathExpression != null) {
            return this.mathExpression.execute(iCurrentRecord, ctx);
        }
        if (this.arrayConcatExpression != null) {
            return this.arrayConcatExpression.execute(iCurrentRecord, ctx);
        }
        if (this.json != null) {
            return this.json.toObjectDetermineType(iCurrentRecord, ctx);
        }
        if (this.booleanValue != null) {
            return this.booleanValue;
        }
        if (this.value instanceof ONumber) {
            return ((ONumber)this.value).getValue();
        }
        if (this.value instanceof ORid) {
            ORid v = (ORid)this.value;
            return new ORecordId(v.cluster.getValue().intValue(), v.position.getValue().longValue());
        }
        if (this.value instanceof OMathExpression) {
            return ((OMathExpression)this.value).execute(iCurrentRecord, ctx);
        }
        if (this.value instanceof OArrayConcatExpression) {
            return ((OArrayConcatExpression)this.value).execute(iCurrentRecord, ctx);
        }
        if (this.value instanceof OJson) {
            return ((OJson)this.value).toMap(iCurrentRecord, ctx);
        }
        if (this.value instanceof String) {
            return this.value;
        }
        if (this.value instanceof Number) {
            return this.value;
        }
        return this.value;
    }

    public boolean isBaseIdentifier() {
        if (this.mathExpression != null) {
            return this.mathExpression.isBaseIdentifier();
        }
        if (this.value instanceof OMathExpression) {
            return ((OMathExpression)this.value).isBaseIdentifier();
        }
        return false;
    }

    public boolean isEarlyCalculated(OCommandContext ctx) {
        if (this.mathExpression != null) {
            return this.mathExpression.isEarlyCalculated(ctx);
        }
        if (this.arrayConcatExpression != null) {
            return this.arrayConcatExpression.isEarlyCalculated(ctx);
        }
        if (this.booleanValue != null) {
            return true;
        }
        if (this.rid != null) {
            return true;
        }
        if (this.value instanceof Number) {
            return true;
        }
        if (this.value instanceof String) {
            return true;
        }
        if (this.value instanceof OMathExpression) {
            return ((OMathExpression)this.value).isEarlyCalculated(ctx);
        }
        return false;
    }

    public OIdentifier getDefaultAlias() {
        OIdentifier identifier = this.isBaseIdentifier() ? new OIdentifier(((OBaseExpression)this.mathExpression).identifier.getSuffix().identifier.getStringValue()) : new OIdentifier(this.toString());
        return identifier;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.isNull) {
            builder.append("null");
        } else if (this.rid != null) {
            this.rid.toString(params, builder);
        } else if (this.mathExpression != null) {
            this.mathExpression.toString(params, builder);
        } else if (this.arrayConcatExpression != null) {
            this.arrayConcatExpression.toString(params, builder);
        } else if (this.json != null) {
            this.json.toString(params, builder);
        } else if (this.booleanValue != null) {
            builder.append(this.booleanValue.toString());
        } else if (this.value instanceof SimpleNode) {
            ((SimpleNode)this.value).toString(params, builder);
        } else if (this.value instanceof String) {
            if (Boolean.TRUE.equals(this.singleQuotes)) {
                builder.append("'" + this.value + "'");
            } else {
                builder.append("\"" + this.value + "\"");
            }
        } else {
            builder.append("" + this.value);
        }
    }

    public static String encode(String s) {
        StringBuilder builder = new StringBuilder(s.length());
        for (char c : s.toCharArray()) {
            if (c == '\n') {
                builder.append("\\n");
                continue;
            }
            if (c == '\t') {
                builder.append("\\t");
                continue;
            }
            if (c == '\\' || c == '\"') {
                builder.append("\\");
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public boolean supportsBasicCalculation() {
        if (this.mathExpression != null) {
            return this.mathExpression.supportsBasicCalculation();
        }
        if (this.arrayConcatExpression != null) {
            return this.arrayConcatExpression.supportsBasicCalculation();
        }
        return true;
    }

    public boolean isIndexedFunctionCal() {
        if (this.mathExpression != null) {
            return this.mathExpression.isIndexedFunctionCall();
        }
        return false;
    }

    public static String encodeSingle(String s) {
        StringBuilder builder = new StringBuilder(s.length());
        for (char c : s.toCharArray()) {
            if (c == '\n') {
                builder.append("\\n");
                continue;
            }
            if (c == '\t') {
                builder.append("\\t");
                continue;
            }
            if (c == '\\' || c == '\'') {
                builder.append("\\");
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public long estimateIndexedFunction(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.mathExpression != null) {
            return this.mathExpression.estimateIndexedFunction(target, context, operator, right);
        }
        return -1L;
    }

    public Iterable<OIdentifiable> executeIndexedFunction(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.mathExpression != null) {
            return this.mathExpression.executeIndexedFunction(target, context, operator, right);
        }
        return null;
    }

    public boolean canExecuteIndexedFunctionWithoutIndex(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.mathExpression != null) {
            return this.mathExpression.canExecuteIndexedFunctionWithoutIndex(target, context, operator, right);
        }
        return false;
    }

    public boolean allowsIndexedFunctionExecutionOnTarget(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.mathExpression != null) {
            return this.mathExpression.allowsIndexedFunctionExecutionOnTarget(target, context, operator, right);
        }
        return false;
    }

    public boolean executeIndexedFunctionAfterIndexSearch(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.mathExpression != null) {
            return this.mathExpression.executeIndexedFunctionAfterIndexSearch(target, context, operator, right);
        }
        return false;
    }

    public boolean isExpand() {
        if (this.mathExpression != null) {
            return this.mathExpression.isExpand();
        }
        return false;
    }

    public OExpression getExpandContent() {
        return this.mathExpression.getExpandContent();
    }

    public boolean needsAliases(Set<String> aliases) {
        if (this.mathExpression != null) {
            return this.mathExpression.needsAliases(aliases);
        }
        if (this.arrayConcatExpression != null) {
            return this.arrayConcatExpression.needsAliases(aliases);
        }
        if (this.json != null) {
            return this.json.needsAliases(aliases);
        }
        return false;
    }

    public boolean isAggregate() {
        if (this.mathExpression != null && this.mathExpression.isAggregate()) {
            return true;
        }
        if (this.arrayConcatExpression != null && this.arrayConcatExpression.isAggregate()) {
            return true;
        }
        return this.json != null && this.json.isAggregate();
    }

    public OExpression splitForAggregation(AggregateProjectionSplit aggregateSplit, OCommandContext ctx) {
        if (this.isAggregate()) {
            SimpleNode splitResult;
            OExpression result = new OExpression(-1);
            if (this.mathExpression != null) {
                splitResult = this.mathExpression.splitForAggregation(aggregateSplit, ctx);
                if (splitResult instanceof OMathExpression) {
                    result.mathExpression = (OMathExpression)splitResult;
                } else {
                    if (splitResult instanceof OExpression) {
                        return (OExpression)splitResult;
                    }
                    throw new IllegalStateException("something went wrong while splitting expression for aggregate " + this.toString());
                }
            }
            if (this.arrayConcatExpression != null) {
                splitResult = this.arrayConcatExpression.splitForAggregation(aggregateSplit);
                if (splitResult instanceof OArrayConcatExpression) {
                    result.arrayConcatExpression = (OArrayConcatExpression)splitResult;
                } else {
                    if (splitResult instanceof OExpression) {
                        return (OExpression)splitResult;
                    }
                    throw new IllegalStateException("something went wrong while splitting expression for aggregate " + this.toString());
                }
            }
            if (this.json != null) {
                result.json = this.json.splitForAggregation(aggregateSplit, ctx);
            }
            return result;
        }
        return this;
    }

    public AggregationContext getAggregationContext(OCommandContext ctx) {
        if (this.mathExpression != null) {
            return this.mathExpression.getAggregationContext(ctx);
        }
        if (this.arrayConcatExpression != null) {
            return this.arrayConcatExpression.getAggregationContext(ctx);
        }
        throw new OCommandExecutionException("Cannot aggregate on " + this.toString());
    }

    @Override
    public OExpression copy() {
        OExpression result = new OExpression(-1);
        result.singleQuotes = this.singleQuotes;
        result.doubleQuotes = this.doubleQuotes;
        result.isNull = this.isNull;
        result.rid = this.rid == null ? null : this.rid.copy();
        result.mathExpression = this.mathExpression == null ? null : this.mathExpression.copy();
        result.arrayConcatExpression = this.arrayConcatExpression == null ? null : this.arrayConcatExpression.copy();
        result.json = this.json == null ? null : this.json.copy();
        result.booleanValue = this.booleanValue;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OExpression that = (OExpression)o;
        if (this.isNull != that.isNull) {
            return false;
        }
        if (this.singleQuotes != null ? !this.singleQuotes.equals(that.singleQuotes) : that.singleQuotes != null) {
            return false;
        }
        if (this.doubleQuotes != null ? !this.doubleQuotes.equals(that.doubleQuotes) : that.doubleQuotes != null) {
            return false;
        }
        if (this.rid != null ? !this.rid.equals(that.rid) : that.rid != null) {
            return false;
        }
        if (this.mathExpression != null ? !this.mathExpression.equals(that.mathExpression) : that.mathExpression != null) {
            return false;
        }
        if (this.arrayConcatExpression != null ? !this.arrayConcatExpression.equals(that.arrayConcatExpression) : that.arrayConcatExpression != null) {
            return false;
        }
        if (this.json != null ? !this.json.equals(that.json) : that.json != null) {
            return false;
        }
        return !(this.booleanValue != null ? !this.booleanValue.equals(that.booleanValue) : that.booleanValue != null);
    }

    public int hashCode() {
        int result = this.singleQuotes != null ? this.singleQuotes.hashCode() : 0;
        result = 31 * result + (this.doubleQuotes != null ? this.doubleQuotes.hashCode() : 0);
        result = 31 * result + (this.isNull ? 1 : 0);
        result = 31 * result + (this.rid != null ? this.rid.hashCode() : 0);
        result = 31 * result + (this.mathExpression != null ? this.mathExpression.hashCode() : 0);
        result = 31 * result + (this.arrayConcatExpression != null ? this.arrayConcatExpression.hashCode() : 0);
        result = 31 * result + (this.json != null ? this.json.hashCode() : 0);
        result = 31 * result + (this.booleanValue != null ? this.booleanValue.hashCode() : 0);
        return result;
    }

    public void setMathExpression(OMathExpression mathExpression) {
        this.mathExpression = mathExpression;
    }

    public void extractSubQueries(SubQueryCollector collector) {
        if (this.mathExpression != null) {
            this.mathExpression.extractSubQueries(collector);
        }
        if (this.arrayConcatExpression != null) {
            this.arrayConcatExpression.extractSubQueries(collector);
        }
        if (this.json != null) {
            this.json.extractSubQueries(collector);
        }
    }

    public void extractSubQueries(OIdentifier letAlias, SubQueryCollector collector) {
        if (this.mathExpression != null) {
            this.mathExpression.extractSubQueries(letAlias, collector);
        }
        if (this.arrayConcatExpression != null) {
            this.arrayConcatExpression.extractSubQueries(collector);
        }
        if (this.json != null) {
            this.json.extractSubQueries(collector);
        }
    }

    public boolean refersToParent() {
        if (this.mathExpression != null && this.mathExpression.refersToParent()) {
            return true;
        }
        if (this.arrayConcatExpression != null && this.arrayConcatExpression.refersToParent()) {
            return true;
        }
        return this.json != null && this.json.refersToParent();
    }

    public ORid getRid() {
        return this.rid;
    }

    public void setRid(ORid rid) {
        this.rid = rid;
    }

    public OMathExpression getMathExpression() {
        return this.mathExpression;
    }

    List<String> getMatchPatternInvolvedAliases() {
        if (this.mathExpression != null) {
            return this.mathExpression.getMatchPatternInvolvedAliases();
        }
        if (this.arrayConcatExpression != null) {
            return this.arrayConcatExpression.getMatchPatternInvolvedAliases();
        }
        return null;
    }

    public void applyRemove(OResultInternal result, OCommandContext ctx) {
        if (this.mathExpression == null) {
            throw new OCommandExecutionException("Cannot apply REMOVE " + this.toString());
        }
        this.mathExpression.applyRemove(result, ctx);
    }

    public boolean isCount() {
        if (this.mathExpression == null) {
            return false;
        }
        return this.mathExpression.isCount();
    }

    public OArrayConcatExpression getArrayConcatExpression() {
        return this.arrayConcatExpression;
    }

    public void setArrayConcatExpression(OArrayConcatExpression arrayConcatExpression) {
        this.arrayConcatExpression = arrayConcatExpression;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        result.setProperty("singleQuotes", this.singleQuotes);
        result.setProperty("doubleQuotes", this.doubleQuotes);
        result.setProperty("isNull", this.isNull);
        if (this.rid != null) {
            result.setProperty("rid", this.rid.serialize());
        }
        if (this.mathExpression != null) {
            result.setProperty("mathExpression", this.mathExpression.serialize());
        }
        if (this.arrayConcatExpression != null) {
            result.setProperty("arrayConcatExpression", this.arrayConcatExpression.serialize());
        }
        if (this.json != null) {
            result.setProperty("json", this.json.serialize());
        }
        result.setProperty("booleanValue", this.booleanValue);
        return result;
    }

    public void deserialize(OResult fromResult) {
        this.singleQuotes = (Boolean)fromResult.getProperty("singleQuotes");
        this.doubleQuotes = (Boolean)fromResult.getProperty("doubleQuotes");
        this.isNull = (Boolean)fromResult.getProperty("isNull");
        if (fromResult.getProperty("rid") != null) {
            this.rid = new ORid(-1);
            this.rid.deserialize((OResult)fromResult.getProperty("rid"));
        }
        if (fromResult.getProperty("mathExpression") != null) {
            this.mathExpression = OMathExpression.deserializeFromResult((OResult)fromResult.getProperty("mathExpression"));
        }
        if (fromResult.getProperty("arrayConcatExpression") != null) {
            this.arrayConcatExpression = new OArrayConcatExpression(-1);
            this.arrayConcatExpression.deserialize((OResult)fromResult.getProperty("arrayConcatExpression"));
        }
        if (fromResult.getProperty("json") != null) {
            this.json = new OJson(-1);
            this.json.deserialize((OResult)fromResult.getProperty("json"));
        }
        this.booleanValue = (Boolean)fromResult.getProperty("booleanValue");
    }

    public boolean isDefinedFor(OResult currentRecord) {
        if (this.mathExpression != null) {
            return this.mathExpression.isDefinedFor(currentRecord);
        }
        return true;
    }

    public boolean isDefinedFor(OElement currentRecord) {
        if (this.mathExpression != null) {
            return this.mathExpression.isDefinedFor(currentRecord);
        }
        return true;
    }

    public OCollate getCollate(OResult currentRecord, OCommandContext ctx) {
        if (this.mathExpression != null) {
            return this.mathExpression.getCollate(currentRecord, ctx);
        }
        return null;
    }

    public boolean isCacheable() {
        if (this.mathExpression != null) {
            return this.mathExpression.isCacheable();
        }
        if (this.arrayConcatExpression != null) {
            return this.arrayConcatExpression.isCacheable();
        }
        if (this.json != null) {
            return this.json.isCacheable();
        }
        return true;
    }

    public boolean isIndexChain(OCommandContext ctx, OClass clazz) {
        if (this.mathExpression != null) {
            return this.mathExpression.isIndexChain(ctx, clazz);
        }
        return false;
    }

    public boolean isFunctionAny() {
        if (this.mathExpression != null) {
            return this.mathExpression.isFunctionAny();
        }
        return false;
    }
}

