/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.sql.executor.OFindReferencesExecutionPlanner;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSet;
import com.orientechnologies.orient.core.sql.parser.ORid;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OFindReferencesStatement
extends OStatement {
    protected ORid rid;
    protected OStatement subQuery;
    protected List<SimpleNode> targets;

    public OFindReferencesStatement(int id) {
        super(id);
    }

    public OFindReferencesStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public boolean isIdempotent() {
        return true;
    }

    @Override
    public OResultSet execute(ODatabase db, Object[] args, OCommandContext parentCtx, boolean usePlanCache) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                params.put(i, args[i]);
            }
        }
        ctx.setInputParameters(params);
        OInternalExecutionPlan executionPlan = usePlanCache ? this.createExecutionPlan(ctx, false) : this.createExecutionPlanNoCache(ctx, false);
        return new OLocalResultSet(executionPlan);
    }

    @Override
    public OResultSet execute(ODatabase db, Map params, OCommandContext parentCtx, boolean usePlanCache) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        ctx.setInputParameters(params);
        OInternalExecutionPlan executionPlan = usePlanCache ? this.createExecutionPlan(ctx, false) : this.createExecutionPlanNoCache(ctx, false);
        return new OLocalResultSet(executionPlan);
    }

    @Override
    public OInternalExecutionPlan createExecutionPlan(OCommandContext ctx, boolean enableProfiling) {
        return new OFindReferencesExecutionPlanner(this).createExecutionPlan(ctx, enableProfiling);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("FIND REFERENCES ");
        if (this.rid != null) {
            this.rid.toString(params, builder);
        } else {
            builder.append(" ( ");
            this.subQuery.toString(params, builder);
            builder.append(" )");
        }
        if (this.targets != null) {
            builder.append(" [");
            boolean first = true;
            for (SimpleNode node : this.targets) {
                if (!first) {
                    builder.append(",");
                }
                node.toString(params, builder);
                first = false;
            }
            builder.append("]");
        }
    }

    @Override
    public OFindReferencesStatement copy() {
        OFindReferencesStatement result = new OFindReferencesStatement(-1);
        result.rid = this.rid == null ? null : this.rid.copy();
        result.subQuery = this.subQuery == null ? null : this.subQuery.copy();
        result.targets = this.targets == null ? null : this.targets.stream().map(x -> x.copy()).collect(Collectors.toList());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OFindReferencesStatement that = (OFindReferencesStatement)o;
        if (this.rid != null ? !this.rid.equals(that.rid) : that.rid != null) {
            return false;
        }
        if (this.subQuery != null ? !this.subQuery.equals(that.subQuery) : that.subQuery != null) {
            return false;
        }
        return !(this.targets != null ? !this.targets.equals(that.targets) : that.targets != null);
    }

    public int hashCode() {
        int result = this.rid != null ? this.rid.hashCode() : 0;
        result = 31 * result + (this.subQuery != null ? this.subQuery.hashCode() : 0);
        result = 31 * result + (this.targets != null ? this.targets.hashCode() : 0);
        return result;
    }

    public ORid getRid() {
        return this.rid;
    }

    public OStatement getSubQuery() {
        return this.subQuery;
    }

    public List<SimpleNode> getTargets() {
        return this.targets;
    }
}

