/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OLetItem;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OLetClause
extends SimpleNode {
    protected List<OLetItem> items = new ArrayList<OLetItem>();

    public OLetClause(int id) {
        super(id);
    }

    public OLetClause(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("LET ");
        boolean first = true;
        for (OLetItem item : this.items) {
            if (!first) {
                builder.append(", ");
            }
            item.toString(params, builder);
            first = false;
        }
    }

    public void addItem(OLetItem item) {
        this.items.add(item);
    }

    @Override
    public OLetClause copy() {
        OLetClause result = new OLetClause(-1);
        result.items = this.items.stream().map(x -> x.copy()).collect(Collectors.toList());
        return result;
    }

    public List<OLetItem> getItems() {
        return this.items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OLetClause that = (OLetClause)o;
        return !(this.items != null ? !this.items.equals(that.items) : that.items != null);
    }

    public int hashCode() {
        return this.items != null ? this.items.hashCode() : 0;
    }

    public boolean refersToParent() {
        for (OLetItem item : this.items) {
            if (!item.refersToParent()) continue;
            return true;
        }
        return false;
    }

    public void extractSubQueries(SubQueryCollector collector) {
        for (OLetItem item : this.items) {
            item.extractSubQueries(collector);
        }
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        if (this.items != null) {
            result.setProperty("items", this.items.stream().map(x -> x.serialize()).collect(Collectors.toList()));
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        if (fromResult.getProperty("items") != null) {
            List ser = (List)fromResult.getProperty("items");
            this.items = new ArrayList<OLetItem>();
            for (OResult r : ser) {
                OLetItem exp = new OLetItem(-1);
                exp.deserialize(r);
                this.items.add(exp);
            }
        }
    }

    public boolean isCacheable() {
        for (OLetItem item : this.items) {
            if (item.isCacheable()) continue;
            return false;
        }
        return true;
    }
}

