/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class OLocalResultSet
implements OResultSet {
    private OResultSet lastFetch = null;
    private final OInternalExecutionPlan executionPlan;
    private boolean finished = false;
    long totalExecutionTime = 0L;
    long startTime = 0L;

    public OLocalResultSet(OInternalExecutionPlan executionPlan) {
        this.executionPlan = executionPlan;
        this.fetchNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchNext() {
        long begin = System.currentTimeMillis();
        try {
            if (this.lastFetch == null) {
                this.startTime = begin;
            }
            this.lastFetch = this.executionPlan.fetchNext(100);
            if (!this.lastFetch.hasNext()) {
                this.finished = true;
                this.logProfiling();
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.totalExecutionTime += System.currentTimeMillis() - begin;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.lastFetch.hasNext()) {
            return true;
        }
        return this.fetchNext();
    }

    @Override
    public OResult next() {
        if (this.finished) {
            throw new IllegalStateException();
        }
        if (!this.lastFetch.hasNext() && !this.fetchNext()) {
            throw new IllegalStateException();
        }
        return this.lastFetch.next();
    }

    private void logProfiling() {
        ODatabaseDocumentInternal db;
        if (this.executionPlan.getStatement() != null && Orient.instance().getProfiler().isRecording() && (db = ODatabaseRecordThreadLocal.instance().getIfDefined()) != null) {
            OSecurityUser user = db.getUser();
            String userString = user != null ? user.toString() : null;
            Orient.instance().getProfiler().stopChrono("db." + ODatabaseRecordThreadLocal.instance().get().getName() + ".command.sql." + this.executionPlan.getStatement(), "Command executed against the database", System.currentTimeMillis() - this.totalExecutionTime, "db.*.command.*", null, userString);
        }
    }

    public long getTotalExecutionTime() {
        return this.totalExecutionTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public void close() {
        this.executionPlan.close();
    }

    @Override
    public Optional<OExecutionPlan> getExecutionPlan() {
        return Optional.of(this.executionPlan);
    }

    @Override
    public Map<String, Long> getQueryStats() {
        return new HashMap<String, Long>();
    }
}

