/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;

public class OLtOperator
extends SimpleNode
implements OBinaryCompareOperator {
    public OLtOperator(int id) {
        super(id);
    }

    public OLtOperator(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public boolean execute(Object iLeft, Object iRight) {
        if (iLeft == null || iRight == null) {
            return false;
        }
        if (iLeft instanceof Number && iRight instanceof Number && iLeft.getClass() != iRight.getClass()) {
            Number[] couple = OType.castComparableNumber((Number)iLeft, (Number)iRight);
            iLeft = couple[0];
            iRight = couple[1];
        } else {
            iRight = OType.convert(iRight, iLeft.getClass());
        }
        if (iRight == null) {
            return false;
        }
        return ((Comparable)iLeft).compareTo(iRight) < 0;
    }

    @Override
    public String toString() {
        return "<";
    }

    @Override
    public boolean supportsBasicCalculation() {
        return true;
    }

    @Override
    public OLtOperator copy() {
        return this;
    }

    @Override
    public boolean isRangeOperator() {
        return true;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

