/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.parser.OMatchFilter;
import com.orientechnologies.orient.core.sql.parser.OMatchPathItem;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OMatchExpression
extends SimpleNode {
    protected OMatchFilter origin;
    protected List<OMatchPathItem> items = new ArrayList<OMatchPathItem>();

    public OMatchExpression(int id) {
        super(id);
    }

    public OMatchExpression(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.origin.toString(params, builder);
        for (OMatchPathItem item : this.items) {
            item.toString(params, builder);
        }
    }

    @Override
    public OMatchExpression copy() {
        OMatchExpression result = new OMatchExpression(-1);
        result.origin = this.origin == null ? null : this.origin.copy();
        result.items = this.items == null ? null : this.items.stream().map(x -> x.copy()).collect(Collectors.toList());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OMatchExpression that = (OMatchExpression)o;
        if (this.origin != null ? !this.origin.equals(that.origin) : that.origin != null) {
            return false;
        }
        return !(this.items != null ? !this.items.equals(that.items) : that.items != null);
    }

    public int hashCode() {
        int result = this.origin != null ? this.origin.hashCode() : 0;
        result = 31 * result + (this.items != null ? this.items.hashCode() : 0);
        return result;
    }

    public OMatchFilter getOrigin() {
        return this.origin;
    }

    public void setOrigin(OMatchFilter origin) {
        this.origin = origin;
    }

    public List<OMatchPathItem> getItems() {
        return this.items;
    }

    public void setItems(List<OMatchPathItem> items) {
        this.items = items;
    }
}

