/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OArrayRangeSelector;
import com.orientechnologies.orient.core.sql.parser.OArraySingleValuesSelector;
import com.orientechnologies.orient.core.sql.parser.OMethodCall;
import com.orientechnologies.orient.core.sql.parser.OOrBlock;
import com.orientechnologies.orient.core.sql.parser.ORightBinaryCondition;
import com.orientechnologies.orient.core.sql.parser.OSuffixIdentifier;
import com.orientechnologies.orient.core.sql.parser.OUpdateItem;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class OModifier
extends SimpleNode {
    protected boolean squareBrackets = false;
    protected OArrayRangeSelector arrayRange;
    protected OOrBlock condition;
    protected OArraySingleValuesSelector arraySingleValues;
    protected ORightBinaryCondition rightBinaryCondition;
    protected OMethodCall methodCall;
    protected OSuffixIdentifier suffix;
    protected OModifier next;

    public OModifier(int id) {
        super(id);
    }

    public OModifier(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.squareBrackets) {
            builder.append("[");
            if (this.arrayRange != null) {
                this.arrayRange.toString(params, builder);
            } else if (this.condition != null) {
                this.condition.toString(params, builder);
            } else if (this.arraySingleValues != null) {
                this.arraySingleValues.toString(params, builder);
            } else if (this.rightBinaryCondition != null) {
                this.rightBinaryCondition.toString(params, builder);
            }
            builder.append("]");
        } else if (this.methodCall != null) {
            this.methodCall.toString(params, builder);
        } else if (this.suffix != null) {
            builder.append(".");
            this.suffix.toString(params, builder);
        }
        if (this.next != null) {
            this.next.toString(params, builder);
        }
    }

    public Object execute(OIdentifiable iCurrentRecord, Object result, OCommandContext ctx) {
        if (ctx.getVariable("$current") == null) {
            ctx.setVariable("$current", iCurrentRecord);
        }
        if (this.methodCall != null) {
            result = this.methodCall.execute(result, ctx);
        } else if (this.suffix != null) {
            result = this.suffix.execute(result, ctx);
        } else if (this.arrayRange != null) {
            result = this.arrayRange.execute(iCurrentRecord, result, ctx);
        } else if (this.condition != null) {
            result = this.filterByCondition(result, ctx);
        } else if (this.arraySingleValues != null) {
            result = this.arraySingleValues.execute(iCurrentRecord, result, ctx);
        } else if (this.rightBinaryCondition != null) {
            result = this.rightBinaryCondition.execute(iCurrentRecord, result, ctx);
        }
        if (this.next != null) {
            result = this.next.execute(iCurrentRecord, result, ctx);
        }
        return result;
    }

    public Object execute(OResult iCurrentRecord, Object result, OCommandContext ctx) {
        if (ctx.getVariable("$current") == null) {
            ctx.setVariable("$current", iCurrentRecord);
        }
        if (this.methodCall != null) {
            result = this.methodCall.execute(result, ctx);
        } else if (this.suffix != null) {
            result = this.suffix.execute(result, ctx);
        } else if (this.arrayRange != null) {
            result = this.arrayRange.execute(iCurrentRecord, result, ctx);
        } else if (this.condition != null) {
            result = this.filterByCondition(result, ctx);
        } else if (this.arraySingleValues != null) {
            result = this.arraySingleValues.execute(iCurrentRecord, result, ctx);
        } else if (this.rightBinaryCondition != null) {
            result = this.rightBinaryCondition.execute(iCurrentRecord, result, ctx);
        }
        if (this.next != null) {
            result = this.next.execute(iCurrentRecord, result, ctx);
        }
        return result;
    }

    private Object filterByCondition(Object iResult, OCommandContext ctx) {
        if (iResult == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        if (iResult.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(iResult); ++i) {
                Object item = Array.get(iResult, i);
                if (!this.condition.evaluate(item, ctx)) continue;
                result.add(item);
            }
            return result;
        }
        if (iResult instanceof OIdentifiable) {
            iResult = Collections.singleton(iResult);
        }
        if (iResult instanceof Iterable) {
            iResult = ((Iterable)iResult).iterator();
        }
        if (iResult instanceof Iterator) {
            while (((Iterator)iResult).hasNext()) {
                Object item = ((Iterator)iResult).next();
                if (!this.condition.evaluate(item, ctx)) continue;
                result.add(item);
            }
        }
        return result;
    }

    public boolean needsAliases(Set<String> aliases) {
        if (this.condition != null && this.condition.needsAliases(aliases)) {
            return true;
        }
        if (this.arraySingleValues != null && this.arraySingleValues.needsAliases(aliases)) {
            return true;
        }
        if (this.arrayRange != null && this.arrayRange.needsAliases(aliases)) {
            return true;
        }
        if (this.rightBinaryCondition != null && this.rightBinaryCondition.needsAliases(aliases)) {
            return true;
        }
        if (this.methodCall != null && this.methodCall.needsAliases(aliases)) {
            return true;
        }
        return this.next != null && this.next.needsAliases(aliases);
    }

    @Override
    public OModifier copy() {
        OModifier result = new OModifier(-1);
        result.squareBrackets = this.squareBrackets;
        result.arrayRange = this.arrayRange == null ? null : this.arrayRange.copy();
        result.condition = this.condition == null ? null : this.condition.copy();
        result.arraySingleValues = this.arraySingleValues == null ? null : this.arraySingleValues.copy();
        result.rightBinaryCondition = this.rightBinaryCondition == null ? null : this.rightBinaryCondition.copy();
        result.methodCall = this.methodCall == null ? null : this.methodCall.copy();
        result.suffix = this.suffix == null ? null : this.suffix.copy();
        result.next = this.next == null ? null : this.next.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OModifier oModifier = (OModifier)o;
        if (this.squareBrackets != oModifier.squareBrackets) {
            return false;
        }
        if (this.arrayRange != null ? !this.arrayRange.equals(oModifier.arrayRange) : oModifier.arrayRange != null) {
            return false;
        }
        if (this.condition != null ? !this.condition.equals(oModifier.condition) : oModifier.condition != null) {
            return false;
        }
        if (this.arraySingleValues != null ? !this.arraySingleValues.equals(oModifier.arraySingleValues) : oModifier.arraySingleValues != null) {
            return false;
        }
        if (this.rightBinaryCondition != null ? !this.rightBinaryCondition.equals(oModifier.rightBinaryCondition) : oModifier.rightBinaryCondition != null) {
            return false;
        }
        if (this.methodCall != null ? !this.methodCall.equals(oModifier.methodCall) : oModifier.methodCall != null) {
            return false;
        }
        if (this.suffix != null ? !this.suffix.equals(oModifier.suffix) : oModifier.suffix != null) {
            return false;
        }
        return !(this.next != null ? !this.next.equals(oModifier.next) : oModifier.next != null);
    }

    public int hashCode() {
        int result = this.squareBrackets ? 1 : 0;
        result = 31 * result + (this.arrayRange != null ? this.arrayRange.hashCode() : 0);
        result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
        result = 31 * result + (this.arraySingleValues != null ? this.arraySingleValues.hashCode() : 0);
        result = 31 * result + (this.rightBinaryCondition != null ? this.rightBinaryCondition.hashCode() : 0);
        result = 31 * result + (this.methodCall != null ? this.methodCall.hashCode() : 0);
        result = 31 * result + (this.suffix != null ? this.suffix.hashCode() : 0);
        result = 31 * result + (this.next != null ? this.next.hashCode() : 0);
        return result;
    }

    public void extractSubQueries(SubQueryCollector collector) {
        if (this.arrayRange != null) {
            this.arrayRange.extractSubQueries(collector);
        }
        if (this.condition != null) {
            this.condition.extractSubQueries(collector);
        }
        if (this.arraySingleValues != null) {
            this.arraySingleValues.extractSubQueries(collector);
        }
        if (this.rightBinaryCondition != null) {
            this.rightBinaryCondition.extractSubQueries(collector);
        }
        if (this.methodCall != null) {
            this.methodCall.extractSubQueries(collector);
        }
        if (this.suffix != null) {
            this.suffix.extractSubQueries(collector);
        }
        if (this.next != null) {
            this.next.extractSubQueries(collector);
        }
    }

    public boolean refersToParent() {
        if (this.arrayRange != null && this.arrayRange.refersToParent()) {
            return true;
        }
        if (this.condition != null && this.condition.refersToParent()) {
            return true;
        }
        if (this.arraySingleValues != null && this.arraySingleValues.refersToParent()) {
            return true;
        }
        if (this.rightBinaryCondition != null && this.rightBinaryCondition.refersToParent()) {
            return true;
        }
        if (this.methodCall != null && this.methodCall.refersToParent()) {
            return true;
        }
        return this.suffix != null && this.suffix.refersToParent();
    }

    protected void setValue(OResult currentRecord, Object target, Object value, OCommandContext ctx) {
        if (this.next == null) {
            this.doSetValue(currentRecord, target, value, ctx);
        } else {
            Object newTarget = this.calculateLocal(currentRecord, target, ctx);
            if (newTarget != null) {
                this.next.setValue(currentRecord, newTarget, value, ctx);
            }
        }
    }

    private void doSetValue(OResult currentRecord, Object target, Object value, OCommandContext ctx) {
        value = OUpdateItem.convertResultToDocument(value);
        if (this.methodCall == null) {
            if (this.suffix != null) {
                this.suffix.setValue(target, value, ctx);
            } else if (this.arrayRange != null) {
                this.arrayRange.setValue(target, value, ctx);
            } else {
                if (this.condition != null) {
                    throw new UnsupportedOperationException("SET value on conditional filtering will be supported soon");
                }
                if (this.arraySingleValues != null) {
                    this.arraySingleValues.setValue(currentRecord, target, value, ctx);
                } else if (this.rightBinaryCondition != null) {
                    throw new UnsupportedOperationException("SET value on conditional filtering will be supported soon");
                }
            }
        }
    }

    private Object calculateLocal(OResult currentRecord, Object target, OCommandContext ctx) {
        if (this.methodCall != null) {
            return this.methodCall.execute(target, ctx);
        }
        if (this.suffix != null) {
            return this.suffix.execute(target, ctx);
        }
        if (this.arrayRange != null) {
            return this.arrayRange.execute(currentRecord, target, ctx);
        }
        if (this.condition != null) {
            if (target instanceof OResult || target instanceof OIdentifiable || target instanceof Map) {
                if (this.condition.evaluate(target, ctx)) {
                    return target;
                }
                return null;
            }
            if (OMultiValue.isMultiValue(target)) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (Object o : OMultiValue.getMultiValueIterable(target)) {
                    if (!this.condition.evaluate(o, ctx)) continue;
                    result.add(o);
                }
                return result;
            }
            return null;
        }
        if (this.arraySingleValues != null) {
            return this.arraySingleValues.execute(currentRecord, target, ctx);
        }
        if (this.rightBinaryCondition != null) {
            return this.rightBinaryCondition.execute(currentRecord, target, ctx);
        }
        return null;
    }

    public void applyRemove(Object currentValue, OResultInternal originalRecord, OCommandContext ctx) {
        if (this.next != null) {
            Object val = this.calculateLocal(originalRecord, currentValue, ctx);
            this.next.applyRemove(val, originalRecord, ctx);
        } else if (this.arrayRange != null) {
            this.arrayRange.applyRemove(currentValue, originalRecord, ctx);
        } else {
            if (this.condition != null) {
                throw new UnsupportedOperationException("Remove on conditional filtering will be supported soon");
            }
            if (this.arraySingleValues != null) {
                this.arraySingleValues.applyRemove(currentValue, originalRecord, ctx);
            } else {
                if (this.rightBinaryCondition != null) {
                    throw new UnsupportedOperationException("Remove on conditional filtering will be supported soon");
                }
                if (this.suffix != null) {
                    this.suffix.applyRemove(currentValue, ctx);
                } else {
                    throw new OCommandExecutionException("cannot apply REMOVE " + this.toString());
                }
            }
        }
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        result.setProperty("squareBrackets", this.squareBrackets);
        if (this.arrayRange != null) {
            result.setProperty("arrayRange", this.arrayRange.serialize());
        }
        if (this.condition != null) {
            result.setProperty("condition", this.condition.serialize());
        }
        if (this.arraySingleValues != null) {
            result.setProperty("arraySingleValues", this.arraySingleValues.serialize());
        }
        if (this.rightBinaryCondition != null) {
            result.setProperty("rightBinaryCondition", this.rightBinaryCondition.serialize());
        }
        if (this.methodCall != null) {
            result.setProperty("methodCall", this.methodCall.serialize());
        }
        if (this.suffix != null) {
            result.setProperty("suffix", this.suffix.serialize());
        }
        if (this.next != null) {
            result.setProperty("next", this.next.serialize());
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        this.squareBrackets = (Boolean)fromResult.getProperty("squareBrackets");
        if (fromResult.getProperty("arrayRange") != null) {
            this.arrayRange = new OArrayRangeSelector(-1);
            this.arrayRange.deserialize((OResult)fromResult.getProperty("arrayRange"));
        }
        if (fromResult.getProperty("condition") != null) {
            this.condition = new OOrBlock(-1);
            this.condition.deserialize((OResult)fromResult.getProperty("condition"));
        }
        if (fromResult.getProperty("arraySingleValues") != null) {
            this.arraySingleValues = new OArraySingleValuesSelector(-1);
            this.arraySingleValues.deserialize((OResult)fromResult.getProperty("arraySingleValues"));
        }
        if (fromResult.getProperty("rightBinaryCondition") != null) {
            this.rightBinaryCondition = new ORightBinaryCondition(-1);
            this.rightBinaryCondition.deserialize((OResult)fromResult.getProperty("arraySingleValues"));
        }
        if (fromResult.getProperty("methodCall") != null) {
            this.methodCall = new OMethodCall(-1);
            this.methodCall.deserialize((OResult)fromResult.getProperty("methodCall"));
        }
        if (fromResult.getProperty("suffix") != null) {
            this.suffix = new OSuffixIdentifier(-1);
            this.suffix.deserialize((OResult)fromResult.getProperty("suffix"));
        }
        if (fromResult.getProperty("next") != null) {
            this.next = new OModifier(-1);
            this.next.deserialize((OResult)fromResult.getProperty("next"));
        }
    }

    public boolean isCacheable() {
        if (this.arrayRange != null || this.arraySingleValues != null || this.rightBinaryCondition != null) {
            return false;
        }
        if (this.condition != null && !this.condition.isCacheable()) {
            return false;
        }
        if (this.methodCall != null && !this.methodCall.isCacheable()) {
            return false;
        }
        if (this.suffix != null && !this.suffix.isCacheable()) {
            return false;
        }
        return this.next == null || this.next.isCacheable();
    }

    public boolean isIndexChain(OCommandContext ctx, OClass clazz) {
        OProperty prop;
        if (this.suffix != null && this.suffix.isBaseIdentifier() && (prop = clazz.getProperty(this.suffix.identifier.getStringValue())) != null && prop.getAllIndexes().stream().anyMatch(idx -> idx.getDefinition().getFields().size() == 1)) {
            if (this.next != null) {
                OClass linkedClazz = prop.getLinkedClass();
                return this.next.isIndexChain(ctx, linkedClazz);
            }
            return true;
        }
        return false;
    }
}

