/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.parser.OBaseExpression;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OInCondition;
import com.orientechnologies.orient.core.sql.parser.OInputParameter;
import com.orientechnologies.orient.core.sql.parser.OMathExpression;
import com.orientechnologies.orient.core.sql.parser.OSelectStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ONotInCondition
extends OBooleanExpression {
    protected OExpression left;
    protected OBinaryCompareOperator operator;
    protected OSelectStatement rightStatement;
    protected Object right;
    protected OInputParameter rightParam;
    protected OMathExpression rightMathExpression;
    private static final Object UNSET = new Object();
    private Object inputFinalValue = UNSET;

    public ONotInCondition(int id) {
        super(id);
    }

    public ONotInCondition(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord, OCommandContext ctx) {
        Object leftVal = this.left.execute(currentRecord, ctx);
        Object rightVal = null;
        if (this.rightStatement != null) {
            rightVal = OInCondition.executeQuery(this.rightStatement, ctx);
        } else if (this.rightParam != null) {
            rightVal = this.rightParam.getValue(ctx.getInputParameters());
        } else if (this.rightMathExpression != null) {
            rightVal = this.rightMathExpression.execute(currentRecord, ctx);
        }
        if (rightVal == null) {
            return true;
        }
        return !OInCondition.evaluateExpression(leftVal, rightVal);
    }

    @Override
    public boolean evaluate(OResult currentRecord, OCommandContext ctx) {
        Object leftVal = this.left.execute(currentRecord, ctx);
        Object rightVal = null;
        if (this.rightStatement != null) {
            rightVal = OInCondition.executeQuery(this.rightStatement, ctx);
        } else if (this.rightParam != null) {
            rightVal = this.rightParam.getValue(ctx.getInputParameters());
        } else if (this.rightMathExpression != null) {
            rightVal = this.rightMathExpression.execute(currentRecord, ctx);
        }
        if (rightVal == null) {
            return true;
        }
        return !OInCondition.evaluateExpression(leftVal, rightVal);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.left.toString(params, builder);
        builder.append(" NOT IN ");
        if (this.rightStatement != null) {
            builder.append("(");
            this.rightStatement.toString(params, builder);
            builder.append(")");
        } else if (this.right != null) {
            builder.append(this.convertToString(this.right));
        } else if (this.rightParam != null) {
            this.rightParam.toString(params, builder);
        } else if (this.rightMathExpression != null) {
            this.rightMathExpression.toString(params, builder);
        }
    }

    private String convertToString(Object o) {
        if (o instanceof String) {
            return "\"" + ((String)o).replaceAll("\"", "\\\"") + "\"";
        }
        return o.toString();
    }

    @Override
    public boolean supportsBasicCalculation() {
        if (this.operator != null && !this.operator.supportsBasicCalculation()) {
            return false;
        }
        if (this.left != null && !this.left.supportsBasicCalculation()) {
            return false;
        }
        return this.rightMathExpression == null || this.rightMathExpression.supportsBasicCalculation();
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        int total = 0;
        if (this.operator != null && !this.operator.supportsBasicCalculation()) {
            ++total;
        }
        if (this.left != null && !this.left.supportsBasicCalculation()) {
            ++total;
        }
        if (this.rightMathExpression != null && !this.rightMathExpression.supportsBasicCalculation()) {
            ++total;
        }
        return total;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.operator != null && !this.operator.supportsBasicCalculation()) {
            result.add(this);
        }
        if (this.rightMathExpression != null && !this.rightMathExpression.supportsBasicCalculation()) {
            result.add(this.rightMathExpression);
        }
        return result;
    }

    @Override
    public boolean needsAliases(Set<String> aliases) {
        if (this.left.needsAliases(aliases)) {
            return true;
        }
        return this.rightMathExpression != null && this.rightMathExpression.needsAliases(aliases);
    }

    @Override
    public ONotInCondition copy() {
        ONotInCondition result = new ONotInCondition(-1);
        result.operator = this.operator == null ? null : this.operator.copy();
        result.left = this.left == null ? null : this.left.copy();
        result.rightMathExpression = this.rightMathExpression == null ? null : this.rightMathExpression.copy();
        result.rightStatement = this.rightStatement == null ? null : this.rightStatement.copy();
        result.rightParam = this.rightParam == null ? null : this.rightParam.copy();
        result.right = this.right == null ? null : this.right;
        return result;
    }

    @Override
    public void extractSubQueries(SubQueryCollector collector) {
        if (this.left != null) {
            this.left.extractSubQueries(collector);
        }
        if (this.rightMathExpression != null) {
            this.rightMathExpression.extractSubQueries(collector);
        } else if (this.rightStatement != null) {
            OIdentifier alias = collector.addStatement(this.rightStatement);
            this.rightMathExpression = new OBaseExpression(alias);
            this.rightStatement = null;
        }
    }

    @Override
    public boolean refersToParent() {
        if (this.left != null && this.left.refersToParent()) {
            return true;
        }
        if (this.rightStatement != null && this.rightStatement.refersToParent()) {
            return true;
        }
        return this.rightMathExpression != null && this.rightMathExpression.refersToParent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ONotInCondition that = (ONotInCondition)o;
        if (this.left != null ? !this.left.equals(that.left) : that.left != null) {
            return false;
        }
        if (this.operator != null ? !this.operator.equals(that.operator) : that.operator != null) {
            return false;
        }
        if (this.rightStatement != null ? !this.rightStatement.equals(that.rightStatement) : that.rightStatement != null) {
            return false;
        }
        if (this.right != null ? !this.right.equals(that.right) : that.right != null) {
            return false;
        }
        if (this.rightParam != null ? !this.rightParam.equals(that.rightParam) : that.rightParam != null) {
            return false;
        }
        if (this.rightMathExpression != null ? !this.rightMathExpression.equals(that.rightMathExpression) : that.rightMathExpression != null) {
            return false;
        }
        return !(this.inputFinalValue != null ? !this.inputFinalValue.equals(that.inputFinalValue) : that.inputFinalValue != null);
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
        result = 31 * result + (this.rightStatement != null ? this.rightStatement.hashCode() : 0);
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        result = 31 * result + (this.rightParam != null ? this.rightParam.hashCode() : 0);
        result = 31 * result + (this.rightMathExpression != null ? this.rightMathExpression.hashCode() : 0);
        result = 31 * result + (this.inputFinalValue != null ? this.inputFinalValue.hashCode() : 0);
        return result;
    }

    @Override
    public List<String> getMatchPatternInvolvedAliases() {
        List<String> leftX = this.left == null ? null : this.left.getMatchPatternInvolvedAliases();
        List<String> rightX = this.rightMathExpression == null ? null : this.rightMathExpression.getMatchPatternInvolvedAliases();
        ArrayList<String> result = new ArrayList<String>();
        if (leftX != null) {
            result.addAll(leftX);
        }
        if (rightX != null) {
            result.addAll(rightX);
        }
        return result.size() == 0 ? null : result;
    }

    @Override
    public boolean isCacheable() {
        if (this.left != null && !this.left.isCacheable()) {
            return false;
        }
        if (this.rightStatement != null && !this.rightStatement.executinPlanCanBeCached()) {
            return false;
        }
        return this.rightMathExpression == null || this.rightMathExpression.isCacheable();
    }
}

