/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.common.concur.resource.OSharedContainer;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorageInfo;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.cluster.OPaginatedCluster;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import com.orientechnologies.orient.core.util.OBackupable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;

public interface OStorage
extends OBackupable,
OSharedContainer,
OStorageInfo {
    public static final String CLUSTER_DEFAULT_NAME = "default";

    public void open(String var1, String var2, OContextConfiguration var3);

    public void create(OContextConfiguration var1) throws IOException;

    public boolean exists();

    public void reload();

    public void delete();

    public void close();

    public void close(boolean var1, boolean var2);

    public boolean isClosed();

    public OStorageOperationResult<ORawBuffer> readRecord(ORecordId var1, String var2, boolean var3, boolean var4, ORecordCallback<ORawBuffer> var5);

    public OStorageOperationResult<ORawBuffer> readRecordIfVersionIsNotLatest(ORecordId var1, String var2, boolean var3, int var4) throws ORecordNotFoundException;

    public OStorageOperationResult<Boolean> deleteRecord(ORecordId var1, int var2, int var3, ORecordCallback<Boolean> var4);

    public ORecordMetadata getRecordMetadata(ORID var1);

    public boolean cleanOutRecord(ORecordId var1, int var2, int var3, ORecordCallback<Boolean> var4);

    public List<ORecordOperation> commit(OTransactionInternal var1);

    public void rollback(OTransactionInternal var1);

    @Override
    public Set<String> getClusterNames();

    public Collection<? extends OCluster> getClusterInstances();

    public int addCluster(String var1, Object ... var2);

    public int addCluster(String var1, int var2);

    public boolean dropCluster(String var1);

    public String getClusterName(int var1);

    public boolean setClusterAttribute(int var1, OCluster.ATTRIBUTES var2, Object var3);

    public boolean dropCluster(int var1);

    public String getClusterNameById(int var1);

    public long getClusterRecordsSizeById(int var1);

    public long getClusterRecordsSizeByName(String var1);

    public boolean setClusterAttribute(String var1, OCluster.ATTRIBUTES var2, Object var3);

    public String getClusterRecordConflictStrategy(int var1);

    public String getClusterEncryption(int var1);

    public boolean isSystemCluster(int var1);

    public long getLastClusterPosition(int var1);

    public long getClusterNextPosition(int var1);

    public OPaginatedCluster.RECORD_STATUS getRecordStatus(ORID var1);

    public long count(int var1);

    public long count(int var1, boolean var2);

    public long count(int[] var1);

    public long count(int[] var1, boolean var2);

    public long getSize();

    public long countRecords();

    public void setDefaultClusterId(int var1);

    public int getClusterIdByName(String var1);

    public String getPhysicalClusterNameById(int var1);

    public boolean checkForRecordValidity(OPhysicalPosition var1);

    public String getName();

    public long getVersion();

    public String getCreatedAtVersion();

    public void synch();

    public Object command(OCommandRequestText var1);

    public long[] getClusterDataRange(int var1);

    public OPhysicalPosition[] higherPhysicalPositions(int var1, OPhysicalPosition var2);

    public OPhysicalPosition[] lowerPhysicalPositions(int var1, OPhysicalPosition var2);

    public OPhysicalPosition[] ceilingPhysicalPositions(int var1, OPhysicalPosition var2);

    public OPhysicalPosition[] floorPhysicalPositions(int var1, OPhysicalPosition var2);

    public STATUS getStatus();

    public String getType();

    public OStorage getUnderlying();

    public boolean isRemote();

    public boolean isDistributed();

    @Override
    public boolean isAssigningClusterIds();

    public OSBTreeCollectionManager getSBtreeCollectionManager();

    public OCurrentStorageComponentsFactory getComponentsFactory();

    public ORecordConflictStrategy getRecordConflictStrategy();

    public void setConflictStrategy(ORecordConflictStrategy var1);

    public String incrementalBackup(String var1, OCallable<Void, Void> var2) throws UnsupportedOperationException;

    public boolean supportIncremental();

    public void fullIncrementalBackup(OutputStream var1) throws UnsupportedOperationException;

    public void restoreFromIncrementalBackup(String var1);

    public void restoreFullIncrementalBackup(InputStream var1) throws UnsupportedOperationException;

    public void shutdown();

    public void setSchemaRecordId(String var1);

    public void setDateFormat(String var1);

    public void setTimeZone(TimeZone var1);

    public void setLocaleLanguage(String var1);

    public void setCharset(String var1);

    public void setIndexMgrRecordId(String var1);

    public void setDateTimeFormat(String var1);

    public void setLocaleCountry(String var1);

    public void setClusterSelection(String var1);

    public void setMinimumClusters(int var1);

    public void setValidation(boolean var1);

    public void removeProperty(String var1);

    public void setProperty(String var1, String var2);

    public void setRecordSerializer(String var1, int var2);

    public void clearProperties();

    public static enum LOCKING_STRATEGY {
        NONE,
        DEFAULT,
        SHARED_LOCK,
        EXCLUSIVE_LOCK,
        KEEP_SHARED_LOCK,
        KEEP_EXCLUSIVE_LOCK;

    }

    public static enum STATUS {
        CLOSED,
        OPEN,
        CLOSING,
        OPENING;

    }
}

