/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cache.OCachePointer;
import com.orientechnologies.orient.core.storage.cache.chm.LRUList;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public final class OCacheEntryImpl
implements OCacheEntry {
    private static final AtomicIntegerFieldUpdater<OCacheEntryImpl> USAGES_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(OCacheEntryImpl.class, "usagesCount");
    private static final AtomicIntegerFieldUpdater<OCacheEntryImpl> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(OCacheEntryImpl.class, "state");
    private static final int FROZEN = -1;
    private static final int DEAD = -2;
    private OCachePointer dataPointer;
    private final long fileId;
    private final int pageIndex;
    private volatile int usagesCount;
    private volatile int state;
    private OCacheEntry next;
    private OCacheEntry prev;
    private LRUList container;
    private boolean allocatedPage;
    private List<PageOperationRecord> pageOperationRecords;
    private int hash;
    private final boolean insideCache;

    public OCacheEntryImpl(long fileId, int pageIndex, OCachePointer dataPointer, boolean insideCache) {
        if (fileId < 0L) {
            throw new IllegalStateException("File id has invalid value " + fileId);
        }
        if (pageIndex < 0) {
            throw new IllegalStateException("Page index has invalid value " + pageIndex);
        }
        this.fileId = fileId;
        this.pageIndex = pageIndex;
        this.dataPointer = dataPointer;
        this.insideCache = insideCache;
    }

    @Override
    public List<PageOperationRecord> getPageOperations() {
        if (this.pageOperationRecords == null) {
            return Collections.emptyList();
        }
        return this.pageOperationRecords;
    }

    @Override
    public void clearPageOperations() {
        this.pageOperationRecords = null;
    }

    @Override
    public void addPageOperationRecord(PageOperationRecord pageOperationRecord) {
        if (this.pageOperationRecords == null) {
            this.pageOperationRecords = new ArrayList<PageOperationRecord>();
        }
        this.pageOperationRecords.add(pageOperationRecord);
    }

    @Override
    public boolean isNewlyAllocatedPage() {
        return this.allocatedPage;
    }

    @Override
    public void markAllocated() {
        this.allocatedPage = true;
    }

    @Override
    public void clearAllocationFlag() {
        this.allocatedPage = false;
    }

    @Override
    public OCachePointer getCachePointer() {
        return this.dataPointer;
    }

    @Override
    public void clearCachePointer() {
        this.dataPointer = null;
    }

    @Override
    public void setCachePointer(OCachePointer cachePointer) {
        this.dataPointer = cachePointer;
    }

    @Override
    public long getFileId() {
        return this.fileId;
    }

    @Override
    public int getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public void acquireExclusiveLock() {
        this.dataPointer.acquireExclusiveLock();
    }

    @Override
    public void releaseExclusiveLock() {
        this.dataPointer.releaseExclusiveLock();
    }

    @Override
    public void acquireSharedLock() {
        this.dataPointer.acquireSharedLock();
    }

    @Override
    public void releaseSharedLock() {
        this.dataPointer.releaseSharedLock();
    }

    @Override
    public int getUsagesCount() {
        return USAGES_COUNT_UPDATER.get(this);
    }

    @Override
    public void incrementUsages() {
        USAGES_COUNT_UPDATER.incrementAndGet(this);
    }

    @Override
    public boolean isLockAcquiredByCurrentThread() {
        return this.dataPointer.isLockAcquiredByCurrentThread();
    }

    @Override
    public void decrementUsages() {
        USAGES_COUNT_UPDATER.decrementAndGet(this);
    }

    @Override
    public OWALChanges getChanges() {
        return null;
    }

    @Override
    public OLogSequenceNumber getEndLSN() {
        return this.dataPointer.getEndLSN();
    }

    @Override
    public void setEndLSN(OLogSequenceNumber endLSN) {
        this.dataPointer.setEndLSN(endLSN);
    }

    @Override
    public boolean acquireEntry() {
        int state = STATE_UPDATER.get(this);
        while (state >= 0) {
            if (STATE_UPDATER.compareAndSet(this, state, state + 1)) {
                return true;
            }
            state = STATE_UPDATER.get(this);
        }
        return false;
    }

    @Override
    public void releaseEntry() {
        int state = STATE_UPDATER.get(this);
        while (true) {
            if (state <= 0) {
                throw new IllegalStateException("Cache entry " + this.fileId + ":" + this.pageIndex + " has invalid state " + state);
            }
            if (STATE_UPDATER.compareAndSet(this, state, state - 1)) {
                return;
            }
            state = STATE_UPDATER.get(this);
        }
    }

    @Override
    public boolean isReleased() {
        return STATE_UPDATER.get(this) == 0;
    }

    @Override
    public boolean isAlive() {
        return STATE_UPDATER.get(this) >= 0;
    }

    @Override
    public boolean freeze() {
        int state = STATE_UPDATER.get(this);
        while (state == 0) {
            if (STATE_UPDATER.compareAndSet(this, state, -1)) {
                return true;
            }
            state = STATE_UPDATER.get(this);
        }
        return false;
    }

    @Override
    public boolean isFrozen() {
        return STATE_UPDATER.get(this) == -1;
    }

    @Override
    public void makeDead() {
        int state = STATE_UPDATER.get(this);
        while (state == -1) {
            if (STATE_UPDATER.compareAndSet(this, state, -2)) {
                return;
            }
            state = STATE_UPDATER.get(this);
        }
        throw new IllegalStateException("Cache entry " + this.fileId + ":" + this.pageIndex + " has invalid state " + state);
    }

    @Override
    public boolean isDead() {
        return STATE_UPDATER.get(this) == -2;
    }

    @Override
    public OCacheEntry getNext() {
        return this.next;
    }

    @Override
    public OCacheEntry getPrev() {
        return this.prev;
    }

    @Override
    public void setPrev(OCacheEntry prev) {
        this.prev = prev;
    }

    @Override
    public void setNext(OCacheEntry next) {
        this.next = next;
    }

    @Override
    public void setContainer(LRUList lruList) {
        this.container = lruList;
    }

    @Override
    public LRUList getContainer() {
        return this.container;
    }

    @Override
    public boolean insideCache() {
        return this.insideCache;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCacheEntryImpl that = (OCacheEntryImpl)o;
        if (this.fileId != that.fileId) {
            return false;
        }
        return this.pageIndex == that.pageIndex;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int result = (int)(this.fileId ^ this.fileId >>> 32);
        this.hash = result = 31 * result + this.pageIndex;
        return this.hash;
    }

    public String toString() {
        return "OCacheEntryImpl{dataPointer=" + this.dataPointer + ", fileId=" + this.fileId + ", pageIndex=" + this.pageIndex + ", usagesCount=" + this.usagesCount + '}';
    }
}

