/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache.local.doublewritelog;

import com.orientechnologies.common.directmemory.OByteBufferPool;
import com.orientechnologies.common.directmemory.ODirectMemoryAllocator;
import com.orientechnologies.common.directmemory.OPointer;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.cache.local.doublewritelog.DoubleWriteLog;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import net.jpountz.xxhash.XXHash64;
import net.jpountz.xxhash.XXHashFactory;

public class DoubleWriteLogGL
implements DoubleWriteLog {
    public static final String EXTENSION = ".dwl";
    private static final ODirectMemoryAllocator ALLOCATOR = ODirectMemoryAllocator.instance();
    static final int DEFAULT_BLOCK_SIZE = 4096;
    private static final int XX_HASH_OFFSET = 0;
    private static final int XX_HASH_LEN = 8;
    private static final int FILE_ID_OFFSET = 8;
    private static final int FILE_ID_LEN = 4;
    private static final int START_PAGE_INDEX_OFFSET = 12;
    private static final int START_PAGE_INDEX_LEN = 4;
    private static final int CHUNK_SIZE_OFFSET = 16;
    private static final int CHUNK_SIZE_LEN = 4;
    private static final int COMPRESSED_SIZE_OFFSET = 20;
    private static final int COMPRESSED_SIZE_LEN = 4;
    private static final int METADATA_SIZE = 24;
    private static final long XX_HASH_SEED = 215867121526L;
    private static final XXHash64 XX_HASH;
    private Path storagePath;
    private String storageName;
    private int pageSize;
    private FileChannel currentFile;
    private long currentSegment;
    private long currentLogSize;
    private final long maxSegSize;
    private int blockSize;
    private static final LZ4Compressor LZ_4_COMPRESSOR;
    private static final LZ4FastDecompressor LZ_4_DECOMPRESSOR;
    private List<Long> tailSegments;
    private volatile boolean restoreMode;
    private int checkpointCounter;
    private Map<ORawPair<Integer, Integer>, ORawPair<Long, Long>> pageMap;
    private final Object mutex = new Object();

    public DoubleWriteLogGL(long maxSegSize) {
        this.maxSegSize = maxSegSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(String storageName, Path storagePath, int pageSize) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            Optional<Path> latestPath;
            this.pageSize = pageSize;
            this.storagePath = storagePath;
            this.storageName = storageName;
            this.tailSegments = new ArrayList<Long>();
            this.pageMap = new HashMap<ORawPair<Integer, Integer>, ORawPair<Long, Long>>();
            try (Stream<Path> stream = Files.list(storagePath);){
                latestPath = stream.filter(DoubleWriteLogGL::fileFilter).peek(path -> this.tailSegments.add(this.extractSegmentId(path.getFileName().toString()))).min((pathOne, pathTwo) -> {
                    long indexOne = this.extractSegmentId(pathOne.getFileName().toString());
                    long indexTwo = this.extractSegmentId(pathTwo.getFileName().toString());
                    return -Long.compare(indexOne, indexTwo);
                });
            }
            this.currentSegment = latestPath.map(path -> this.extractSegmentId(path.getFileName().toString()) + 1L).orElse(0L);
            this.currentFile = this.createLogFile();
            this.currentLogSize = this.calculateLogSize();
            this.blockSize = OIOUtils.calculateBlockSize(storagePath.toAbsolutePath().toString());
            if (this.blockSize == -1) {
                this.blockSize = 4096;
            }
            OLogManager.instance().info((Object)this, "DWL:%s: block size = %d bytes, maximum segment size = %d MB", storageName, this.blockSize, this.maxSegSize / 1024L / 1024L);
        }
    }

    private long extractSegmentId(String segmentName) {
        int len = this.storageName.length();
        String index = segmentName.substring(len + 1);
        index = index.substring(0, index.length() - EXTENSION.length());
        return Long.parseLong(index);
    }

    private FileChannel createLogFile() throws IOException {
        Path currentFilePath = this.storagePath.resolve(this.generateSegmentsName(this.currentSegment));
        return FileChannel.open(currentFilePath, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW, StandardOpenOption.SYNC);
    }

    private String generateSegmentsName(long id) {
        return this.storageName + "_" + id + EXTENSION;
    }

    private static boolean fileFilter(Path path) {
        return path.toString().endsWith(EXTENSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(ByteBuffer[] buffers, int[] fileIds, int[] pageIndexes) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            assert (this.checkpointCounter >= 0);
            if (this.checkpointCounter == 0 && this.currentFile.position() >= this.maxSegSize) {
                this.addNewSegment();
            }
            int sizeToAllocate = 0;
            for (ByteBuffer byteBuffer : buffers) {
                sizeToAllocate += LZ_4_COMPRESSOR.maxCompressedLength(byteBuffer.limit());
            }
            OPointer pageContainer = ALLOCATOR.allocate(sizeToAllocate += buffers.length * 24, -1, false);
            try {
                ByteBuffer containerBuffer = pageContainer.getNativeByteBuffer();
                assert (containerBuffer.position() == 0);
                for (int i = 0; i < buffers.length; ++i) {
                    ByteBuffer buffer = buffers[i];
                    buffer.rewind();
                    int maxCompressedLength = LZ_4_COMPRESSOR.maxCompressedLength(buffer.limit());
                    OPointer compressedPointer = ODirectMemoryAllocator.instance().allocate(maxCompressedLength, -1, false);
                    try {
                        ByteBuffer compressedBuffer = compressedPointer.getNativeByteBuffer();
                        LZ_4_COMPRESSOR.compress(buffer, compressedBuffer);
                        int compressedSize = compressedBuffer.position();
                        compressedBuffer.rewind();
                        compressedBuffer.limit(compressedSize);
                        int xxHashPosition = containerBuffer.position();
                        containerBuffer.position(xxHashPosition + 8);
                        containerBuffer.putInt(fileIds[i]);
                        containerBuffer.putInt(pageIndexes[i]);
                        containerBuffer.putInt(buffer.limit() / this.pageSize);
                        containerBuffer.putInt(compressedSize);
                        containerBuffer.put(compressedBuffer);
                        containerBuffer.putLong(xxHashPosition, XX_HASH.hash(containerBuffer, xxHashPosition + 8, containerBuffer.position() - xxHashPosition - 8, 215867121526L));
                        continue;
                    }
                    finally {
                        ALLOCATOR.deallocate(compressedPointer);
                    }
                }
                containerBuffer.limit(containerBuffer.position());
                containerBuffer.rewind();
                long filePosition = this.currentFile.position();
                long bytesWritten = OIOUtils.writeByteBuffer(containerBuffer, this.currentFile, filePosition);
                bytesWritten = (bytesWritten + (long)this.blockSize - 1L) / (long)this.blockSize * (long)this.blockSize;
                this.currentFile.position(bytesWritten + filePosition);
                this.currentLogSize += bytesWritten;
            }
            finally {
                ALLOCATOR.deallocate(pageContainer);
            }
            return !this.restoreMode && this.currentLogSize >= this.maxSegSize && !this.tailSegments.isEmpty();
        }
    }

    private void addNewSegment() throws IOException {
        this.currentFile.close();
        this.tailSegments.add(this.currentSegment);
        ++this.currentSegment;
        this.currentFile = this.createLogFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.restoreMode) {
                return;
            }
            this.tailSegments.stream().map(this::generateSegmentsName).forEach(segment -> {
                try {
                    Path segmentPath = this.storagePath.resolve((String)segment);
                    Files.delete(segmentPath);
                }
                catch (IOException e) {
                    OLogManager.instance().errorNoDb(this, "Can not delete segment of double write log - %d in storage %s", e, segment, this.storageName);
                }
            });
            this.currentLogSize = this.calculateLogSize();
            this.tailSegments.clear();
        }
    }

    private long calculateLogSize() throws IOException {
        try (Stream<Path> stream = Files.list(this.storagePath);){
            long l = stream.filter(DoubleWriteLogGL::fileFilter).mapToLong(path -> {
                try {
                    return Files.size(path);
                }
                catch (IOException e) {
                    throw OException.wrapException(new OStorageException("Can not calculate size of file " + path.toAbsolutePath()), e);
                }
            }).sum();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPointer loadPage(int fileId, int pageIndex, OByteBufferPool bufferPool) throws IOException {
        if (!this.restoreMode) {
            return null;
        }
        Object object = this.mutex;
        synchronized (object) {
            block29: {
                if (!this.restoreMode) {
                    return null;
                }
                ORawPair<Long, Long> segmentPosition = this.pageMap.get(new ORawPair<Integer, Integer>(fileId, pageIndex));
                if (segmentPosition == null) {
                    return null;
                }
                String segmentName = this.generateSegmentsName((Long)segmentPosition.first);
                Path segmentPath = this.storagePath.resolve(segmentName);
                if (Files.exists(segmentPath, new LinkOption[0])) {
                    OPointer oPointer;
                    try (FileChannel channel = FileChannel.open(segmentPath, StandardOpenOption.READ);){
                        long channelSize = channel.size();
                        if (channelSize - (Long)segmentPosition.second <= 24L) break block29;
                        ByteBuffer metadataBuffer = ByteBuffer.allocate(24).order(ByteOrder.nativeOrder());
                        OIOUtils.readByteBuffer(metadataBuffer, channel, (Long)segmentPosition.second, true);
                        metadataBuffer.rewind();
                        long xxHash = metadataBuffer.getLong();
                        int storedFileId = metadataBuffer.getInt();
                        int storedPageIndex = metadataBuffer.getInt();
                        int pages = metadataBuffer.getInt();
                        int compressedLen = metadataBuffer.getInt();
                        if (pages < 0 || storedFileId != fileId || pageIndex < storedPageIndex || pageIndex >= storedPageIndex + pages || channelSize - (Long)segmentPosition.second - 24L < (long)compressedLen) break block29;
                        ByteBuffer buffer = ByteBuffer.allocate(compressedLen + 24).order(ByteOrder.nativeOrder());
                        OIOUtils.readByteBuffer(buffer, channel, (Long)segmentPosition.second, true);
                        buffer.rewind();
                        if (XX_HASH.hash(buffer, 8, buffer.capacity() - 8, 215867121526L) != xxHash) {
                            OPointer oPointer2 = null;
                            return oPointer2;
                        }
                        ByteBuffer pagesBuffer = ByteBuffer.allocate(pages * this.pageSize).order(ByteOrder.nativeOrder());
                        LZ_4_DECOMPRESSOR.decompress(buffer, 24, pagesBuffer, 0, pagesBuffer.capacity());
                        int pagePosition = (pageIndex - storedPageIndex) * this.pageSize;
                        pagesBuffer.position(pagePosition);
                        pagesBuffer.limit(pagePosition + this.pageSize);
                        OPointer pointer = bufferPool.acquireDirect(false);
                        ByteBuffer pageBuffer = pointer.getNativeByteBuffer();
                        assert (pageBuffer.position() == 0);
                        pageBuffer.put(pagesBuffer);
                        pageBuffer.rewind();
                        oPointer = pointer;
                    }
                    return oPointer;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void restoreModeOn() throws IOException {
        var1_1 = this.mutex;
        synchronized (var1_1) {
            if (this.restoreMode) {
                return;
            }
            this.pageMap.clear();
            stream = Files.list(this.storagePath);
            var4_3 = null;
            try {
                segments = (Path[])stream.filter((Predicate<Path>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, fileFilter(java.nio.file.Path ), (Ljava/nio/file/Path;)Z)()).sorted((Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$restoreModeOn$5(java.nio.file.Path java.nio.file.Path ), (Ljava/nio/file/Path;Ljava/nio/file/Path;)I)((DoubleWriteLogGL)this)).toArray((IntFunction<Path[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$restoreModeOn$6(int ), (I)[Ljava/nio/file/Path;)());
            }
            catch (Throwable var5_7) {
                var4_3 = var5_7;
                throw var5_7;
            }
            finally {
                if (stream != null) {
                    if (var4_3 != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable var5_6) {
                            var4_3.addSuppressed(var5_6);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
            var3_2 = segments;
            var4_4 = var3_2.length;
            var5_8 = 0;
            while (true) {
                block50: {
                    block53: {
                        block49: {
                            block51: {
                                block52: {
                                    if (var5_8 >= var4_4) {
                                        this.restoreMode = true;
                                        return;
                                    }
                                    segment = var3_2[var5_8];
                                    channel = FileChannel.open(segment, new OpenOption[]{StandardOpenOption.READ});
                                    var8_13 = null;
                                    try {
                                        position = 0L;
                                        fileSize = channel.size();
lbl39:
                                        // 2 sources

                                        while (fileSize - position > 24L) {
                                            metadataBuffer = ByteBuffer.allocate(24).order(ByteOrder.nativeOrder());
                                            OIOUtils.readByteBuffer(metadataBuffer, channel, position, true);
                                            metadataBuffer.rewind();
                                            xxHash = metadataBuffer.getLong();
                                            fileId = metadataBuffer.getInt();
                                            pageIndex = metadataBuffer.getInt();
                                            pages = metadataBuffer.getInt();
                                            compressedLen = metadataBuffer.getInt();
                                            if (fileId < 0 || pages < 0 || pageIndex < 0 || compressedLen < 0 || position + 24L + (long)compressedLen > fileSize) break block49;
                                            buffer = ByteBuffer.allocate(24 + compressedLen).order(ByteOrder.nativeOrder());
                                            OIOUtils.readByteBuffer(buffer, channel, position, true);
                                            buffer.rewind();
                                            if (DoubleWriteLogGL.XX_HASH.hash(buffer, 8, buffer.capacity() - 8, 215867121526L) != xxHash) {
                                                OLogManager.instance().warnNoDb(this, "DWL Segment " + segment + " is broken and will not be used during restore", new Object[0]);
                                                if (channel == null) break block50;
                                                if (var8_13 == null) break block51;
                                                break block52;
                                            }
                                            ** GOTO lbl-1000
                                        }
                                        break block53;
                                    }
                                    catch (Throwable var9_16) {
                                        try {
                                            var8_13 = var9_16;
                                            throw var9_16;
                                        }
                                        catch (Throwable var24_31) {
                                            if (channel == null) throw var24_31;
                                            if (var8_13 == null) {
                                                channel.close();
                                                throw var24_31;
                                            }
                                            try {
                                                channel.close();
                                                throw var24_31;
                                            }
                                            catch (Throwable var25_32) {
                                                var8_13.addSuppressed(var25_32);
                                                throw var24_31;
                                            }
                                        }
                                    }
                                }
                                try {
                                    channel.close();
                                }
                                catch (Throwable var21_27) {
                                    var8_13.addSuppressed(var21_27);
                                }
                                break block50;
                            }
                            channel.close();
                            break block50;
                        }
                        if (channel != null) {
                            if (var8_13 != null) {
                                try {
                                    channel.close();
                                }
                                catch (Throwable buffer) {
                                    var8_13.addSuppressed(buffer);
                                }
                                break block50;
                            } else {
                                channel.close();
                            }
                        }
                        break block50;
lbl-1000:
                        // 1 sources

                        {
                            try {
                                segmentId = this.extractSegmentId(segment.getFileName().toString());
                            }
                            catch (NumberFormatException e) {
                                if (channel == null) break block50;
                                if (var8_13 != null) {
                                    try {
                                        channel.close();
                                    }
                                    catch (Throwable var23_30) {
                                        var8_13.addSuppressed(var23_30);
                                    }
                                    break block50;
                                } else {
                                    channel.close();
                                }
                                break block50;
                            }
                        }
                        {
                            for (i = 0; i < pages; ++i) {
                                this.pageMap.put(new ORawPair<Integer, Integer>(fileId, pageIndex + i), new ORawPair<Long, Long>(segmentId, position));
                            }
                            position += (long)((24 + compressedLen + this.blockSize - -1) / this.blockSize * this.blockSize);
                            ** GOTO lbl39
                        }
                    }
                    if (channel != null) {
                        if (var8_13 != null) {
                            try {
                                channel.close();
                            }
                            catch (Throwable var9_15) {
                                var8_13.addSuppressed(var9_15);
                            }
                        } else {
                            channel.close();
                        }
                    }
                }
                ++var5_8;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreModeOff() {
        Object object = this.mutex;
        synchronized (object) {
            this.pageMap = new HashMap<ORawPair<Integer, Integer>, ORawPair<Long, Long>>();
            this.restoreMode = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            this.currentFile.close();
            try (Stream<Path> stream = Files.list(this.storagePath);){
                stream.filter(DoubleWriteLogGL::fileFilter).forEach(path -> {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException e) {
                        throw new OStorageException("Can not delete file " + path.toString() + " in storage " + this.storageName);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startCheckpoint() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            this.addNewSegment();
            ++this.checkpointCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endCheckpoint() {
        Object object = this.mutex;
        synchronized (object) {
            --this.checkpointCounter;
        }
    }

    private static /* synthetic */ Path[] lambda$restoreModeOn$6(int x$0) {
        return new Path[x$0];
    }

    private /* synthetic */ int lambda$restoreModeOn$5(Path pathOne, Path pathTwo) {
        long indexOne = this.extractSegmentId(pathOne.getFileName().toString());
        long indexTwo = this.extractSegmentId(pathTwo.getFileName().toString());
        return Long.compare(indexOne, indexTwo);
    }

    static {
        Object factory = XXHashFactory.fastestInstance();
        XX_HASH = ((XXHashFactory)factory).hash64();
        factory = LZ4Factory.fastestInstance();
        LZ_4_COMPRESSOR = ((LZ4Factory)factory).fastCompressor();
        LZ_4_DECOMPRESSOR = ((LZ4Factory)factory).fastDecompressor();
    }
}

