/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cluster;

import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.clusterpage.ClusterPageAppendRecordPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.clusterpage.ClusterPageDeleteRecordPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.clusterpage.ClusterPageInitPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.clusterpage.ClusterPageReplaceRecordPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.clusterpage.ClusterPageSetNextPagePO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.clusterpage.ClusterPageSetPrevPagePO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.clusterpage.ClusterPageSetRecordLongValuePO;
import java.util.Set;

public final class OClusterPage
extends ODurablePage {
    private static final int VERSION_SIZE = 4;
    private static final int NEXT_PAGE_OFFSET = 28;
    private static final int PREV_PAGE_OFFSET = 36;
    private static final int FREELIST_HEADER_OFFSET = 44;
    private static final int FREE_POSITION_OFFSET = 48;
    private static final int FREE_SPACE_COUNTER_OFFSET = 52;
    private static final int ENTRIES_COUNT_OFFSET = 56;
    private static final int PAGE_INDEXES_LENGTH_OFFSET = 60;
    private static final int PAGE_INDEXES_OFFSET = 64;
    static final int INDEX_ITEM_SIZE = 8;
    private static final int MARKED_AS_DELETED_FLAG = 65536;
    private static final int POSITION_MASK = 65535;
    public static final int PAGE_SIZE = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024;
    static final int MAX_ENTRY_SIZE = PAGE_SIZE - 64 - 8;
    public static final int MAX_RECORD_SIZE = MAX_ENTRY_SIZE - 12;
    private static final int ENTRY_KIND_HOLE = -1;
    private static final int ENTRY_KIND_UNKNOWN = 0;
    private static final int ENTRY_KIND_DATA = 1;

    public OClusterPage(OCacheEntry cacheEntry) {
        super(cacheEntry);
    }

    public void init() {
        this.setLongValue(28, -1L);
        this.setLongValue(36, -1L);
        this.setIntValue(44, 0);
        this.setIntValue(60, 0);
        this.setIntValue(56, 0);
        this.setIntValue(48, PAGE_SIZE);
        this.setIntValue(52, PAGE_SIZE - 64);
        this.addPageOperation(new ClusterPageInitPO());
    }

    public int appendRecord(int recordVersion, byte[] record, int requestedPosition, Set<Integer> bookedRecordPositions) {
        boolean allocatedFromFreeList;
        int entryIndex;
        int freePosition = this.getIntValue(48);
        int indexesLength = this.getIntValue(60);
        int lastEntryIndexPosition = 64 + indexesLength * 8;
        int entrySize = record.length + 12;
        int freeListHeader = this.getIntValue(44);
        if (!this.checkSpace(entrySize)) {
            return -1;
        }
        if (freePosition - entrySize < lastEntryIndexPosition + 8) {
            this.doDefragmentation();
        }
        freePosition = this.getIntValue(48);
        freePosition -= entrySize;
        if (requestedPosition < 0) {
            ORawPair<Integer, Boolean> entry = this.findFirstEmptySlot(recordVersion, freePosition, indexesLength, entrySize, freeListHeader, bookedRecordPositions);
            entryIndex = (Integer)entry.first;
            allocatedFromFreeList = (Boolean)entry.second;
        } else {
            allocatedFromFreeList = this.insertIntoRequestedSlot(recordVersion, freePosition, entrySize, requestedPosition, freeListHeader);
            entryIndex = requestedPosition;
        }
        int entryPosition = freePosition;
        this.setIntValue(entryPosition, entrySize);
        this.setIntValue(entryPosition += 4, entryIndex);
        this.setIntValue(entryPosition += 4, record.length);
        this.setBinaryValue(entryPosition += 4, record);
        this.setIntValue(48, freePosition);
        this.incrementEntriesCount();
        if (entryIndex >= 0) {
            this.addPageOperation(new ClusterPageAppendRecordPO(recordVersion, record, requestedPosition, entryIndex, allocatedFromFreeList));
        }
        return entryIndex;
    }

    private boolean insertIntoRequestedSlot(int recordVersion, int freePosition, int entrySize, int requestedPosition, int freeListHeader) {
        boolean allocatedFromFreeList = false;
        int indexesLength = this.getIntValue(60);
        if (indexesLength == requestedPosition) {
            this.setIntValue(60, indexesLength + 1);
            this.setIntValue(52, this.getFreeSpace() - entrySize - 8);
            int entryIndexPosition = 64 + requestedPosition * 8;
            this.setIntValue(entryIndexPosition, freePosition);
            this.setIntValue(entryIndexPosition + 4, recordVersion);
        } else if (indexesLength > requestedPosition) {
            int entryIndexPosition;
            block9: {
                entryIndexPosition = 64 + 8 * requestedPosition;
                int entryPointer = this.getIntValue(entryIndexPosition);
                if ((entryPointer & 0x10000) == 0) {
                    throw new OStorageException("Can not insert record inside of already occupied slot, record position = " + requestedPosition);
                }
                int prevFreeListItem = -1;
                int currentFreeListItem = freeListHeader - 1;
                while (true) {
                    int tombstonePointer = this.getIntValue(64 + 8 * currentFreeListItem);
                    int nextEntryPosition = tombstonePointer & 0xFFFF;
                    if (currentFreeListItem == requestedPosition) {
                        if (prevFreeListItem >= 0) {
                            this.setIntValue(64 + 8 * prevFreeListItem, tombstonePointer);
                        } else {
                            this.setIntValue(44, nextEntryPosition);
                        }
                        break block9;
                    }
                    if (nextEntryPosition <= 0) break;
                    prevFreeListItem = currentFreeListItem;
                    currentFreeListItem = nextEntryPosition - 1;
                }
                throw new OStorageException("Record position " + requestedPosition + " marked as deleted but can not be found in the list of deleted records");
            }
            this.setIntValue(52, this.getFreeSpace() - entrySize);
            this.setIntValue(entryIndexPosition, freePosition);
            this.setIntValue(entryIndexPosition + 4, recordVersion);
            allocatedFromFreeList = true;
        } else {
            throw new OStorageException("Can not insert record out side of list of already inserted records, record position = " + requestedPosition);
        }
        return allocatedFromFreeList;
    }

    private ORawPair<Integer, Boolean> findFirstEmptySlot(int recordVersion, int freePosition, int indexesLength, int entrySize, int freeListHeader, Set<Integer> bookedRecordPositions) {
        int entryIndex;
        boolean allocatedFromFreeList = false;
        if (freeListHeader > 0) {
            entryIndex = -1;
            int prevFreeListItem = -1;
            int currentFreeListItem = freeListHeader - 1;
            while (true) {
                int tombstonePointer = this.getIntValue(64 + 8 * currentFreeListItem);
                int nextEntryPosition = tombstonePointer & 0xFFFF;
                if (!bookedRecordPositions.contains(currentFreeListItem)) {
                    if (prevFreeListItem >= 0) {
                        this.setIntValue(64 + 8 * prevFreeListItem, tombstonePointer);
                    } else {
                        this.setIntValue(44, nextEntryPosition);
                    }
                    entryIndex = currentFreeListItem;
                    break;
                }
                if (nextEntryPosition <= 0) break;
                prevFreeListItem = currentFreeListItem;
                currentFreeListItem = nextEntryPosition - 1;
            }
            if (entryIndex >= 0) {
                this.setIntValue(52, this.getFreeSpace() - entrySize);
                int entryIndexPosition = 64 + entryIndex * 8;
                this.setIntValue(entryIndexPosition, freePosition);
                this.setIntValue(entryIndexPosition + 4, recordVersion);
                allocatedFromFreeList = true;
            } else {
                entryIndex = this.appendEntry(recordVersion, freePosition, indexesLength, entrySize);
            }
        } else {
            entryIndex = this.appendEntry(recordVersion, freePosition, indexesLength, entrySize);
        }
        return new ORawPair<Integer, Boolean>(entryIndex, allocatedFromFreeList);
    }

    private int appendEntry(int recordVersion, int freePosition, int indexesLength, int entrySize) {
        int entryIndex = indexesLength;
        this.setIntValue(60, indexesLength + 1);
        this.setIntValue(52, this.getFreeSpace() - entrySize - 8);
        int entryIndexPosition = 64 + entryIndex * 8;
        this.setIntValue(entryIndexPosition, freePosition);
        this.setIntValue(entryIndexPosition + 4, recordVersion);
        return entryIndex;
    }

    public byte[] replaceRecord(int entryIndex, byte[] record, int recordVersion) {
        int entryPointer;
        int entryPosition;
        int recordSize;
        int entryIndexPosition = 64 + entryIndex * 8;
        int oldRecordVersion = this.getIntValue(entryIndexPosition + 4);
        if (recordVersion != -1) {
            this.setIntValue(entryIndexPosition + 4, recordVersion);
        }
        if ((recordSize = this.getIntValue(entryPosition = (entryPointer = this.getIntValue(entryIndexPosition)) & 0xFFFF) - 12) != record.length) {
            throw new IllegalStateException("Length of passed in and stored records are different. Stored record length = " + recordSize + ", passed record length = " + record.length);
        }
        byte[] oldRecord = this.getBinaryValue(entryPointer + 12, recordSize);
        this.setIntValue(entryPointer + 8, record.length);
        this.setBinaryValue(entryPointer + 12, record);
        this.addPageOperation(new ClusterPageReplaceRecordPO(entryIndex, recordVersion, record, oldRecordVersion, oldRecord));
        return oldRecord;
    }

    public int getRecordVersion(int position) {
        int indexesLength = this.getIntValue(60);
        if (position >= indexesLength) {
            return -1;
        }
        int entryIndexPosition = 64 + position * 8;
        int entryPointer = this.getIntValue(entryIndexPosition);
        if ((entryPointer & 0x10000) != 0) {
            return -1;
        }
        return this.getIntValue(entryIndexPosition + 4);
    }

    public boolean isEmpty() {
        return this.getFreeSpace() == PAGE_SIZE - 64;
    }

    private boolean checkSpace(int entrySize) {
        return this.getFreeSpace() - entrySize >= 0;
    }

    public byte[] deleteRecord(int position, boolean preserveFreeListPointer) {
        int indexesLength = this.getIntValue(60);
        if (position >= indexesLength) {
            return null;
        }
        int entryIndexPosition = 64 + 8 * position;
        int entryPointer = this.getIntValue(entryIndexPosition);
        if ((entryPointer & 0x10000) != 0) {
            return null;
        }
        int oldVersion = this.getIntValue(entryIndexPosition + 4);
        int entryPosition = entryPointer & 0xFFFF;
        if (preserveFreeListPointer) {
            int freeListHeader = this.getIntValue(44);
            if (freeListHeader <= 0) {
                this.setIntValue(entryIndexPosition, 65536);
            } else {
                this.setIntValue(entryIndexPosition, freeListHeader | 0x10000);
            }
            this.setIntValue(44, position + 1);
        } else {
            if (position != indexesLength - 1) {
                throw new IllegalStateException("Only last position can be removed without keeping it in free list");
            }
            this.setIntValue(60, indexesLength - 1);
            this.setIntValue(52, this.getFreeSpace() + 8);
        }
        int entrySize = this.getIntValue(entryPosition);
        assert (entrySize > 0);
        this.setIntValue(entryPosition, -entrySize);
        this.setIntValue(52, this.getFreeSpace() + entrySize);
        this.decrementEntriesCount();
        byte[] oldRecord = this.getBinaryValue(entryPosition + 12, entrySize - 12);
        this.addPageOperation(new ClusterPageDeleteRecordPO(position, oldVersion, oldRecord, preserveFreeListPointer));
        return oldRecord;
    }

    public boolean isDeleted(int position) {
        int indexesLength = this.getIntValue(60);
        if (position >= indexesLength) {
            return true;
        }
        int entryIndexPosition = 64 + 8 * position;
        int entryPointer = this.getIntValue(entryIndexPosition);
        return (entryPointer & 0x10000) != 0;
    }

    public int getRecordSize(int position) {
        int indexesLength = this.getIntValue(60);
        if (position >= indexesLength) {
            return -1;
        }
        int entryIndexPosition = 64 + 8 * position;
        int entryPointer = this.getIntValue(entryIndexPosition);
        if ((entryPointer & 0x10000) != 0) {
            return -1;
        }
        int entryPosition = entryPointer & 0xFFFF;
        return this.getIntValue(entryPosition + 8);
    }

    int findFirstDeletedRecord(int position) {
        int indexesLength = this.getIntValue(60);
        for (int i = position; i < indexesLength; ++i) {
            int entryIndexPosition = 64 + 8 * i;
            int entryPointer = this.getIntValue(entryIndexPosition);
            if ((entryPointer & 0x10000) == 0) continue;
            return i;
        }
        return -1;
    }

    int findFirstRecord(int position) {
        int indexesLength = this.getIntValue(60);
        for (int i = position; i < indexesLength; ++i) {
            int entryIndexPosition = 64 + 8 * i;
            int entryPointer = this.getIntValue(entryIndexPosition);
            if ((entryPointer & 0x10000) != 0) continue;
            return i;
        }
        return -1;
    }

    int findLastRecord(int position) {
        int endIndex;
        int indexesLength = this.getIntValue(60);
        for (int i = endIndex = Math.min(indexesLength - 1, position); i >= 0; --i) {
            int entryIndexPosition = 64 + 8 * i;
            int entryPointer = this.getIntValue(entryIndexPosition);
            if ((entryPointer & 0x10000) != 0) continue;
            return i;
        }
        return -1;
    }

    public final int getFreeSpace() {
        return this.getIntValue(52);
    }

    public int getMaxRecordSize() {
        int maxEntrySize = this.getFreeSpace() - 8;
        int result = maxEntrySize - 12;
        return Math.max(result, 0);
    }

    public final int getRecordsCount() {
        return this.getIntValue(56);
    }

    public long getNextPage() {
        return this.getLongValue(28);
    }

    public void setNextPage(long nextPage) {
        int oldNextPage = (int)this.getLongValue(28);
        this.setLongValue(28, nextPage);
        this.addPageOperation(new ClusterPageSetNextPagePO((int)nextPage, oldNextPage));
    }

    public long getPrevPage() {
        return this.getLongValue(36);
    }

    public void setPrevPage(long prevPage) {
        int oldPrevPage = (int)this.getLongValue(36);
        this.setLongValue(36, prevPage);
        this.addPageOperation(new ClusterPageSetPrevPagePO(oldPrevPage, (int)prevPage));
    }

    public void setRecordLongValue(int recordPosition, int offset, long value) {
        long oldValue;
        assert (this.isPositionInsideInterval(recordPosition));
        int entryIndexPosition = 64 + recordPosition * 8;
        int entryPointer = this.getIntValue(entryIndexPosition);
        int entryPosition = entryPointer & 0xFFFF;
        if (offset >= 0) {
            assert (this.insideRecordBounds(entryPosition, offset, 8));
            int valueOffset = entryPosition + offset + 12;
            oldValue = this.getLongValue(valueOffset);
            this.setLongValue(valueOffset, value);
        } else {
            int recordSize = this.getIntValue(entryPosition + 8);
            assert (this.insideRecordBounds(entryPosition, recordSize + offset, 8));
            int valueOffset = entryPosition + 12 + recordSize + offset;
            oldValue = this.getLongValue(valueOffset);
            this.setLongValue(valueOffset, value);
        }
        this.addPageOperation(new ClusterPageSetRecordLongValuePO(recordPosition, offset, value, oldValue));
    }

    public long getRecordLongValue(int recordPosition, int offset) {
        assert (this.isPositionInsideInterval(recordPosition));
        int entryIndexPosition = 64 + recordPosition * 8;
        int entryPointer = this.getIntValue(entryIndexPosition);
        int entryPosition = entryPointer & 0xFFFF;
        if (offset >= 0) {
            assert (this.insideRecordBounds(entryPosition, offset, 8));
            return this.getLongValue(entryPosition + offset + 12);
        }
        int recordSize = this.getIntValue(entryPosition + 8);
        assert (this.insideRecordBounds(entryPosition, recordSize + offset, 8));
        return this.getLongValue(entryPosition + 12 + recordSize + offset);
    }

    public byte[] getRecordBinaryValue(int recordPosition, int offset, int size) {
        assert (this.isPositionInsideInterval(recordPosition));
        int entryIndexPosition = 64 + recordPosition * 8;
        int entryPointer = this.getIntValue(entryIndexPosition);
        if ((entryPointer & 0x10000) != 0) {
            return null;
        }
        int entryPosition = entryPointer & 0xFFFF;
        if (offset >= 0) {
            assert (this.insideRecordBounds(entryPosition, offset, size));
            return this.getBinaryValue(entryPosition + offset + 12, size);
        }
        int recordSize = this.getIntValue(entryPosition + 8);
        assert (this.insideRecordBounds(entryPosition, recordSize + offset, 8));
        return this.getBinaryValue(entryPosition + 12 + recordSize + offset, size);
    }

    public byte getRecordByteValue(int recordPosition, int offset) {
        assert (this.isPositionInsideInterval(recordPosition));
        int entryIndexPosition = 64 + recordPosition * 8;
        int entryPointer = this.getIntValue(entryIndexPosition);
        int entryPosition = entryPointer & 0xFFFF;
        if (offset >= 0) {
            assert (this.insideRecordBounds(entryPosition, offset, 1));
            return this.getByteValue(entryPosition + offset + 12);
        }
        int recordSize = this.getIntValue(entryPosition + 8);
        assert (this.insideRecordBounds(entryPosition, recordSize + offset, 1));
        return this.getByteValue(entryPosition + 12 + recordSize + offset);
    }

    private boolean insideRecordBounds(int entryPosition, int offset, int contentSize) {
        int recordSize = this.getIntValue(entryPosition + 8);
        return offset >= 0 && offset + contentSize <= recordSize;
    }

    private void incrementEntriesCount() {
        this.setIntValue(56, this.getRecordsCount() + 1);
    }

    private void decrementEntriesCount() {
        this.setIntValue(56, this.getRecordsCount() - 1);
    }

    private boolean isPositionInsideInterval(int recordPosition) {
        int indexesLength = this.getIntValue(60);
        return recordPosition < indexesLength;
    }

    private void doDefragmentation() {
        int size;
        int entryKind;
        int recordsCount = this.getRecordsCount();
        int freePosition = this.getIntValue(48);
        int maxEntries = recordsCount + recordsCount + 1;
        int[] positions = new int[maxEntries];
        int[] sizes = new int[maxEntries];
        int count = 0;
        int lastEntryKind = 0;
        for (int currentPosition = freePosition; currentPosition < PAGE_SIZE; currentPosition += entryKind == -1 ? -size : size) {
            size = this.getIntValue(currentPosition);
            entryKind = Integer.signum(size);
            assert (entryKind != 0);
            if (entryKind == -1 && lastEntryKind == -1) {
                int n = count - 1;
                sizes[n] = sizes[n] + size;
                continue;
            }
            positions[count] = currentPosition;
            sizes[count] = size;
            ++count;
            lastEntryKind = entryKind;
        }
        int shift = 0;
        int lastDataPosition = 0;
        int mergedDataSize = 0;
        for (int i = count - 1; i >= 0; --i) {
            int position = positions[i];
            int size2 = sizes[i];
            int entryKind2 = Integer.signum(size2);
            assert (entryKind2 != 0);
            if (entryKind2 == 1 && shift > 0) {
                int positionIndex = this.getIntValue(position + 4);
                this.setIntValue(64 + 8 * positionIndex, position + shift);
                lastDataPosition = position;
                mergedDataSize += size2;
            }
            if (mergedDataSize > 0 && (entryKind2 == -1 || i == 0)) {
                this.moveData(lastDataPosition, lastDataPosition + shift, mergedDataSize);
                mergedDataSize = 0;
            }
            if (entryKind2 != -1) continue;
            shift += -size2;
        }
        this.setIntValue(48, freePosition + shift);
    }
}

